<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Designer_Cursor extends \Bricks\Element {
    public $category     = 'Next Bricks - Cursors';
    public $name         = 'next_designer_cursor';
    public $icon         = 'fas fa-arrow-pointer';
    public $scripts      = ['next_designer_cursor'];

    public function get_label() {
        return esc_html__( 'Designer Cursor', 'bricks' );
    }

    public function set_controls() {
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Designer Cursor can only be visible on the front.', 'bricks' )))
        ];

        /*Settings*/
        $this->controls['settingsSeparator'] = [
            'label'      => esc_html__( 'Settings', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['target'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Target', 'bricks' ),
            'type'  => 'text',
            'inline' => true,
            'placeholder' => '.className',
        ];
        $this->controls['name'] = [
          'tab'            => 'content',
          'type'           => 'text',
          'hasDynamicData' => 'text',
          'label' => esc_html__( 'Name', 'bricks' ),
          'inline' => true,
          'default'        => esc_html__( 'Tony', 'bricks' ),
          'placeholder'    => esc_html__( 'Tony', 'bricks' ),
        ];
        $this->controls['type'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Attached to cursor', 'bricks' ),
            'type' => 'checkbox',
            'default' => true,
        ];
        $this->controls['zIndex'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'zIndex', 'bricks' ),
            'type'  => 'text',
            'inline' => true,
            'css' => [
              [
                'property' => 'z-index',
                'selector' => '&.next-designer-cursor--attached, &.next-designer-cursor--relative',
              ]
            ],
            'placeholder' => '9999',
        ];
        $this->controls['top'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Top', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'top',
                'selector' => '&.next-designer-cursor--relative',
              ]
            ],
            'placeholder' => '0px',
            'required' => [ 'type', '=', false],
        ];
        $this->controls['left'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Left', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'left',
                'selector' => '&.next-designer-cursor--relative',
              ]
            ],
            'placeholder' => '0px',
            'required' => [ 'type', '=', false],
        ];
        $this->controls['enableAnimation'] = [
          'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'Enable floating', 'bricks' ),
          'type' => 'checkbox',
          'required' => [ 'type', '=', false],
        ];
        $this->controls['direction'] = [
          'tab' => 'content',
          'label' => esc_html__( 'Direction', 'bricks' ),
          'type' => 'select',
          'options'     => [
            'horizontal' => 'horizontal',
            'vertical' => 'vertical',
          ],
          'inline' => true,
          'placeholder' => 'horizontal',
          'required'    => [ ['type', '=', false] , [ 'enableAnimation', '=', true ] ],
        ];
        $this->controls['floatingDuration'] = [
          'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'Duration', 'bricks' ),
          'type'  => 'number',
          'unit'  => 's',
          'inline' => true,
          'css' => [
            [
              'property' => '--floating-duration',
              'selector' => '&.next-designer-cursor--animation-enabled',
            ]
          ],
          'placeholder' => '2s',
          'required'    => [ ['type', '=', false] , [ 'enableAnimation', '=', true ] ],
        ];
        $this->controls['floatingEasing'] = [
          'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'CSS Easing', 'bricks' ),
          'type'  => 'text',
          'inline' => true,
          'css' => [
            [
              'property' => '--floating-easing',
              'selector' => '&.next-designer-cursor--animation-enabled',
            ]
          ],
          'placeholder' => 'ease-in-out',
          'required'    => [ ['type', '=', false] , [ 'enableAnimation', '=', true ] ],
        ];

        /*Display Animation (only attached)*/
        $this->controls['displayAnimationSeparator'] = [
            'label'      => esc_html__( 'Display Animation', 'bricks' ),
            'type'       => 'separator',
            'required' => [ 'type', '=', true],
        ];
        $this->controls['scale'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Scale', 'bricks' ),
            'type'  => 'text',
            'inline' => true,
            'css' => [
              [
                'property' => '--scale',
                'selector' => '&.next-designer-cursor--attached',
              ]
            ],
            'placeholder' => '0.5',
            'required' => [ 'type', '=', true],
        ];
        $this->controls['scale'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Scale', 'bricks' ),
            'type'  => 'text',
            'inline' => true,
            'css' => [
              [
                'property' => '--scale',
                'selector' => '&.next-designer-cursor--attached',
              ]
            ],
            'placeholder' => '0.5',
            'required' => [ 'type', '=', true],
        ];
        $this->controls['duration'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type'  => 'number',
            'unit' => 's',
            'inline' => true,
            'css' => [
              [
                'property' => '--duration',
                'selector' => '&.next-designer-cursor--attached',
              ]
            ],
            'placeholder' => '0.3s',
            'required' => [ 'type', '=', true],
        ];
        $this->controls['easing'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'CSS Easing', 'bricks' ),
            'type'  => 'text',
            'inline' => true,
            'css' => [
              [
                'property' => '--easing',
                'selector' => '&.next-designer-cursor--attached',
              ]
            ],
            'placeholder' => 'ease',
            'required' => [ 'type', '=', true],
        ];

        /*Pointer Icon*/
        $this->controls['pointerIconSeparator'] = [
            'label'      => esc_html__( 'Pointer Icon', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['pointerIconDimensions'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Dimensions', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => '--dimensions',
                'selector' => '.next-designer-cursor__pointer',
              ]
            ],
            'placeholder' => '24px',
        ];
        $this->controls['pointerIconRotate'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Rotate', 'bricks' ),
            'type'  => 'number',
            'unit' => 'deg',
            'inline' => true,
            'css' => [
              [
                'property' => '--rotate',
                'selector' => '.next-designer-cursor__pointer',
              ]
            ],
            'placeholder' => '-70deg',
        ];
        $this->controls['pointerIconStroke'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Stroke color', 'bricks' ),
            'type'  => 'color',
            'inline' => true,
            'css' => [
              [
                'property' => 'stroke',
                'selector' => '.next-designer-cursor__pointer',
              ]
            ],
            'default' => [
                'hex' => '#0284c7',
            ],
        ];
        $this->controls['pointerIconStrokeWidth'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Stroke width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'stroke-width',
                'selector' => '.next-designer-cursor__pointer',
              ]
            ],
            'placeholder' => '1px',
        ];
        $this->controls['pointerIconFill'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Fill', 'bricks' ),
            'type'  => 'color',
            'inline' => true,
            'css' => [
              [
                'property' => 'fill',
                'selector' => '.next-designer-cursor__pointer',
              ]
            ],
            'default' => [
                'hex' => '#0ea5e9',
            ],
        ];

        /*Pointer Name*/
        $this->controls['pointerNameSeparator'] = [
            'label'      => esc_html__( 'Pointer Name', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['pointerNamePadding'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type'  => 'spacing',
            'units' => true,
            'css' => [
              [
                'property' => 'padding',
                'selector' => '.next-designer-cursor__pointer-name',
              ]
            ],
            'default' => [
                'top' => 4,
                'right' => 8,
                'bottom' => 4,
                'left' => 8,
            ],
        ];
        $this->controls['pointerNameTop'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Top', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'top',
                'selector' => '.next-designer-cursor__pointer-name',
              ]
            ],
            'placeholder' => '12px',
        ];
        $this->controls['pointerNameLeft'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Left', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'left',
                'selector' => '.next-designer-cursor__pointer-name',
              ]
            ],
            'placeholder' => '12px',
        ];
        $this->controls['pointerNameBackground'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type'  => 'color',
            'inline' => true,
            'css' => [
              [
                'property' => 'background-color',
                'selector' => '.next-designer-cursor__pointer-name',
              ]
            ],
            'default' => [
                'hex' => '#0ea5e9',
            ],
        ];
        $this->controls['pointerNameBorder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type'  => 'border',
            'inline' => true,
            'css' => [
              [
                'property' => 'border',
                'selector' => '.next-designer-cursor__pointer-name',
              ]
            ],
            'default' => [
                'radius' => [
                  'top' => 100,
                  'right' => 100,
                  'bottom' => 100,
                  'left' => 100,
                ],
            ],
        ];
        $this->controls['pointerNameBoxShadow'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Box Shadow', 'bricks' ),
            'type'  => 'box-shadow',
            'inline' => true,
            'css' => [
              [
                'property' => 'box-shadow',
                'selector' => '.next-designer-cursor__pointer-name',
              ]
            ],
        ];
        $this->controls['pointerNameTypography'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Typography', 'bricks' ),
            'type'  => 'typography',
            'inline' => true,
            'css' => [
              [
                'property' => 'typography',
                'selector' => '.next-designer-cursor__pointer-name',
              ]
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_designer_cursor', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_designer_cursor.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $name = ! empty( $settings['name'] ) ? $settings['name'] : 'Tony';
        $type = ! empty( $settings['type'] ) ? $settings['type'] : 0;
        $target = ! empty( $settings['target'] ) ? $settings['target'] : '';
        $enableAnimation = ! empty( $settings['enableAnimation'] ) ? $settings['enableAnimation'] : 0;
        $direction = ! empty( $settings['direction'] ) ? $settings['direction'] : 'horizontal';

        if($enableAnimation == 1){
          $this->set_attribute( '_root', 'class', "next-designer-cursor--animation-enabled");

          if($direction == 'horizontal'){
            $this->set_attribute( '_root', 'class', "next-designer-cursor--animation-horizontal");
          }else if($direction == 'vertical'){
            $this->set_attribute( '_root', 'class', "next-designer-cursor--animation-vertical");
          }
        }

        $this->set_attribute( '_root', 'class', "next-designer-cursor");
        $this->set_attribute( '_root', 'class', "next-designer-cursor--to-hide");
        if($type == 'attached'){
            $this->set_attribute( '_root', 'class', "next-designer-cursor--attached");
        }else{
            $this->set_attribute( '_root', 'class', "next-designer-cursor--relative");
        }
        
        $this->set_attribute( '_root', 'data-type', $type );
        $this->set_attribute( '_root', 'data-target', $target );

        $output = "<div {$this->render_attributes( '_root' )}>";
        $output .= 
        '
        <svg class="next-designer-cursor__pointer" stroke="currentColor" fill="currentColor" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg">
            <path d="M14.082 2.182a.5.5 0 0 1 .103.557L8.528 15.467a.5.5 0 0 1-.917-.007L5.57 10.694.803 8.652a.5.5 0 0 1-.006-.916l12.728-5.657a.5.5 0 0 1 .556.103z"></path>
        </svg>
        <div class="next-designer-cursor__pointer-name">'.$name.'</div>
        ';
        $output .= '</div>';

        echo $output;
    }
}