<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Dock_Menu extends \Bricks\Element {
    public $category     = 'Next Bricks - Menus';
    public $name         = 'next_dock_menu';
    public $icon         = 'ti-menu-alt';
    public $tag      = 'div';
    public $scripts      = ['next_dock_menu'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Dock', 'bricks' );
    }

    public function set_controls() {
      $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'div' => 'div',
            'section' => 'section',
            'nav' => 'nav',
            'aside' => 'aside',
            'header' => 'header',
            'footer' => 'footer',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'div',
        'default'     => 'div',
    ];
    $this->controls['customTag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Custom tag', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'placeholder' => 'div',
        'required'    => [ 'tag', '=', 'custom' ],
    ];
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Dock items can be styled at their Style tabs. They are nestable so you can add any elements at them.', 'bricks' )))
        ];

        //Dock style
        $this->controls['dockStyleSeparator'] = [
            'label'      => esc_html__( 'Dock style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['padding'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type'  => 'spacing',
            'units' => true,
            'css' => [
              [
                'property' => 'padding',
                'selector' => '',
              ]
            ],
        ];
        $this->controls['gap'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Gap', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'gap',
                'selector' => '',
              ]
            ],
            'placeholder' => '8px',
        ];
        $this->controls['width'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'width',
                'selector' => '',
              ]
            ],
            'placeholder' => 'fit-content',
        ];
        $this->controls['height'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'height',
                'selector' => '',
              ]
            ],
            'placeholder' => 'auto',
        ];
        $this->controls['background'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type'  => 'background',
            'inline' => true,
            'css' => [
              [
                'property' => 'background',
                'selector' => '',
              ]
            ],
        ];
        $this->controls['border'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type'  => 'border',
            'inline' => true,
            'css' => [
              [
                'property' => 'border',
                'selector' => '',
              ]
            ],
            'default' => [
                'width' => [
                  'top' => 1,
                  'right' => 1,
                  'bottom' => 1,
                  'left' => 1,
                ],
                'style' => 'solid',
                'color' => [
                  'rgb' => 'rgba(255, 255, 255, 0.1)',
                ],
                'radius' => [
                  'top' => 100,
                  'right' => 100,
                  'bottom' => 100,
                  'left' => 100,
                ],
              ],
        ];
        $this->controls['boxShadow'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Box shadow', 'bricks' ),
            'type'  => 'box-shadow',
            'inline' => true,
            'css' => [
              [
                'property' => 'box-shadow',
                'selector' => '',
              ]
            ],
        ];

        //Items styles
        $this->controls['itemsSeparator'] = [
            'label'      => esc_html__( 'Items Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['ITEMbaseSize'] = [
            'label' => esc_html__( 'Dimensions', 'bricks' ),
            'type' => 'number',
            'units'      => true,
            'css'     => [
                [
                  'property' => '--dimensions',
                  'selector' => '.next-dock-menu__item',
                ],
            ],
            'rerender' => true,
            'placeholder' => '40px',
        ];
        $this->controls['ITEMbackground'] = [
            'label'       => esc_html__( 'Background', 'bricks' ),
            'type'        => 'background',
            'css'     => [
                [
                  'property' => 'background',
                  'selector' => '.next-dock-menu__item',
                ],
            ],
            'rerender' => true,
            'default' => [
                'color' => [
                  'hex' => '#2d2d2d',
                ],
            ],
        ];
        $this->controls['ITEMborder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type'  => 'border',
            'inline' => true,
            'css' => [
              [
                'property' => 'border',
                'selector' => '.next-dock-menu__item',
              ]
            ],
            'rerender' => true,
            'default' => [
                'radius' => [
                  'top' => '50%',
                  'right' => '50%',
                  'bottom' => '50%',
                  'left' => '50%',
                ],
            ],
        ];
        $this->controls['ITEMboxShadow'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Box shadow', 'bricks' ),
            'type'  => 'box-shadow',
            'inline' => true,
            'rerender' => true,
            'css' => [
              [
                'property' => 'box-shadow',
                'selector' => '.next-dock-menu__item',
              ]
            ],
        ];

        //Animation
        $this->controls['animationSeparator'] = [
            'label'      => esc_html__( 'Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['scale'] = [
            'label' => esc_html__( 'Scale', 'bricks' ),
            'type' => 'number',
            'units'      => true,
            'placeholder' => '2',
        ];
        $this->controls['activationDistance'] = [
            'label' => esc_html__( 'Activation Distance', 'bricks' ),
            'type' => 'number',
            'units'      => true,
            'placeholder' => '120',
        ];

        //Tooltip
        $this->controls['tooltipSeparator'] = [
            'label'      => esc_html__( 'Tooltip', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['tooltipNote'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Tooltip content can be edited at the Style tab of each item, at the Attributes group: data-tooltip', 'bricks' )))
        ];
        $this->controls['TOOLTIPtypography'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Typography', 'bricks' ),
            'type'  => 'typography',
            'units' => true,
            'css' => [
              [
                'property' => 'typography',
                'selector' => '.next-dock-menu__item::before',
              ]
            ],
        ];
        $this->controls['TOOLTIPpadding'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type'  => 'spacing',
            'units' => true,
            'css' => [
              [
                'property' => 'padding',
                'selector' => '.next-dock-menu__item::before',
              ]
            ],
            'placeholder' => '5px',
        ];
        $this->controls['TOOLTIPtop'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Top', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'top',
                'selector' => '.next-dock-menu__item::before',
              ]
            ],
            'placeholder' => '-28px',
        ];
        $this->controls['TOOLTIPbackground'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type'  => 'background',
            'inline' => true,
            'css' => [
              [
                'property' => 'background',
                'selector' => '.next-dock-menu__item::before',
              ]
            ],
            'default' => [
                'color' => [
                  'hex' => '#282828',
                ],
            ],
        ];
        $this->controls['TOOLTIPborder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type'  => 'border',
            'inline' => true,
            'css' => [
              [
                'property' => 'border',
                'selector' => '.next-dock-menu__item::before',
              ]
            ],
            'default' => [
                'width' => [
                  'top' => 1,
                  'right' => 1,
                  'bottom' => 1,
                  'left' => 1,
                ],
                'style' => 'solid',
                'color' => [
                  'rgb' => 'rgba(255, 255, 255, 0.04)',
                ],
                'radius' => [
                  'top' => 4,
                  'right' => 4,
                  'bottom' => 4,
                  'left' => 4,
                ],
            ],
        ];
    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Dock item', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-dock-menu__item',
                    ],
                    '_attributes' => [
                        [
                            'name' => 'data-vel-view',
                            'value' => 'item',
                        ],
                        [
                            'name' => 'data-tooltip',
                            'value' => 'Great item',
                        ],
                    ]
                ],
            ],

            [
                'name'     => 'block',
                'label'    => esc_html__( 'Dock item', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-dock-menu__item',
                    ],
                    '_attributes' => [
                        [
                            'name' => 'data-vel-view',
                            'value' => 'item',
                        ],
                        [
                            'name' => 'data-tooltip',
                            'value' => 'Great item',
                        ],
                    ]
                ],
            ],

            [
                'name'     => 'block',
                'label'    => esc_html__( 'Dock item', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-dock-menu__item',
                    ],
                    '_attributes' => [
                        [
                            'name' => 'data-vel-view',
                            'value' => 'item',
                        ],
                        [
                            'name' => 'data-tooltip',
                            'value' => 'Great item',
                        ],
                    ]
                ],
            ],

            [
                'name'     => 'block',
                'label'    => esc_html__( 'Dock item', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-dock-menu__item',
                    ],
                    '_attributes' => [
                        [
                            'name' => 'data-vel-view',
                            'value' => 'item',
                        ],
                        [
                            'name' => 'data-tooltip',
                            'value' => 'Great item',
                        ],
                    ]
                ],
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next-dock-menu', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_dock_menu.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
        wp_enqueue_script( 'next-veloxi', NEXTBRICKS_PLUGIN_URL . 'local_assets/next_veloxi.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $scale = ! empty( $settings['scale'] ) ? $settings['scale'] : 2;
        $baseSize = ! empty( $settings['baseSize'] ) ? $settings['baseSize'] : 40;
        $activationDistance = ! empty( $settings['activationDistance'] ) ? $settings['activationDistance'] : 120;

        $this->set_attribute( '_root', 'class', 'next-dock-menu' );
        $this->set_attribute( '_root', 'data-vel-plugin', 'NextBricksDock' );
        $this->set_attribute( '_root', 'data-vel-view', 'root' );

        $this->set_attribute( '_root', 'data-scale', $scale );
        $this->set_attribute( '_root', 'data-base-size', $baseSize );
        $this->set_attribute( '_root', 'data-activation-distance', $activationDistance );

        $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
        $output .= Frontend::render_children( $this );
        $output .= "</{$this->tag}>";

        echo $output;
    }
}