<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Dot_Button_V2 extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'next-dot-button-v2';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';

  public function get_label() {
    return esc_html__( 'Dot Button v2', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Dot Button v2', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['iconsSeparator'] = [
        'label'      => esc_html__( 'Icons', 'bricks' ),
        'type'       => 'separator',
      ];
      $this->controls['includeLeftIcon'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Left Icon', 'bricks' ),
        'type' => 'checkbox',
        'default' => false,
      ];
      $this->controls['leftIcon'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Icon', 'bricks' ),
        'type' => 'icon',
        'css' => [
          [
            'selector' => '&{pseudo} .nb-dot-button-v2__left-icon',
          ],
        ],
        'required'   => [ 'includeLeftIcon', '=', true ],
      ];
      $this->controls['leftIconMargin'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Margin', 'bricks' ),
        'type'  => 'spacing',
        'css'   => [
          [
            'property' => 'margin',
            'selector' => '&{pseudo} .nb-dot-button-v2__left-icon',
          ],
        ],
        'required' => [ 'includeLeftIcon', '=', true ],
      ];
      $this->controls['leftIconSize'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Size', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'css'   => [
          [
            'property' => 'font-size',
            'selector' => '&{pseudo} .nb-dot-button-v2__left-icon',
          ],
        ],
        'required' => [ 'includeLeftIcon', '=', true ],
      ];
      $this->controls['leftIconColor'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Color', 'bricks' ),
        'type'  => 'color',
        'css'   => [
          [
            'property' => 'color',
            'selector' => '&{pseudo} .nb-dot-button-v2__left-icon',
          ],
        ],
        'required' => [ 'includeLeftIcon', '=', true ],
      ];
      $this->controls['includeRightIcon'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Right Icon', 'bricks' ),
        'type' => 'checkbox',
        'default' => false,
      ];
      $this->controls['rightIcon'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Icon', 'bricks' ),
        'type' => 'icon',
        'css' => [
          [
            'selector' => '&{pseudo} .nb-dot-button-v2__right-icon',
          ],
        ],
        'required'   => [ 'includeRightIcon', '=', true ],
      ];
      $this->controls['rightIconMargin'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Margin', 'bricks' ),
        'type'  => 'spacing',
        'css'   => [
          [
            'property' => 'margin',
            'selector' => '&{pseudo} .nb-dot-button-v2__right-icon',
          ],
        ],
        'required' => [ 'includeRightIcon', '=', true ],
      ];
      $this->controls['rightIconSize'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Size', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'css'   => [
          [
            'property' => 'font-size',
            'selector' => '&{pseudo} .nb-dot-button-v2__right-icon',
          ],
        ],
        'required' => [ 'includeRightIcon', '=', true ],
      ];
      $this->controls['rightIconColor'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Color', 'bricks' ),
        'type'  => 'color',
        'css'   => [
          [
            'property' => 'color',
            'selector' => '&{pseudo} .nb-dot-button-v2__right-icon',
          ],
        ],
        'required' => [ 'includeRightIcon', '=', true ],
      ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['padding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => '--padding',
                'selector' => '&{pseudo} .nb-dot-button-v2__inner',
            ],
        ],
        'default' => [
            'top'    => 10,
            'right'  => 15, 
            'bottom' => 10,
            'left'   => 15,
        ],
    ];
    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'color' => [
                'hex' => '#000000',
              ]
        ],
    ];
    $this->controls['background'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&{pseudo} .nb-dot-button-v2__bg',
            ],
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];
    $this->controls['border'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Border', 'bricks'),
        'type'    => 'border',
        'css'     => [
          [
            'property' => 'border',
            'selector' => '&{pseudo} .nb-dot-button-v2__bg',
          ],
        ],
        'default' => [
            'radius' => [
                'top' => 8,
                'right' => 8,
                'bottom' => 8,
                'left' => 8,
            ],
        ]
    ];

    $this->controls['dotsSeparator'] = [
        'label'      => esc_html__( 'Dots', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['dotSize'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Size', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => '--btn-color-blob-dot-size',
                'selector' => '',
            ],
        ],
        'default' => 20,
    ];
    $this->controls['dotMarginLeft'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Margin Left', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => '--dot-margin-left',
                'selector' => '&{pseudo} .nb-dot-button-v2__dot',
            ],
        ],
        'default' => '0.625em',
    ];
    $this->controls['firstDotColor'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'First Dot Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background-color',
                'selector' => '&{pseudo} .nb-dot-button-v2__dot--is-first',
            ],
        ],
        'default' => [
            'hex' => '#009dff',
        ],
    ];
    $this->controls['secondDotColor'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Second Dot Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background-color',
                'selector' => '&{pseudo} .nb-dot-button-v2__dot--is-second',
            ],
        ],
        'default' => [
            'hex' => '#ff7300',
        ],
    ];
    $this->controls['thirdDotColor'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Third Dot Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background-color',
                'selector' => '&{pseudo} .nb-dot-button-v2__dot--is-third',
            ],
        ],
        'default' => [
            'hex' => '#ff0000',
        ],
    ];

    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Dots Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['dotsDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Duration', 'bricks' ),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
            [
                'property' => '--dots-duration',
                'selector' => '',
            ],
        ],
        'default' => '0.45s',
    ];
    $this->controls['dotsStagger'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Stagger', 'bricks' ),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
            [
                'property' => '--dots-stagger',
                'selector' => '',
            ],
        ],
        'default' => '0.017s',
    ];
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Dot Button v2';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $includeLeftIcon = ! empty( $settings['includeLeftIcon'] ) ? $settings['includeLeftIcon'] : 0;
    $includeRightIcon = ! empty( $settings['includeRightIcon'] ) ? $settings['includeRightIcon'] : 0;
    if ( $includeLeftIcon !== 0 ) {
      $leftIcon = self::render_icon( $settings['leftIcon'], [ 'nb-dot-button-v2__left-icon' ] );
    }else{
      $leftIcon = '';
    }
    if ( $includeRightIcon !== 0 ) {
      $rightIcon = self::render_icon( $settings['rightIcon'], [ 'nb-dot-button-v2__right-icon' ] );
    }else{
      $rightIcon = '';
    }

    $this->set_attribute( '_root', 'class', 'nb-dot-button-v2' );

    $output = "
    <$root_tag  {$this->render_attributes( '_root' )}>
        <span style='--parent-index: 2;' class='nb-dot-button-v2__dot-wrap'>
            <span style='--index: 2;' class='nb-dot-button-v2__dot nb-dot-button-v2__dot--is-third'></span>
        </span>
        <span style='--parent-index: 1;' class='nb-dot-button-v2__dot-wrap'>
            <span style='--index: 1;' class='nb-dot-button-v2__dot nb-dot-button-v2__dot--is-second'></span>
        </span>
        <span style='--parent-index: 0;' class='nb-dot-button-v2__dot-wrap'>
            <span style='--index: 0;' class='nb-dot-button-v2__dot nb-dot-button-v2__dot--is-first'></span>
        </span>
        <span class='nb-dot-button-v2__bg'></span>
        <span class='nb-dot-button-v2__inner'>
            <span class='nb-dot-button-v2__text'>$leftIcon$inner_title$rightIcon</span>
        </span>
    </$root_tag>
    ";

	echo $output;
  }
}