<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Dynamic_Island extends \Bricks\Element {
    public $category     = 'Next Bricks - Menus';
    public $name         = 'next-dynamic-island';
    public $icon         = 'fas fa-bars-progress';
    public $tag      = 'nav';
    public $scripts      = ['next_dynamic_island'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Dynamic Island', 'bricks' );
    }

    public function set_controls() {
        $this->controls['tag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'HTML tag', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'div' => 'div',
                'section' => 'section',
                'nav' => 'nav',
                'aside' => 'aside',
                'header' => 'header',
                'footer' => 'footer',
                'custom' => 'custom',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'nav',
            'default'     => 'nav',
        ];
        $this->controls['customTag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Custom tag', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'placeholder' => 'nav',
            'required'    => [ 'tag', '=', 'custom' ],
        ];
        /* Builder */
        $this->controls['openAtBuilder'] = [
            'label'       => esc_html__( 'Open at Bricks', 'bricks' ),
            'type'        => 'checkbox',
            'default'     => false,
        ];
        /* Settings */
        $this->controls['note0'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Dynamic Island creates a TOC inside it with the elements that match the following TOC Selector.<br>It is also a nestable element so you can place any elements at it.<br>You can combine both approaches or leave TOC Selector empty if you dont require it.', 'bricks' )))
        ];
        $this->controls['selector'] = [
            'label'       => esc_html__( 'TOC Selector', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'default' => 'h2',
            'placeholder' => '.class, #id, tag...',
        ];
        $this->controls['note2'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'The space left at the TOC Selector targets when scrolling to them.', 'bricks' )))
        ];
        $this->controls['scrollMarginTop'] = [
            'label'       => esc_html__( 'Scroll Margin Top', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'default' => '20px',
        ];
        $this->controls['note3'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'To place the TOC before the nested elements (Column) or the other way around (Column Reverse)', 'bricks' )))
        ];
        $this->controls['linksWrapperDirection'] = [
            'label'       => esc_html__( 'Direction', 'bricks' ),
            'type'        => 'select',
            'inline'      => true,
            'options'     => [
                'column' => 'Column',
                'column-reverse' => 'Column Reverse'
            ],
            'default' => 'column',
        ];

        /* Island Style */
        $this->controls['islandStyleSeparator'] = [
            'label'      => esc_html__( 'Island Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['islandPosition'] = [
            'label'       => esc_html__( 'Position', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'css' => [
                [
                    'property' => 'position',
                    'selector' => '.nb-dynamic-island__container',
                ],
            ],
            'default' => 'fixed',
        ];
        $this->controls['islandZIndex'] = [
            'label'       => esc_html__( 'Z-Index', 'bricks' ),
            'type'        => 'number',
            'inline'      => true,
            'css' => [
                [
                    'property' => 'z-index',
                    'selector' => '.nb-dynamic-island__container',
                ],
            ],
            'default' => '40',
        ];
        $this->controls['islandTop'] = [
            'label'       => esc_html__( 'Top', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'inline'      => true,
            'css' => [
                [
                    'property' => 'top',
                    'selector' => '.nb-dynamic-island__container',
                ],
            ],
            'default' => 20,
        ];
        $this->controls['islandLeft'] = [
            'label'       => esc_html__( 'Left', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'inline'      => true,
            'css' => [
                [
                    'property' => '--left',
                    'selector' => '.nb-dynamic-island__container',
                ],
            ],
            'default' => '50%',
        ];
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'A defined width is recommended for animations to work smoothly.', 'bricks' )))
        ];
        $this->controls['islandWidth'] = [
            'label'       => esc_html__( 'Width', 'bricks' ),
            'type'        => 'number',
            'units'        => true,
            'inline'      => true,
            'css' => [
                [
                    'property' => 'width',
                    'selector' => '.nb-dynamic-island__container',
                ],
            ],
            'default' => 240,
        ];
        $this->controls['expandWidth'] = [
            'label'       => esc_html__( 'Expanded Width', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'default' => 320,
        ];
        $this->controls['dimensionsDuration'] = [
            'label'       => esc_html__( 'Expanded Duration', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'default' => '0.5s',
        ];
        $this->controls['dimensionsEase'] = [
            'label'       => esc_html__( 'Expanded GSAP Easing', 'bricks' ),
            'type' => 'select',
            'inline'      => true,
            'options'     => [
              'none' => 'none',
              'power1' => 'power1',
              'power2' => 'power2',
              'power3' => 'power3',
              'power4' => 'power4',
              'back' => 'back',
              'bounce' => 'bounce',
              'circ' => 'circ',
              'elastic' => 'elastic',
              'expo' => 'expo',
              'sine' => 'sine',
              'steps' => 'steps'
            ],
            'default' => 'back',
        ];
        $this->controls['islandBackground'] = [
            'label'       => esc_html__( 'Background', 'bricks' ),
            'type'        => 'color',
            'inline'      => true,
            'css' => [
                [
                    'property' => 'background',
                    'selector' => '.nb-dynamic-island__container',
                ],
            ],
            'default' => [
                'hex' => '#1a1a1a',
            ],
        ];
        $this->controls['islandBorder'] = [
            'label'       => esc_html__( 'Border', 'bricks' ),
            'type'        => 'border',
            'inline'      => true,
            'css' => [
                [
                    'property' => 'border',
                    'selector' => '.nb-dynamic-island__container',
                ],
            ],
            'default' => [
                'radius' => [
                  'top' => 22,
                  'right' => 22,
                  'bottom' => 22,
                  'left' => 22,
                ],
            ],
        ];

        /* Island Style */
        $this->controls['islandHeaderStyleSeparator'] = [
            'label'      => esc_html__( 'Island Header Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['islandHeaderPadding'] = [
            'label'       => esc_html__( 'Padding', 'bricks' ),
            'type'        => 'spacing',
            'css' => [
                [
                    'property' => 'padding',
                    'selector' => '.nb-dynamic-island__header',
                ],
            ],
            'default' => [
                'top' => 8,
                'right' => 16, 
                'bottom' => 8,
                'left' => 16
            ],
        ];
        $this->controls['islandHeaderGap'] = [
            'label'       => esc_html__( 'Gap', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css' => [
                [
                    'property' => 'gap',
                    'selector' => '.nb-dynamic-island__header',
                ],
            ],
            'default' => 8,
        ];

        /* Progress Style */
        $this->controls['progressStyleSeparator'] = [
            'label'      => esc_html__( 'Progress Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['progressDimensions'] = [
            'label'       => esc_html__( 'Dimensions', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css' => [
                [
                    'property' => '--dimensions',
                    'selector' => '.nb-dynamic-island__progress',
                ],
            ],
            'default' => 28,
        ];
        $this->controls['progressThickness'] = [
            'label'       => esc_html__( 'Thickness', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css' => [
                [
                    'property' => '--thickness',
                    'selector' => '.nb-dynamic-island__progress',
                ],
            ],
            'default' => 10,
        ];
        $this->controls['progressColor'] = [
            'label'       => esc_html__( 'Color', 'bricks' ),
            'type'        => 'color',
            'css' => [
                [
                    'property' => 'stroke',
                    'selector' => '.nb-dynamic-island__progress-bar',
                ],
            ],
            'default' => [
                'hex' => '#ffffff',
            ],
        ];
        $this->controls['progressBackgroundColor'] = [
            'label'       => esc_html__( 'Background Color', 'bricks' ),
            'type'        => 'color',
            'css' => [
                [
                    'property' => 'stroke',
                    'selector' => '.nb-dynamic-island__progress-bg',
                ],
            ],
            'default' => [
                'hex' => '#333333',
            ],
        ];
        $this->controls['progressDuration'] = [
            'label'       => esc_html__( 'Duration', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css' => [
                [
                    'property' => '--progress-bar-duration',
                    'selector' => '.nb-dynamic-island__progress-bar',
                ],
            ],
            'default' => '0.3s',
        ];
        $this->controls['progressEase'] = [
            'label'       => esc_html__( 'CSS Easing', 'bricks' ),
            'type'        => 'text',
            'css' => [
                [
                    'property' => '--progress-bar-ease',
                    'selector' => '.nb-dynamic-island__progress-bar',
                ],
            ],
            'default' => 'none',
        ];

        /* Typography */
        $this->controls['typographySeparator'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Texts', 'bricks' ),
            'type'  => 'separator',
        ];
        $this->controls['inner_title'] = [
            'tab'            => 'content',
            'type'           => 'textarea',
            'hasDynamicData' => 'text',
            'label' => esc_html__( 'Title', 'bricks' ),
            'default'        => esc_html__( 'Nature Landscape', 'bricks' ),
            'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
        ];
        $this->controls['titleTypography'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Title Typography', 'bricks' ),
            'type'    => 'typography',
            'css'     => [
                [
                    'property' => 'typography',
                    'selector' => '.nb-dynamic-island__title',
                ],
            ],
            'default' => [
                'font-size'   => '15px',
                'font-weight' => '500',
                'color'  => [
                    'hex' => '#ffffff',
                ],
            ],
        ];
        $this->controls['percentageTypography'] = [
            'tab'     => 'content', 
            'label'   => esc_html__( 'Percentage Typography', 'bricks' ),
            'type'    => 'typography',
            'css'     => [
                [
                    'property' => 'typography',
                    'selector' => '.nb-dynamic-island__percentage',
                ],
            ],
            'default' => [
                'font-size'  => '14px',
                'color' => [
                    'hex' => '#ffffff',
                ],
            ],
        ];
        $this->controls['linksTypography'] = [
            'tab'     => 'content', 
            'label'   => esc_html__( 'Links Typography', 'bricks' ),
            'type'    => 'typography',
            'css'     => [
                [
                    'property' => 'typography',
                    'selector' => '.nb-dynamic-island__link',
                ],
            ],
            'default' => [
                'font-size'  => '14px',
                'color' => [
                    'hex' => '#999',
                ],
            ],
        ];
        $this->controls['linkHoverColor'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Links Hover Color', 'bricks' ),
            'type'    => 'color',
            'css'     => [
                [
                    'property' => 'color',
                    'selector' => '.nb-dynamic-island__link:hover',
                ],
            ],
            'default' => [
                'hex' => '#ffffff',
            ],
        ];
        $this->controls['linkHoverDuration'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Links Hover Duration', 'bricks' ),
            'type'    => 'number',
            'unit'   => 's',
            'css'     => [
                [
                    'property' => '--link-color-duration',
                    'selector' => '.nb-dynamic-island__link',
                ],
            ],
            'default' => '0.2s',
        ];

        $this->controls['linkHoverEase'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Links Hover CSS Easing', 'bricks' ),
            'type'    => 'text',
            'css'     => [
                [
                    'property' => '--link-color-ease', 
                    'selector' => '.nb-dynamic-island__link',
                ],
            ],
            'default' => 'ease',
        ];

        /* Links Wrapper Styles */
        $this->controls['linksWrapperStyleSeparator'] = [
            'label'      => esc_html__( 'Links Wrapper Styles', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['linksWrapperPadding'] = [
            'label'       => esc_html__( 'Padding', 'bricks' ),
            'type'        => 'spacing',
            'css' => [
                [
                    'property' => 'padding',
                    'selector' => '.nb-dynamic-island__nav-wrapper',
                ],
            ],
            'default' => [
                'top' => 8,
                'right' => 16, 
                'bottom' => 16,
                'left' => 16
            ],
        ];
        $this->controls['linksWrapperGap'] = [
            'label'       => esc_html__( 'Gap', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css' => [
                [
                    'property' => 'gap',
                    'selector' => '.nb-dynamic-island__nav-wrapper',
                ],
            ],
            'default' => 8,
        ];
        $this->controls['linksContainerOpacityDuration'] = [
            'label'       => esc_html__( 'Fade Duration', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'default' => '0.3s',
        ];
        $this->controls['linksContainerOpacityEase'] = [
            'label'       => esc_html__( 'Fade GSAP Easing', 'bricks' ),
            'type'        => 'select',
            'inline'      => true,
            'options'     => [
              'none' => 'none',
              'power1' => 'power1',
              'power2' => 'power2',
              'power3' => 'power3',
              'power4' => 'power4',
              'back' => 'back',
              'bounce' => 'bounce',
              'circ' => 'circ',
              'elastic' => 'elastic',
              'expo' => 'expo',
              'sine' => 'sine',
              'steps' => 'steps'
            ],
            'default' => 'power3',
        ];

        /* Overlay Styles */
        $this->controls['overlayStyleSeparator'] = [
            'label'      => esc_html__( 'Overlay Styles', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['overlayZIndex'] = [
            'label'       => esc_html__( 'Z-Index', 'bricks' ),
            'type'        => 'number',
            'css' => [
                [
                    'property' => 'z-index',
                    'selector' => '.nb-dynamic-island__overlay',
                ],
            ],
            'default' => 30,
        ];
        $this->controls['overlayBlur'] = [
            'label'       => esc_html__( 'Blur', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css' => [
                [
                    'property' => '--blur',
                    'selector' => '.nb-dynamic-island__overlay',
                ],
            ],
            'default' => 8,
        ];
        $this->controls['overlayBackground'] = [
            'label'       => esc_html__( 'Background', 'bricks' ),
            'type'        => 'color',
            'css' => [
                [
                    'property' => 'background',
                    'selector' => '.nb-dynamic-island__overlay',
                ],
            ],
            'default' => [
                'rgb' => 'rgba(255, 255, 255, 0.3)',
            ],
        ];  
        $this->controls['overlayOpacityDuration'] = [
            'label'       => esc_html__( 'Fade Duration', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'default' => '0.5s',
        ];
        $this->controls['overlayOpacityEase'] = [
            'label'       => esc_html__( 'Fade GSAP Easing', 'bricks' ),
            'type'        => 'select',
            'inline'      => true,
            'options'     => [
              'none' => 'none',
              'power1' => 'power1',
              'power2' => 'power2',
              'power3' => 'power3',
              'power4' => 'power4',
              'back' => 'back',
              'bounce' => 'bounce',
              'circ' => 'circ',
              'elastic' => 'elastic',
              'expo' => 'expo',
              'sine' => 'sine',
              'steps' => 'steps'
            ],
            'default' => 'power3',
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next-dynamic-island', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_dynamic_island.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $openAtBuilder = !empty($settings['openAtBuilder']) ? $settings['openAtBuilder'] : false;
        $inner_title = !empty($settings['inner_title']) ? $settings['inner_title'] : '';
        $selector = !empty($settings['selector']) ? $settings['selector'] : '';
        $scrollMarginTop = !empty($settings['scrollMarginTop']) ? $settings['scrollMarginTop'] : '20px';
        $expandWidth = !empty($settings['expandWidth']) ? $settings['expandWidth'] : 320;
        $dimensionsDuration = !empty($settings['dimensionsDuration']) ? $settings['dimensionsDuration'] : 0.5;
        $dimensionsEase = !empty($settings['dimensionsEase']) ? $settings['dimensionsEase'] : 'back';
        $overlayOpacityDuration = !empty($settings['overlayOpacityDuration']) ? $settings['overlayOpacityDuration'] : 0.5;
        $overlayOpacityEase = !empty($settings['overlayOpacityEase']) ? $settings['overlayOpacityEase'] : 'power3';
        $linksContainerOpacityDuration = !empty($settings['linksContainerOpacityDuration']) ? $settings['linksContainerOpacityDuration'] : 0.3;
        $linksContainerOpacityEase = !empty($settings['linksContainerOpacityEase']) ? $settings['linksContainerOpacityEase'] : 'power3';
        $linksWrapperDirection = !empty($settings['linksWrapperDirection']) ? $settings['linksWrapperDirection'] : 'column';

        if($openAtBuilder){
            $this->set_attribute('_root', 'data-open-at-builder', '1');
        }
        $this->set_attribute('_root', 'data-selector', $selector);
        $this->set_attribute('_root', 'data-scroll-margin-top', $scrollMarginTop);
        $this->set_attribute('_root', 'data-expand-width', $expandWidth);
        $this->set_attribute('_root', 'data-dimensions-duration', $dimensionsDuration);
        $this->set_attribute('_root', 'data-dimensions-ease', $dimensionsEase);
        $this->set_attribute('_root', 'data-overlay-opacity-duration', $overlayOpacityDuration);
        $this->set_attribute('_root', 'data-overlay-opacity-ease', $overlayOpacityEase);
        $this->set_attribute('_root', 'data-links-container-opacity-duration', $linksContainerOpacityDuration);
        $this->set_attribute('_root', 'data-links-container-opacity-ease', $linksContainerOpacityEase);
        $this->set_attribute('_root', 'data-links-wrapper-direction', $linksWrapperDirection);

        $this->set_attribute( '_root', 'class', 'nb-dynamic-island' );
        $this->set_attribute( '_root', 'data-flickering', '1' );

        $output = "<div {$this->render_attributes( '_root' )}>";
            $output .= '<div class="nb-dynamic-island__container" tabindex="0" role="button" aria-expanded="false" aria-controls="dynamic-island-nav">';
                $output .= '<div class="nb-dynamic-island__header">
                                <div class="nb-dynamic-island__progress">
                                    <svg viewBox="0 0 100 100">
                                        <circle cx="50" cy="50" r="40" class="nb-dynamic-island__progress-bg"/>
                                        <circle cx="50" cy="50" r="40" class="nb-dynamic-island__progress-bar"/>
                                    </svg>
                                </div>
                                <span class="nb-dynamic-island__title">'.$inner_title.'</span>
                                <span class="nb-dynamic-island__percentage">0%</span>
                            </div>';
                $output .= "<{$this->tag} class='nb-dynamic-island__nav' id='dynamic-island-nav'>";
                    $output .= '<div class="nb-dynamic-island__nav-wrapper">';
                    $output .= Frontend::render_children( $this );
                    $output .= "</div>";
                $output .= "</{$this->tag}>";
            $output .= '</div>';
            $output .= '<div class="nb-dynamic-island__overlay"></div>';
        $output .= '</div>';

        echo $output;
    }
}