<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Fluids extends \Bricks\Element {
    public $category     = 'Next Bricks - Backgrounds';
    public $name         = 'next_fluids';
    public $icon         = 'fas fa-fire-flame-curved';
    public $tag      = 'div';
    public $scripts      = ['next_fluids'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Fluids', 'bricks' );
    }

    public function set_controls() {
        $this->controls['tag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'HTML tag', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'div' => 'div',
                'section' => 'section',
                'article' => 'article',
                'aside' => 'aside',
                'header' => 'header',
                'footer' => 'footer',
                'main' => 'main',
                'nav' => 'nav',
                'custom' => 'custom',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'div',
            'default'     => 'div',
        ];
        $this->controls['customTag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Custom tag', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'placeholder' => 'div',
            'required'    => [ 'tag', '=', 'custom' ],
        ];
        $this->controls['width'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => 'width',
                    'selector' => '',
                ],
            ],
            'placeholder' => '100vw',
        ];
        $this->controls['height'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => 'height',
                    'selector' => '',
                ],
            ],
            'placeholder' => '100vh',
        ];
        $this->controls['background'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type'  => 'color',
            'css'   => [
                [
                    'property' => 'background-color',
                    'selector' => '',
                ],
            ],
            'default' => [
                'hex' => '#000000',
            ],
            'rerender' => true,
        ];

        /*Animation*/
        $this->controls['animationSeparator'] = [
            'label'      => esc_html__( 'Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['disablebuilder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
            'type'     => 'checkbox',
            'default' => false,
        ];
        $this->controls['disableTouch'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Disable at touch devices', 'bricks' ),
            'type'     => 'checkbox',
            'default' => false,
        ];
        $this->controls['trigger'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Trigger on', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'click' => 'click',
                'hover' => 'hover',
            ],
            'small' => true,
            'inline' => true,
            'placeholder' => 'click',
        ];
        $this->controls['initialAnim'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Entrance Animation', 'bricks' ),
            'type'     => 'checkbox',
            'default' => true,
        ];
        $this->controls['disableEntranceTouch'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Disable Entrance at touch devices', 'bricks' ),
            'type'     => 'checkbox',
            'default' => false,
        ];
        $this->controls['densityDiffusion'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Density Diffusion', 'bricks' ),
            'type'     => 'text',
            'inline' => true,
            'small' => true,
            'placeholder' => '1.0',
        ];
        $this->controls['velocityDiffusion'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Velocity Diffusion', 'bricks' ),
            'type'     => 'text',
            'inline' => true,
            'small' => true,
            'placeholder' => '0.2',
        ];
        $this->controls['pressure'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Pressure', 'bricks' ),
            'type'     => 'text',
            'inline' => true,
            'small' => true,
            'placeholder' => '0.8',
        ];
        $this->controls['pressureIterations'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Pressure Iterations', 'bricks' ),
            'type'     => 'text',
            'inline' => true,
            'small' => true,
            'placeholder' => '20',
        ];
        $this->controls['curl'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Vorticity', 'bricks' ),
            'type'     => 'text',
            'inline' => true,
            'small' => true,
            'placeholder' => '30',
        ];
        $this->controls['splatRadius'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Splat Radius', 'bricks' ),
            'type'     => 'text',
            'inline' => true,
            'small' => true,
            'placeholder' => '0.25',
        ];
        $this->controls['splatForce'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Splat Force', 'bricks' ),
            'type'     => 'text',
            'inline' => true,
            'small' => true,
            'placeholder' => '6000',
        ];
        $this->controls['enableShading'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Enable Shading', 'bricks' ),
            'type'     => 'checkbox',
            'default' => true,
        ];
        $this->controls['enableColorful'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Enable Colorful', 'bricks' ),
            'type'     => 'checkbox',
            'default' => true,
        ];

        // Add new custom color control
        $this->controls['customColor'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Custom Color', 'bricks' ),
            'type' => 'color',
            'css' => [],
            'default' => [
                'hex' => '#ff0000',
            ],
            'required' => [ 'enableColorful', '=', false ],
            'rerender' => true,
        ];

        /*Bloom*/
        $this->controls['bloomSeparator'] = [
            'label'      => esc_html__( 'Bloom', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['enableBloom'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Enable Bloom', 'bricks' ),
            'type'     => 'checkbox',
            'default' => true,
        ];
        $this->controls['bloomIterations'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Iterations', 'bricks' ),
            'type'     => 'text',
            'inline' => true,
            'small' => true,
            'placeholder' => '8',
            'required' => [ 'enableBloom', '=', true ],
        ];
        $this->controls['bloomIntensity'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Intensity', 'bricks' ),
            'type'     => 'text',
            'inline' => true,
            'small' => true,
            'placeholder' => '0.8',
            'required' => [ 'enableBloom', '=', true ],
        ];
        $this->controls['bloomThreshold'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Threshold', 'bricks' ),
            'type'     => 'text',
            'inline' => true,
            'small' => true,
            'placeholder' => '0.6',
            'required' => [ 'enableBloom', '=', true ],
        ];
            
        /*Sunrays*/
        $this->controls['sunraysSeparator'] = [
            'label'      => esc_html__( 'Sunrays', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['enableSunrays'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Enable Sunrays', 'bricks' ),
            'type'     => 'checkbox',
            'default' => true,
        ];
        $this->controls['sunraysWeight'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Weight', 'bricks' ),
            'type'     => 'text',
            'inline' => true,
            'small' => true,
            'placeholder' => '1.0',
            'required' => [ 'enableSunrays', '=', true ],
        ];
    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Content', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-fluids__content',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Heading', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Fluids', 'bricks' ),
                            'tag'  => 'h3',
                        ],
                    ]
                ]
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_fluids', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_fluids.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        /*Animation*/
        $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
        $disableTouch      = ! empty( $settings['disableTouch'] ) ? $settings['disableTouch'] : 0;
        $disableEntranceTouch = ! empty( $settings['disableEntranceTouch'] ) ? $settings['disableEntranceTouch'] : 0;
        $trigger           = ! empty( $settings['trigger'] ) ? $settings['trigger'] : 'click';
        $initialAnim       = ! empty( $settings['initialAnim'] ) ? $settings['initialAnim'] : 0;
        $densityDiffusion  = ! empty( $settings['densityDiffusion'] ) ? $settings['densityDiffusion'] : 1.0;
        $velocityDiffusion = ! empty( $settings['velocityDiffusion'] ) ? $settings['velocityDiffusion'] : 0.2;
        $pressure          = ! empty( $settings['pressure'] ) ? $settings['pressure'] : 0.8;
        $pressureIterations = ! empty( $settings['pressureIterations'] ) ? $settings['pressureIterations'] : 20;
        $curl              = ! empty( $settings['curl'] ) ? $settings['curl'] : 30;
        $splatRadius       = ! empty( $settings['splatRadius'] ) ? $settings['splatRadius'] : 0.25;
        $splatForce        = ! empty( $settings['splatForce'] ) ? $settings['splatForce'] : 6000;
        $enableShading     = ! empty( $settings['enableShading'] ) ? $settings['enableShading'] : 0;
        $enableColorful    = ! empty( $settings['enableColorful'] ) ? $settings['enableColorful'] : 0;

        /*Bloom*/
        $enableBloom       = ! empty( $settings['enableBloom'] ) ? $settings['enableBloom'] : 0;
        $bloomIterations   = ! empty( $settings['bloomIterations'] ) ? $settings['bloomIterations'] : 8;
        $bloomIntensity    = ! empty( $settings['bloomIntensity'] ) ? $settings['bloomIntensity'] : 0.8;
        $bloomThreshold    = ! empty( $settings['bloomThreshold'] ) ? $settings['bloomThreshold'] : 0.6;

        /*Sunrays*/
        $enableSunrays     = ! empty( $settings['enableSunrays'] ) ? $settings['enableSunrays'] : 0;
        $sunraysWeight     = ! empty( $settings['sunraysWeight'] ) ? $settings['sunraysWeight'] : 1.0;

        $customColor = ! empty( $settings['customColor'] ) ? $settings['customColor'] : ['hex' => '#ff0000'];

        $this->set_attribute( '_root', 'class', "next-fluids");

        /*Animation*/
        $this->set_attribute( '_root', 'data-disable-builder', $disablebuilder);
        $this->set_attribute( '_root', 'data-disable-touch', $disableTouch);
        $this->set_attribute( '_root', 'data-disable-entrance-touch', $disableEntranceTouch);
        $this->set_attribute( '_root', 'data-trigger', $trigger);
        $this->set_attribute( '_root', 'data-initial-anim', $initialAnim);
        $this->set_attribute( '_root', 'data-density-diffusion', $densityDiffusion);
        $this->set_attribute( '_root', 'data-velocity-diffusion', $velocityDiffusion);
        $this->set_attribute( '_root', 'data-pressure', $pressure);
        $this->set_attribute( '_root', 'data-pressure-iterations', $pressureIterations);
        $this->set_attribute( '_root', 'data-curl', $curl);
        $this->set_attribute( '_root', 'data-splat-radius', $splatRadius);
        $this->set_attribute( '_root', 'data-splat-force', $splatForce);
        $this->set_attribute( '_root', 'data-enable-shading', $enableShading);
        $this->set_attribute( '_root', 'data-enable-colorful', $enableColorful);

        /*Bloom*/
        $this->set_attribute( '_root', 'data-enable-bloom', $enableBloom);
        $this->set_attribute( '_root', 'data-bloom-iterations', $bloomIterations);
        $this->set_attribute( '_root', 'data-bloom-intensity', $bloomIntensity);
        $this->set_attribute( '_root', 'data-bloom-threshold', $bloomThreshold);

        /*Sunrays*/
        $this->set_attribute( '_root', 'data-enable-sunrays', $enableSunrays);
        $this->set_attribute( '_root', 'data-sunrays-weight', $sunraysWeight);

        $this->set_attribute( '_root', 'data-custom-color', $customColor['hex']);

        $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
        $output .= '<canvas class="next-fluids__canvas"></canvas>';
        $output .= Frontend::render_children( $this );
        $output .= "</{$this->tag}>";

        echo $output;
    }
}