<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Focus_Nav extends \Bricks\Element {
    public $category     = 'Next Bricks - Menus';
    public $name         = 'next-focus-nav';
    public $icon         = 'ti-menu-alt';
    public $tag      = 'nav';
    public $scripts      = ['next_focus_nav'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Focus Nav', 'bricks' );
    }

    public function set_controls() {
        $this->controls['tag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'HTML tag', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'div' => 'div',
                'section' => 'section',
                'nav' => 'nav',
                'aside' => 'aside',
                'header' => 'header',
                'footer' => 'footer',
                'custom' => 'custom',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'nav',
            'default'     => 'nav',
        ];
        $this->controls['customTag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Custom tag', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'placeholder' => 'nav',
            'required'    => [ 'tag', '=', 'custom' ],
        ];
        $this->controls['navDirection'] = [
            'label'       => esc_html__( 'Direction', 'bricks' ),
            'type'        => 'select',
            'inline'      => true,
            'options'     => [
                'row' => 'row',
                'column' => 'column',
            ],
            'css'     => [
                [
                    'property' => 'flex-direction',
                    'selector' => '',
                ],
            ],
            'default' => 'column',
        ];
        $this->controls['event'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Event', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'hover' => 'hover',
                'click' => 'click',
            ],
            'inline'      => true,
            'default' => 'hover',
        ];
        $this->controls['activeItemPagename'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( "Page name as active item", 'bricks' ),
            'type' => 'checkbox',
            'default' => false,
        ]; 
        $this->controls['activeitem'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Active Item', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'default' => '1',
            'required' => [ 'activeItemPagename', '!=', true],
        ];

        /* Nav Style */
        $this->controls['navStyleSeparator'] = [
            'label'      => esc_html__( 'Nav Items Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['navPadding'] = [
            'label'       => esc_html__( 'Padding', 'bricks' ),
            'type'        => 'spacing',
            'css'     => [
                [
                    'property' => 'padding',
                    'selector' => '.nb-focus-nav__item',
                ],
            ],
            'default' => [
                'top' => 12,
                'right' => 20,
                'bottom' => 12,
                'left' => 20,
            ] 
        ];
        $this->controls['typographySeparator'] = [
            'label'      => esc_html__( 'Typography', 'bricks' ),
            'type'       => 'typography',
            'css'     => [
                [
                    'property' => 'typography',
                    'selector' => '.nb-focus-nav__item',
                ],
            ],
            'default' => [
                'font-size' => '20px',
                'font-weight' => '500',
            ],
        ];

        /* Corners Style */
        $this->controls['cornersStyleSeparator'] = [
            'label'      => esc_html__( 'Corners Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['cornerColor'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Color', 'bricks' ),
            'type'        => 'color',
            'css' => [
                [
                    'property' => '--corner-color',
                    'selector' => '',
                ]
            ],
            'default' => [
                'hex' => '#ffffff',
            ],
        ];
        $this->controls['cornerThickness'] = [
            'tab'         => 'content', 
            'label'       => esc_html__( 'Thickness', 'bricks' ),
            'type'        => 'number',
            'units'        => true,
            'css' => [
                [
                    'property' => '--corner-thickness',
                    'selector' => '',
                ]
            ],
            'default'     => '1px',
        ];
        $this->controls['cornerWidth'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Width', 'bricks' ),
            'type'        => 'number',
            'units'        => true,
            'css' => [
                [
                    'property' => '--corner-width',
                    'selector' => '',
                ]
            ],
            'default'     => '8px',
        ];
        $this->controls['cornerHeight'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Height', 'bricks' ),
            'type'        => 'number',
            'units'        => true,
            'css' => [
                [
                    'property' => '--corner-height',
                    'selector' => '',
                ]
            ],
            'default'     => '8px',
        ];

        /* Display Animation */
        $this->controls['displayAnimationSeparator'] = [
            'label'      => esc_html__( 'Display Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['displayDuration'] = [
            'label'       => esc_html__( 'Duration', 'bricks' ),
            'type'        => 'number',
            'unit'      => 's',
            'inline'      => true,
            'default' => '0.3s',
        ];
        $this->controls['displayStagger'] = [
            'label'       => esc_html__( 'Stagger', 'bricks' ),
            'type'        => 'number',
            'inline'      => true,
            'default' => '0.05',
        ];
        $this->controls['displayEase'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'GSAP easing', 'bricks' ),
            'type' => 'select',
            'options'     => [
              'none' => 'none',
              'power1' => 'power1',
              'power2' => 'power2',
              'power3' => 'power3',
              'power4' => 'power4',
              'back' => 'back',
              'bounce' => 'bounce',
              'circ' => 'circ',
              'elastic' => 'elastic',
              'expo' => 'expo',
              'sine' => 'sine',
              'steps' => 'steps'
            ],
            'inline' => true,
            'default' => 'sine',
        ];

        /* Morphing Animation */
        $this->controls['morphingAnimationSeparator'] = [
            'label'      => esc_html__( 'Morphing Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['morphingDuration'] = [
            'label'       => esc_html__( 'Duration', 'bricks' ),
            'type'        => 'number',
            'unit'      => 's',
            'inline'      => true,
            'default' => '0.3s',
        ];  
        $this->controls['morphingEase'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'GSAP easing', 'bricks' ),
            'type' => 'select',
            'options'     => [
              'none' => 'none',
              'power1' => 'power1',
              'power2' => 'power2',
              'power3' => 'power3',
              'power4' => 'power4',
              'back' => 'back',
              'bounce' => 'bounce',
              'circ' => 'circ',
              'elastic' => 'elastic',
              'expo' => 'expo',
              'sine' => 'sine',
              'steps' => 'steps'
            ],
            'inline' => true,
            'default' => 'power2',
        ];

        /* Color Animation */
        $this->controls['colorAnimationSeparator'] = [
            'label'      => esc_html__( 'Color Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['colorActive'] = [
            'label'       => esc_html__( 'Active Color', 'bricks' ),
            'type'        => 'color',
            'inline'      => true,
            'css' => [
                [
                    'property' => '--color-active',
                    'selector' => '',
                ],
            ],
            'default' => [
                'hex' => '#fff',
            ],
        ];
        $this->controls['colorDuration'] = [
            'label'       => esc_html__( 'Duration', 'bricks' ),
            'type'        => 'number',
            'unit'      => 's',
            'inline'      => true,
            'css' => [
                [
                    'property' => '--color-duration',
                    'selector' => '',
                ],
            ],
            'default' => '0.3s',
        ];
        $this->controls['colorEase'] = [
            'label'       => esc_html__( 'Ease', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'css' => [
                [
                    'property' => '--color-ease',
                    'selector' => '',
                ],
            ],
            'default' => 'ease',
        ];
    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Focus Item', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'nb-focus-nav__item',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Heading', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Home', 'bricks' ),
                            'tag'  => 'span',
                        ],
                    ],
                ],
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Focus Item', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'nb-focus-nav__item',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Heading', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Portfolio', 'bricks' ),
                            'tag'  => 'span',
                        ],
                    ],
                ],
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Focus Item', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'nb-focus-nav__item',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Heading', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Insights', 'bricks' ),
                            'tag'  => 'span',
                        ],
                    ],
                ],
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next-focus-nav', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_focus_nav.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;

        $activeItemPagename    = ! empty( $settings['activeItemPagename'] ) ? $settings['activeItemPagename'] : false;
        $activeitem    = ! empty( $settings['activeitem'] ) ? $settings['activeitem'] : '1';
        $this->set_attribute( '_root', 'data-active-item', $activeitem );
        if($activeItemPagename){
          $this->set_attribute( '_root', 'data-page-name', get_the_title() );
        }

        $event = ! empty( $settings['event'] ) ? $settings['event'] : 'hover';
        $displayDuration = ! empty( $settings['displayDuration'] ) ? $settings['displayDuration'] : '0.3s';
        $displayStagger = ! empty( $settings['displayStagger'] ) ? $settings['displayStagger'] : '0.05';
        $displayEase = ! empty( $settings['displayEase'] ) ? $settings['displayEase'] : 'sine';
        $morphingDuration = ! empty( $settings['morphingDuration'] ) ? $settings['morphingDuration'] : '0.3s';
        $morphingEase = ! empty( $settings['morphingEase'] ) ? $settings['morphingEase'] : 'power2';

        $this->set_attribute( '_root', 'class', 'nb-focus-nav' );
        $this->set_attribute( '_root', 'data-flickering', '1' );
        $this->set_attribute( '_root', 'data-event', $event );
        $this->set_attribute( '_root', 'data-display-duration', $displayDuration );
        $this->set_attribute( '_root', 'data-display-stagger', $displayStagger );
        $this->set_attribute( '_root', 'data-display-ease', $displayEase );
        $this->set_attribute( '_root', 'data-morphing-duration', $morphingDuration );
        $this->set_attribute( '_root', 'data-morphing-ease', $morphingEase );

        $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
        $output .= '<div class="nb-focus-nav__corners">
                        <div class="nb-focus-nav__corner nb-focus-nav__corner--tl"></div>
                        <div class="nb-focus-nav__corner nb-focus-nav__corner--tr"></div>
                        <div class="nb-focus-nav__corner nb-focus-nav__corner--bl"></div>
                        <div class="nb-focus-nav__corner nb-focus-nav__corner--br"></div>
                    </div>';
        $output .= Frontend::render_children( $this );
        $output .= "</{$this->tag}>";

        echo $output;
    }
}