<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Highlight extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'next_highlight';
  public $icon         = 'fas fa-text-height';
  public $tag      = 'p';
  public $scripts      = ['next_highlight'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Highlight', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
        'p' => 'p',
        'div' => 'div',
        'section' => 'section',
        'article' => 'article',
        'aside' => 'aside',
        'header' => 'header',
        'footer' => 'footer',
        'main' => 'main',
        'nav' => 'nav',
        'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'p',
      'default'     => 'p',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];

    /*css*/
    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Block Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['width'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'width',
            'selector' => '',
          ]
        ],
        'default' => '100%',
    ];
    $this->controls['height'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'height',
            'selector' => '',
          ]
        ],
        'default' => 'auto',
    ];
    $this->controls['typography'] = [
      'tab' => 'content',
      'label' => esc_html__('Typography', 'bricks'),
      'type' => 'typography',
      'css' => [
        [
          'property' => 'typography',
          'selector' => '',
        ],
      ],
      'default' => [
        'color' => [
            'hex' => '#ffffff',
        ],
        'font-size' => '48px',
        'line-height' => '1.2',
      ],
    ];
  }

  public function get_nestable_children() {
    return [
        [
            'name'     => 'text-basic',
            'label'    => esc_html__( 'Text', 'bricks' ),
            'settings' => [
                'text' => esc_html__( 'Lorem ipsum dolor sit amet, ', 'bricks' ),
                'tag'  => 'span',
            ],
        ],
        [
            'name'     => 'next_highlight_mark',
        ],
        [
            'name'     => 'text-basic',
            'label'    => esc_html__( 'Text', 'bricks' ),
            'settings' => [
                'text' => esc_html__( ' consectetur adipiscing elit, sed do eiusmod tempor', 'bricks' ),
                'tag'  => 'span',
            ],
        ],
    ];
}

  public function enqueue_scripts() {
    wp_enqueue_script( 'next_highlight', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_highlight.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $this->set_attribute( '_root', 'class', "nb-highlight");

    $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
    $output .= Frontend::render_children( $this );
    $output .= "</{$this->tag}>";

	echo $output;
  }
}