<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Image_Reveal_v3 extends \Bricks\Element {
  public $category     = 'Next Bricks - Medias';
  public $name         = 'next-image-reveal-v3';
  public $icon         = 'fa-solid fa-photo-film';
  public $scripts      = ['next_image_reveal_v3'];

  public function get_label() {
    return esc_html__( 'Image Reveal v3', 'bricks' );
  }

  public function set_controls() {
    $this->controls['image'] = [
        'hasDynamicData' => true,
        'tab' => 'content',
        'label' => esc_html__( 'Image', 'bricks' ),
        'type' => 'image',
        'default' => [
          'url' => 'https://oxyfolio.com/wp-content/uploads/2025/04/16-gigapixel-standard20v2-7680w-scaled.jpeg',
        ],
    ];
    $this->controls['alt'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Alt text', 'bricks' ),
      'type' => 'text',
      'inline' => true,
  ];
    $this->controls['_objectFit'] = [
      'label'   => esc_html__( 'Object fit', 'bricks' ),
      'type'    => 'select',
      'inline'  => true,
      'options' => $this->control_options['objectFit'],
      'css' => [
        [
          'property' => 'object-fit',
          'selector' => '.nb-image-reveal-v3__image',
        ],
      ],
      'default' => 'cover',
    ];
    $this->controls['_objectPosition'] = [
      'tab' => 'content',
      'label'  => esc_html__( 'Object position', 'bricks' ),
      'type'   => 'text',
      'inline' => true,
      'dd'     => false,
      'css' => [
        [
          'property' => 'object-position',
          'selector' => '.nb-image-reveal-v3__image',
        ],
      ],
    ];
    $this->controls['imageFilters'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Filters', 'bricks' ),
      'type' => 'filters',
      'inline' => true,
      'css' => [
        [
          'property' => 'filter',
          'selector' => '.nb-image-reveal-v3__image',
        ],
      ],
    ];
    $this->controls['width'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Width', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline' => true,
      'css' => [
        [
          'property' => 'width',
          'selector' => '', 
        ]
      ],
      'default' => '400px',
    ];
    $this->controls['height'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Height', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline' => true,
      'css' => [
        [
          'property' => 'height',
          'selector' => '', 
        ]
      ],
      'default' => '400px',
    ];

    $this->controls['columnsSeparator'] = [
        'label'      => esc_html__( 'Columns', 'bricks' ),
        'type'       => 'separator',
      ];
    $this->controls['columnsColor'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type' => 'color',
      'inline' => true,
      'css' => [
        [
          'property' => 'background-color',
          'selector' => '.nb-image-reveal-v3__col-bg', 
        ]
      ],
      'default' => [
        'hex' => '#e3e3e3',
      ]
    ];
    $this->controls['columnsWidth'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Columns Width', 'bricks' ),
      'type' => 'number',
      'inline' => true,
      'default' => '30',
    ];

    $this->controls['animationSeparator'] = [
      'label'      => esc_html__( 'Animation', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['disablebuilder'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
      'type'     => 'checkbox',
      'default' => false,
    ];
    $this->controls['imageDuration'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'default' => '0.8',
    ];
    $this->controls['imageDelay'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Delay', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'default' => '0.2',
    ];
    $this->controls['imageEase'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
          'none' => 'none',
          'power1' => 'power1',
          'power2' => 'power2',
          'power3' => 'power3',
          'power4' => 'power4',
          'back' => 'back',
          'bounce' => 'bounce',
          'circ' => 'circ',
          'elastic' => 'elastic',
          'expo' => 'expo',
          'sine' => 'sine',
          'steps' => 'steps'
        ],
        'inline' => true,
        'default' => 'power3',
    ];

    $this->controls['scrolltrigger'] = [
      'label'      => esc_html__( 'ScrollTrigger', 'bricks' ),
      'type'       => 'separator',
      'description' => sprintf(esc_html__( 'Scrolltrigger %s', 'bricks' ), '<a href="https://greensock.com/docs/v3/Plugins/ScrollTrigger" target="_blank">documentation</a>'),
    ];
    $this->controls['trigger'] = [
      'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Trigger', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'default' => 'this',
    ];
    $this->controls['start'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Start', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'default' => 'top bottom',
    ];
    $this->controls['end'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'End', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'default' => 'unset',
    ];
    $this->controls['scrub'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Scrub', 'bricks' ),
      'type' => 'text',
      'small' => true,
      'inline' => true,
      'default' => '0',
    ];
    $this->controls['toggleActions'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'toggleActions', 'bricks' ),
      'type' => 'text',
      'default' => 'play none none none',
    ];

    $this->controls['animationType'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Trigger on', 'bricks' ),
        'type' => 'select',
        'options'     => [
          'Click' => 'Click',
          'Hover' => 'Hover',
        ],
        'inline' => true,
        'placeholder' => '',
    ];
    $this->controls['removescroll'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Disable on scroll', 'bricks' ),
        'type'     => 'checkbox',
        'default' => false,
    ];
    $this->controls['classTriggerClick'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Element', 'bricks' ),
        'type' => 'text',
        'placeholder' => '.className',
        'inline' => true,
        'required' => [ 'animationType', '=', 'Click'],
    ];
    $this->controls['classTriggerHover'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Element', 'bricks' ),
        'type' => 'text',
        'placeholder' => '.className',
        'inline' => true,
        'required' => [ 'animationType', '=', 'Hover'],
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'next_image_reveal_v3', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_image_reveal_v3.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $removescroll    = ! empty( $settings['removescroll'] ) ? $settings['removescroll'] : 0;
    $animationType    = ! empty( $settings['animationType'] ) ? $settings['animationType'] : '';
    $classTriggerClick    = ! empty( $settings['classTriggerClick'] ) ? $settings['classTriggerClick'] : 0;
    $classTriggerHover    = ! empty( $settings['classTriggerHover'] ) ? $settings['classTriggerHover'] : 0;

    $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
    $columnsWidth = !empty($settings['columnsWidth']) ? $settings['columnsWidth'] : '30';
    $trigger = !empty($settings['trigger']) ? $settings['trigger'] : 'this';
    $start = !empty($settings['start']) ? $settings['start'] : 'top bottom';
    $end = !empty($settings['end']) ? $settings['end'] : 'unset';
    $scrub = isset($settings['scrub']) ? $settings['scrub'] : '0';
    $toggleActions = !empty($settings['toggleActions']) ? $settings['toggleActions'] : 'play none none none';
    $duration = !empty($settings['imageDuration']) ? $settings['imageDuration'] : '0.8';
    $delay = !empty($settings['imageDelay']) ? $settings['imageDelay'] : '0.2';
    $ease = !empty($settings['imageEase']) ? $settings['imageEase'] : 'power3';

    $this->set_attribute('_root', 'data-disable-builder', $disablebuilder);
    $this->set_attribute('_root', 'data-columns-width', $columnsWidth);
    $this->set_attribute('_root', 'data-trigger', $trigger);
    $this->set_attribute('_root', 'data-start', $start);
    $this->set_attribute('_root', 'data-end', $end);
    $this->set_attribute('_root', 'data-scrub', $scrub);
    $this->set_attribute('_root', 'data-toggle-actions', $toggleActions);
    $this->set_attribute('_root', 'data-duration', $duration);
    $this->set_attribute('_root', 'data-delay', $delay);
    $this->set_attribute('_root', 'data-ease', $ease);

    $this->set_attribute( '_root', 'data-animationType', $animationType);
    $this->set_attribute( '_root', 'data-remove-scroll', "$removescroll");
    $this->set_attribute( '_root', 'data-classTriggerClick', $classTriggerClick);
    $this->set_attribute( '_root', 'data-classTriggerHover', $classTriggerHover);

    //Render dynamic data
    if (isset($settings['image']['useDynamicData'])){
      $last_image = $this->render_dynamic_data_tag($settings['image']['useDynamicData'], 'image');
      $last_image = wp_get_attachment_url($last_image[0]);

      $attachment_id = attachment_url_to_postid($last_image);
      $image_metadata = wp_get_attachment_metadata($attachment_id);
      
      $width = isset($image_metadata['width']) ? $image_metadata['width'] : 0;
      $height = isset($image_metadata['height']) ? $image_metadata['height'] : 0;
    }
    //Render normal image
    else if (isset($settings['image'])) {
      $last_image = $settings['image']['url'];

      $image_dimensions = @getimagesize($last_image);
      if ($image_dimensions !== false) {
          $width = $image_dimensions[0];
          $height = $image_dimensions[1];
      } else {
          $width = 0;
          $height = 0;
      }
    }
    //Render default
    else{
      $last_image = 'https://oxyfolio.com/wp-content/uploads/2025/04/16-gigapixel-standard20v2-7680w-scaled.jpeg';

      $image_dimensions = @getimagesize($last_image);
      if ($image_dimensions !== false) {
          $width = $image_dimensions[0];
          $height = $image_dimensions[1];
      } else {
          $width = 0;
          $height = 0;
      }
    }

    $alt = !empty($settings['alt']) ? "alt='{$settings['alt']}'" : '';

    $this->set_attribute( '_root', 'class', 'nb-image-reveal-v3' );
    $this->set_attribute( '_root', 'data-flickering', '1');

    if (strpos($last_image, 'cloudinary.com') !== false) {
        $src_decoding = 'decoding="async"';
    } else {
        $src_decoding = '';
    }

    $output = "<div {$this->render_attributes( '_root' )}>
    <img class='nb-image-reveal-v3__image' src='$last_image' $alt $src_decoding>";
    $output .= '</div>';

	echo $output;
  }
}