<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Interactive_Divider extends \Bricks\Element {
    public $category     = 'Next Bricks - Cores';
    public $name         = 'next_interactive_divider';
    public $icon         = 'ti-layout-line-solid';
    public $scripts      = ['next_interactive_divider'];

    public function get_label() {
        return esc_html__( 'Interactive Divider', 'bricks' );
    }

    public function set_controls() {
        $this->controls['height'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => '--divider-height',
                    'selector' => '',
                ],
            ],
            'placeholder' => '1px',
            'rerender' => true,
        ];
        $this->controls['width'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => 'width',
                    'selector' => '',
                ],
            ],
            'placeholder' => '100%',
            'rerender' => true,
        ];
        $this->controls['color'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Color', 'bricks' ),
            'type'  => 'color',
            'css'   => [
                [
                    'property' => 'stroke',
                    'selector' => '.next-interactive-divider__path',
                ],
            ],
            'default' => [
                'hex' => '#000000',
            ],
        ];

        /*Animation*/
        $this->controls['animation'] = [
            'label'      => esc_html__( 'Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['dragHeight'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Drag distance', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => '--drag-height',
                    'selector' => '',
                ],
            ],
            'placeholder' => '40px',
            'rerender' => true,
        ];
        $this->controls['dropHeight'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Drop distance', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => '--drop-height',
                    'selector' => '',
                ],
            ],
            'placeholder' => '500px',
            'rerender' => true,
        ];
        $this->controls['bendIntensity'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Bend intensity', 'bricks' ),
            'type'  => 'text',
            'inline'  => true,
            'small'  => true,
            'placeholder' => '100',
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_interactive_divider', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_interactive_divider.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $bendIntensity = ! empty( $settings['bendIntensity'] ) ? $settings['bendIntensity'] : 100;

        $this->set_attribute( '_root', 'class', "next-interactive-divider");
        $this->set_attribute( '_root', 'data-bend-intensity', $bendIntensity);

        $output =
        "
        <div {$this->render_attributes( '_root' )}>
            <div class='next-interactive-divider__line'>
                <div class='next-interactive-divider__box'></div>
                <svg class='next-interactive-divider__svg'>
                    <path class='next-interactive-divider__path'></path>
                </svg>
            </div>
        </div>
        ";

        echo $output;
    }
}