<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Interactive_Lines extends \Bricks\Element {
    public $category     = 'Next Bricks - Backgrounds';
    public $name         = 'next_interactive_lines';
    public $icon         = 'fa-solid fa-slash';
    public $tag      = 'div';
    public $scripts      = ['next_interactive_lines'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Interactive Lines', 'bricks' );
    }

    public function set_controls() {
      $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
          'div' => 'div',
          'section' => 'section',
          'article' => 'article',
          'aside' => 'aside',
          'header' => 'header',
          'footer' => 'footer',
          'main' => 'main',
          'nav' => 'nav',
          'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'div',
        'default'     => 'div',
    ];
    $this->controls['customTag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Custom tag', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'placeholder' => 'div',
        'required'    => [ 'tag', '=', 'custom' ],
    ];
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Interactive Lines is a nestable block element. You can put any elements at it and edit its display settings at the Style tab.', 'bricks' )))
        ];

        /*Block*/
        $this->controls['blockSeparator'] = [
            'label'      => esc_html__( 'Block style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['width'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'width',
                'selector' => '',
              ]
            ],
            'default' => '100%',
        ];
        $this->controls['height'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'height',
                'selector' => '',
              ]
            ],
            'default' => '500px',
        ];
        $this->controls['background'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type' => 'background',
            'inline' => true,
            'css' => [
              [
                'property' => 'background',
                'selector' => '',
              ]
            ],
            'default' => [
                'color' => [
                  'hex' => '#e3e3e3',
                ],
            ],
        ];
        $this->controls['border'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type'  => 'border',
            'inline' => true,
            'css' => [
              [
                'property' => 'border',
                'selector' => '',
              ]
            ],
        ];

        $this->controls['animationSeparator'] = [
            'label'      => esc_html__( 'Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['activeColor'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Active Color', 'bricks' ),
            'type'  => 'color',
            'inline' => true,
            'css' => [
              [
                'property' => '--active-color',
                'selector' => '',
              ]
            ],
            'default' => [
                'hex' => 'orange',
            ],
            'rerender' => true,
        ];
        $this->controls['inactiveColor'] = [
            'hasDynamicData' => false,
            'tab' => 'content', 
            'label' => esc_html__( 'Inactive Color', 'bricks' ),
            'type'  => 'color',
            'inline' => true,
            'css' => [
              [
                'property' => '--inactive-color',
                'selector' => '',
              ]
            ],
            'default' => [
                'hex' => '#d4d4d4',
            ],
            'rerender' => true,
        ];
        $this->controls['spotlight'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Spotlight', 'bricks' ),
            'type' => 'checkbox',
        ];
        $this->controls['cell'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Cell Size', 'bricks' ),
            'type' => 'number',
            'default' => 28,
        ];
        $this->controls['alpha'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Alpha', 'bricks' ),
            'type' => 'number',
            'default' => 1,
        ];
        $this->controls['line'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Line Length', 'bricks' ),
            'type' => 'number',
            'default' => 0.75,
        ];
        $this->controls['width'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Line Width', 'bricks' ),
            'type' => 'number',
            'default' => 3,
        ];
        $this->controls['speed'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Animation Speed', 'bricks' ),
            'type' => 'number',
            'default' => 0.15,
        ];
        $this->controls['size'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Active Area Size', 'bricks' ),
            'type' => 'number',
            'default' => 100,
        ];
        $this->controls['threshold'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Rotation Threshold', 'bricks' ),
            'type' => 'number',
            'default' => 0.01,
        ];
        $this->controls['intensity'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Spotlight Intensity', 'bricks' ),
            'type' => 'number',
            'default' => 0.9,
        ];
    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Content', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-interactive-lines__content',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Heading', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Interactive Lines', 'bricks' ),
                            'tag'  => 'h3',
                        ],
                    ]
                ]
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_interactive_lines', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_interactive_lines.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $spotlight = ! empty( $settings['spotlight'] ) ? $settings['spotlight'] : 0;
        $cell = ! empty( $settings['cell'] ) ? $settings['cell'] : 28;
        $alpha = ! empty( $settings['alpha'] ) ? $settings['alpha'] : 1;
        $line = ! empty( $settings['line'] ) ? $settings['line'] : 0.75;
        $width = ! empty( $settings['width'] ) ? $settings['width'] : 3;
        $speed = ! empty( $settings['speed'] ) ? $settings['speed'] : 0.15;
        $size = ! empty( $settings['size'] ) ? $settings['size'] : 100;
        $threshold = ! empty( $settings['threshold'] ) ? $settings['threshold'] : 0.01;
        $intensity = ! empty( $settings['intensity'] ) ? $settings['intensity'] : 0.9;

        $this->set_attribute( '_root', 'class', "next-interactive-lines");
        $this->set_attribute( '_root', 'data-cell', $cell);
        $this->set_attribute( '_root', 'data-alpha', $alpha);
        $this->set_attribute( '_root', 'data-line', $line);
        $this->set_attribute( '_root', 'data-width', $width);
        $this->set_attribute( '_root', 'data-speed', $speed);
        $this->set_attribute( '_root', 'data-size', $size);
        $this->set_attribute( '_root', 'data-threshold', $threshold);
        $this->set_attribute( '_root', 'data-intensity', $intensity);

        if($spotlight == 1){
            $this->set_attribute( '_root', 'data-spotlight', 'true');
        }

        $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
        $output .= "<canvas></canvas>";
        $output .= Frontend::render_children( $this );
        $output .= "</{$this->tag}>";

        echo $output;
    }
}