<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Interactive_Lines_v2 extends \Bricks\Element {
  public $category     = 'Next Bricks - Backgrounds';
  public $name         = 'next_interactive_lines_v2';
  public $icon         = 'fas fa-slash';
  public $tag      = 'div';
  public $scripts      = ['next_interactive_lines_v2'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Interactive Lines v2', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
        'div' => 'div',
        'section' => 'section',
        'article' => 'article',
        'aside' => 'aside',
        'header' => 'header',
        'footer' => 'footer',
        'main' => 'main',
        'nav' => 'nav',
        'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];

    /*css*/
    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Block Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['width'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'width',
            'selector' => '',
          ]
        ],
        'default' => '100%',
    ];
    $this->controls['height'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'height',
            'selector' => '',
          ]
        ],
        'default' => '500px',
    ];
    $this->controls['background'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Background', 'bricks' ),
        'type'  => 'color',
        'inline' => true,
        'css' => [
          [
            'property' => 'background',
            'selector' => '',
          ]
        ],
        'default' => [
            'hex' => '#000000',
        ],
    ];

    $this->controls['linesSeparator'] = [
        'label'      => esc_html__( 'Lines Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['spacing'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Spacing', 'bricks' ),
        'type'  => 'number',
        'inline' => true,
        'default' => 30,
    ];
    $this->controls['strokeWidth'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'inline' => true,
        'default' => 1,
    ];
    $this->controls['strokeLength'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'inline' => true,
        'default' => 10,
    ];
    $this->controls['linesColor'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Color', 'bricks' ),
        'type'  => 'color',
        'inline' => true,
        'css' => [
          [
            'property' => '--lines-color',
            'selector' => '',
          ]
        ],
        'default' => [
            'rgb' => 'rgba(255, 255, 255, 0.3)',
        ],
    ];

    $this->controls['ballSeparator'] = [
        'label'      => esc_html__( 'Ball Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['ballDimensions'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Size', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => '--dimensions',
            'selector' => '.nb-interactive-lines-v2__ball',
          ]
        ],
        'default' => '6px',
    ];
    $this->controls['ballColor'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Color', 'bricks' ),
        'type'  => 'color',
        'inline' => true,
        'css' => [
          [
            'property' => 'background-color',
            'selector' => '.nb-interactive-lines-v2__ball',
          ]
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];
    $this->controls['ballBorderRadius'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Border', 'bricks' ),
        'type'  => 'border',
        'inline' => true,
        'css' => [
          [
            'property' => 'border',
            'selector' => '.nb-interactive-lines-v2__ball',
          ]
        ],
        'default' => [
            'radius' => [
                'top' => '50%',
                'right' => '50%',
                'bottom' => '50%',
                'left' => '50%',
            ]
        ],
    ];

    /*js settings*/
    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Interactive Lines Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['disablebuilder'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Disable in the Builder', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'default' => false,
    ];
    $this->controls['duration'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '1s',
    ];
    $this->controls['ease'] = [
        'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'GSAP easing', 'bricks' ),
          'type' => 'select',
          'options'     => [
            'none' => 'none',
            'power1' => 'power1',
            'power2' => 'power2',
            'power3' => 'power3',
            'power4' => 'power4',
            'back' => 'back',
            'bounce' => 'bounce',
            'circ' => 'circ',
            'elastic' => 'elastic',
            'expo' => 'expo',
            'sine' => 'sine',
            'steps' => 'steps'
          ],
          'inline' => true,
          'default' => 'expo',
      ];
  }

  public function get_nestable_children() {
    return [
        [
            'name'     => 'block',
            'label'    => esc_html__( 'Content', 'bricks' ),
            'settings' => [
                '_hidden'  => [
                    '_cssClasses' => 'nb-interactive-lines-v2__content',
                ],
            ],
            'children' => [
                [
                    'name'     => 'heading',
                    'label'    => esc_html__( 'Heading', 'bricks' ),
                    'settings' => [
                        'text' => esc_html__( 'Interactive Lines v2', 'bricks' ),
                        'tag'  => 'h3',
                    ],
                ]
            ]
        ],
    ];
}

  public function enqueue_scripts() {
    wp_enqueue_script( 'next_interactive_lines_v2', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_interactive_lines_v2.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
    $spacing = ! empty( $settings['spacing'] ) ? $settings['spacing'] : 30;
    $stroke_length = ! empty( $settings['strokeLength'] ) ? $settings['strokeLength'] : 10;
    $stroke_width = ! empty( $settings['strokeWidth'] ) ? $settings['strokeWidth'] : 1;
    $duration = ! empty( $settings['duration'] ) ? $settings['duration'] : 1;
    $ease = ! empty( $settings['ease'] ) ? $settings['ease'] : 'expo';

    $this->set_attribute( '_root', 'class', "nb-interactive-lines-v2");

    $output = "<{$this->tag} {$this->render_attributes( '_root' )}
        data-disable-builder='{$disablebuilder}'
        data-spacing='{$spacing}'
        data-stroke-length='{$stroke_length}'
        data-stroke-width='{$stroke_width}'
        data-duration='{$duration}'
        data-ease='{$ease}'
    >";
    $output .= '<canvas class="nb-interactive-lines-v2__canvas"></canvas>
                <div class="nb-interactive-lines-v2__ball"></div>';
    $output .= Frontend::render_children( $this );
    $output .= "</{$this->tag}>";

	echo $output;
  }
}