<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Inverted_Corners extends \Bricks\Element {
    public $category     = 'Next Bricks - Cores';
    public $name         = 'next_inverted_corners';
    public $icon         = 'fa-solid fa-border-top-left';
    public $nestable     = true;
    public $scripts      = ['next_inverted_corners'];

    public function get_label() {
        return esc_html__( 'Inverted Corner', 'bricks' );
    }

    public function set_controls() {
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Elements to be added to the block must be added to the "Block Content" element. Elements to be added to the corner must be added to the "Corner Content" element.', 'bricks' )))
        ];

        //Style
        $this->controls['styleSeparator'] = [
            'label'      => esc_html__( 'Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['width'] = [
            'label'       => esc_html__( 'Width', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css'     => [
                [
                  'property' => 'width',
                  'selector' => '',
                ],
            ],
            'placeholder' => '400px',
        ];
        $this->controls['height'] = [
            'label'       => esc_html__( 'Height', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css'     => [
                [
                  'property' => 'height',
                  'selector' => '',
                ],
            ],
            'placeholder' => '400px',
        ];
        $this->controls['cornersRadius'] = [
            'label'       => esc_html__( 'Border Radius', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css'     => [
                [
                  'property' => '--block-border-radius',
                  'selector' => '',
                ],
            ],
            'placeholder' => '20px',
        ];
        $this->controls['blockBackground'] = [
            'label'       => esc_html__( 'Block Content Background', 'bricks' ),
            'type'        => 'color',
            'css'     => [
                [
                  'property' => '--block-background',
                  'selector' => '',
                ],
            ],
            'default' => [
                'hex' => '#8EFF71',
            ],
        ];
        $this->controls['maskBackground'] = [
            'label'       => esc_html__( 'Mask Background', 'bricks' ),
            'type'        => 'color',
            'css'     => [
                [
                  'property' => '--corners-background',
                  'selector' => '',
                ],
            ],
            'default' => [
                'hex' => '#fff',
            ],
        ];

        //Corner 1
        $this->controls['cornerSeparator'] = [
            'label'      => esc_html__( 'Corner 1', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['noteAux'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'The following settings are applied to the first Corner Content element. You can duplicate and remove them at the structure panel.', 'bricks' )))
        ];
        $this->controls['cornerPosition'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Position', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'top-left' => 'top left',
                'top-right' => 'top right',
                'bottom-left' => 'bottom left',
                'bottom-right' => 'bottom right',
            ],
            'inline' => true,
            'placeholder' => 'bottom right',
        ];
        $this->controls['cornerWidth'] = [
            'label'       => esc_html__( 'Width', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css'     => [
                [
                  'property' => '--content-corner-width-1',
                  'selector' => '',
                ],
            ],
            'placeholder' => '60px',
        ];
        $this->controls['cornerHeight'] = [
            'label'       => esc_html__( 'Height', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css'     => [
                [
                  'property' => '--content-corner-height-1',
                  'selector' => '',
                ],
            ],
            'placeholder' => '60px',
        ];
        $this->controls['invertedCornerRadius'] = [
            'label'       => esc_html__( 'Border Radius', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css'     => [
                [
                  'property' => '--inverted-corner-border-radius-1',
                  'selector' => '',
                ],
            ],
            'placeholder' => '30px',
        ];
        $this->controls['cornerDistance'] = [
            'label'       => esc_html__( 'Distance', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css'     => [
                [
                  'property' => '--content-corner-distance-1',
                  'selector' => '',
                ],
            ],
            'placeholder' => '6px',
        ];

        //Corner 2
        $this->controls['cornerSeparator2'] = [
            'label'      => esc_html__( 'Corner 2', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['noteAux2'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'The following settings are applied to the second Corner Content element. You can duplicate and remove them at the structure panel.', 'bricks' )))
        ];
        $this->controls['cornerPosition2'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Position', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'top-left' => 'top left',
                'top-right' => 'top right',
                'bottom-left' => 'bottom left',
                'bottom-right' => 'bottom right',
            ],
            'inline' => true,
            'placeholder' => 'bottom right',
        ];
        $this->controls['cornerWidth2'] = [
            'label'       => esc_html__( 'Width', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css'     => [
                [
                    'property' => '--content-corner-width-2',
                    'selector' => '',
                ],
            ],
            'placeholder' => '60px',
        ];
        $this->controls['cornerHeight2'] = [
            'label'       => esc_html__( 'Height', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css'     => [
                [
                    'property' => '--content-corner-height-2',
                    'selector' => '',
                ],
            ],
            'placeholder' => '60px',
        ];
        $this->controls['invertedCornerRadius2'] = [
            'label'       => esc_html__( 'Border Radius', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css'     => [
                [
                    'property' => '--inverted-corner-border-radius-2',
                    'selector' => '',
                ],
            ],
            'placeholder' => '30px',
        ];
        $this->controls['cornerDistance2'] = [
            'label'       => esc_html__( 'Distance', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css'     => [
                [
                    'property' => '--content-corner-distance-2',
                    'selector' => '',
                ],
            ],
            'placeholder' => '6px',
        ];

        //Corner 3
        $this->controls['cornerSeparator3'] = [
            'label'      => esc_html__( 'Corner 3', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['noteAux3'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'The following settings are applied to the third Corner Content element. You can duplicate and remove them at the structure panel.', 'bricks' )))
        ];
        $this->controls['cornerPosition3'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Position', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'top-left' => 'top left',
                'top-right' => 'top right',
                'bottom-left' => 'bottom left',
                'bottom-right' => 'bottom right',
            ],
            'inline' => true,
            'placeholder' => 'bottom right',
        ];
        $this->controls['cornerWidth3'] = [
            'label'       => esc_html__( 'Width', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css'     => [
                [
                    'property' => '--content-corner-width-3',
                    'selector' => '',
                ],
            ],
            'placeholder' => '60px',
        ];
        $this->controls['cornerHeight3'] = [
            'label'       => esc_html__( 'Height', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css'     => [
                [
                    'property' => '--content-corner-height-3',
                    'selector' => '',
                ],
            ],
            'placeholder' => '60px',
        ];
        $this->controls['invertedCornerRadius3'] = [
            'label'       => esc_html__( 'Border Radius', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css'     => [
                [
                    'property' => '--inverted-corner-border-radius-3',
                    'selector' => '',
                ],
            ],
            'placeholder' => '30px',
        ];
        $this->controls['cornerDistance3'] = [
            'label'       => esc_html__( 'Distance', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css'     => [
                [
                    'property' => '--content-corner-distance-3',
                    'selector' => '',
                ],
            ],
            'placeholder' => '6px',
        ];

        //Corner 4
        $this->controls['cornerSeparator4'] = [
            'label'      => esc_html__( 'Corner 4', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['noteAux4'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'The following settings are applied to the fourth Corner Content element. You can duplicate and remove them at the structure panel.', 'bricks' )))
        ];
        $this->controls['cornerPosition4'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Position', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'top-left' => 'top left',
                'top-right' => 'top right',
                'bottom-left' => 'bottom left',
                'bottom-right' => 'bottom right',
            ],
            'inline' => true,
            'placeholder' => 'bottom right',
        ];
        $this->controls['cornerWidth4'] = [
            'label'       => esc_html__( 'Width', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css'     => [
                [
                    'property' => '--content-corner-width-4',
                    'selector' => '',
                ],
            ],
            'placeholder' => '60px',
        ];
        $this->controls['cornerHeight4'] = [
            'label'       => esc_html__( 'Height', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css'     => [
                [
                    'property' => '--content-corner-height-4',
                    'selector' => '',
                ],
            ],
            'placeholder' => '60px',
        ];
        $this->controls['invertedCornerRadius4'] = [
            'label'       => esc_html__( 'Border Radius', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css'     => [
                [
                    'property' => '--inverted-corner-border-radius-4',
                    'selector' => '',
                ],
            ],
            'placeholder' => '30px',
        ];
        $this->controls['cornerDistance4'] = [
            'label'       => esc_html__( 'Distance', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css'     => [
                [
                    'property' => '--content-corner-distance-4',
                    'selector' => '',
                ],
            ],
            'placeholder' => '6px',
        ];
    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Block Content', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-inverted-corner__content-wrapper',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Heading', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Great Heading', 'bricks' ),
                        ],
                    ],
                ],
            ],

            [
                'name'     => 'block',
                'label'    => esc_html__( 'Corner Content', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-inverted-corner__content-corner',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Ball', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'next-inverted-corner__ball',
                            ],
                        ],
                    ],
                ],
            ],

            [
                'name'     => 'block',
                'label'    => esc_html__( 'Corner Content', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-inverted-corner__content-corner',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Ball', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'next-inverted-corner__ball',
                            ],
                        ],
                    ],
                ],
            ],

            [
                'name'     => 'block',
                'label'    => esc_html__( 'Corner Content', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-inverted-corner__content-corner',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Ball', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'next-inverted-corner__ball',
                            ],
                        ],
                    ],
                ],
            ],

            [
                'name'     => 'block',
                'label'    => esc_html__( 'Corner Content', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-inverted-corner__content-corner',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Ball', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'next-inverted-corner__ball',
                            ],
                        ],
                    ],
                ],
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_inverted_corners', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_inverted_corners.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;

        $cornerPosition1 = ! empty( $settings['cornerPosition'] ) ? $settings['cornerPosition'] : 'bottom-right';
        $cornerPosition2 = ! empty( $settings['cornerPosition2'] ) ? $settings['cornerPosition2'] : 'bottom-right';
        $cornerPosition3 = ! empty( $settings['cornerPosition3'] ) ? $settings['cornerPosition3'] : 'bottom-right';
        $cornerPosition4 = ! empty( $settings['cornerPosition4'] ) ? $settings['cornerPosition4'] : 'bottom-right';

        $this->set_attribute( '_root', 'class', 'next-inverted-corner' );

        $output = "<div {$this->render_attributes( '_root' )}
        data-flickering=\"1\"
        data-corner-position-1=\"$cornerPosition1\"
        data-corner-position-2=\"$cornerPosition2\"
        data-corner-position-3=\"$cornerPosition3\"
        data-corner-position-4=\"$cornerPosition4\">";
        $output .= '
            <div class="next-inverted-corner__inner">
                <div class="next-inverted-corner__box">';
                $output .= Frontend::render_children( $this );
        $output .= '</div>
            </div>
        </div>';

        echo $output;
    }
}