<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Iridescence extends \Bricks\Element {
  public $category     = 'Next Bricks - Backgrounds';
  public $name         = 'next_iridescence';
  public $icon         = 'fas fa-wave-square';
  public $tag      = 'div';
  public $scripts      = ['next_iridescence'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Iridescence', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
        'div' => 'div',
        'section' => 'section',
        'article' => 'article',
        'aside' => 'aside',
        'header' => 'header',
        'footer' => 'footer',
        'main' => 'main',
        'nav' => 'nav',
        'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['note'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Iridescence is a nestable block element. You can put any elements at it and edit its display settings at the Style tab.', 'bricks' )))
    ];

    /*css*/
    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Block Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['width'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'width',
            'selector' => '',
          ]
        ],
        'default' => '100%',
    ];
    $this->controls['height'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'height',
            'selector' => '',
          ]
        ],
        'default' => '500px',
    ];

    /*js settings*/
    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Iridescence Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['note2'] = [
        'tab' => 'content',
        'description' => sprintf(html_entity_decode(esc_html__( 'Iridescence animation can only be visible on the front.', 'bricks' )))
    ];
    $this->controls['r'] = [
        'tab' => 'content',
        'label' => esc_html__( 'R', 'bricks' ),
        'type' => 'slider',
        'units'    => [
            'px' => [
              'min' => 0,
              'max' => 1,
              'step' => 0.1,
            ],
        ],
        'default' => 1.0,
    ];
    $this->controls['g'] = [
        'tab' => 'content',
        'label' => esc_html__( 'G', 'bricks' ),
        'type' => 'slider',
        'units'    => [
            'px' => [
              'min' => 0,
              'max' => 1,
              'step' => 0.1,
            ],
        ],
        'default' => 0.9,
    ];
    $this->controls['b'] = [
        'tab' => 'content',
        'label' => esc_html__( 'B', 'bricks' ),
        'type' => 'slider',
        'units'    => [
            'px' => [
              'min' => 0,
              'max' => 1,
              'step' => 0.1,
            ],
        ],
        'default' => 1.0,
    ];
    $this->controls['speed'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Speed', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => 1.0,
    ];
    $this->controls['amplitude'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Amplitude', 'bricks' ),
        'type' => 'number',
        'inline' => true,
        'default' => 0.1,
    ];
    $this->controls['interactivity'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Interactivity', 'bricks' ),
        'type' => 'checkbox',
        'default' => true,
    ];
  }

  public function get_nestable_children() {
    return [
        [
            'name'     => 'block',
            'label'    => esc_html__( 'Content', 'bricks' ),
            'settings' => [
                '_hidden'  => [
                    '_cssClasses' => 'nb-iridescence__content',
                ],
            ],
            'children' => [
                [
                    'name'     => 'heading',
                    'label'    => esc_html__( 'Heading', 'bricks' ),
                    'settings' => [
                        'text' => esc_html__( 'Iridescence', 'bricks' ),
                        'tag'  => 'h3',
                    ],
                ]
            ]
        ],
    ];
}

  public function enqueue_scripts() {
    wp_enqueue_script( 'next_iridescence', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_iridescence.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $r = ! empty( $settings['r'] ) ? $settings['r'] : 1.0;
    $g = ! empty( $settings['g'] ) ? $settings['g'] : 0.9;
    $b = ! empty( $settings['b'] ) ? $settings['b'] : 1.0;
    $speed = ! empty( $settings['speed'] ) ? $settings['speed'] : 1.0;
    $amplitude = ! empty( $settings['amplitude'] ) ? $settings['amplitude'] : 0.1;
    $interactivity = ! empty( $settings['interactivity'] ) ? $settings['interactivity'] : 0;
    if($interactivity == 0) {
      $interactivity = 'disabled';
    } else {
      $interactivity = 'enabled';
    }

    $this->set_attribute( '_root', 'class', "nb-iridescence");
    $this->set_attribute( '_root', 'data-iridescence-flickering', '1');
    $this->set_attribute( '_root', 'data-r', $r);
    $this->set_attribute( '_root', 'data-g', $g);
    $this->set_attribute( '_root', 'data-b', $b);
    $this->set_attribute( '_root', 'data-speed', $speed);
    $this->set_attribute( '_root', 'data-amplitude', $amplitude);
    $this->set_attribute( '_root', 'data-interactivity', $interactivity);

    $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
    $output .= '<canvas class="nb-iridescence__canvas"></canvas>';
    $output .= Frontend::render_children( $this );
    $output .= "</{$this->tag}>";

	echo $output;
  }
}