<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Lamp extends \Bricks\Element {
    public $category     = 'Next Bricks - Cores';
    public $name         = 'next_lamp';
    public $icon         = 'ion-md-flashlight';
    public $scripts      = ['next_lamp'];

    public function get_label() {
        return esc_html__( 'Lamp', 'bricks' );
    }

    public function set_controls() {
        $this->controls['noteLamp'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Background should match your Site Background to achieve an appropriate Lamp fade effect.', 'bricks' )))
        ];

        /*Block style*/
        $this->controls['blockStyleSeparator'] = [
            'label'      => esc_html__( 'Block style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['zIndex'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'zIndex', 'bricks' ),
            'type'    => 'text',
            'css'     => [
                [
                    'property' => 'z-index',
                    'selector' => '',
                ],
            ],
            'inline'   => true,
            'small'   => true,
            'placeholder'    => '-1',
        ];
        $this->controls['blockWidth'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Width', 'bricks' ),
            'type'    => 'number',
            'units'   => true,
            'css'     => [
                [
                    'property' => '--div-width',
                    'selector' => '',
                ],
            ],
            'placeholder' => '100%',
        ];
        $this->controls['blockHeight'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Height', 'bricks' ),
            'type'    => 'number',
            'units'   => true,
            'css'     => [
                [
                    'property' => '--div-height',
                    'selector' => '',
                ],
            ],
            'placeholder' => '250px',
        ];
        $this->controls['backgroundHeight'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Background', 'bricks' ),
            'type'    => 'color',
            'css'     => [
                [
                    'property' => '--div-background',
                    'selector' => '',
                ],
            ],
        ];

        /*Lamp style*/
        $this->controls['lampStyleSeparator'] = [
            'label'      => esc_html__( 'Lamp style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['lampAngle'] = [
            'hasDynamicData' => false,
            'tab'     => 'content',
            'label'   => esc_html__( 'Angle', 'bricks' ),
            'type'    => 'slider',
            'units'    => [
                'deg' => [
                  'min' => -50,
                  'max' => 90,
                  'step' => 1,
                ],
              ],
            'default' => '70deg',
            'placeholder' => '70deg',
        ];
        $this->controls['noteLamp2'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Lamp has an absolute position at the block.', 'bricks' )))
        ];
        $this->controls['lampWidthSize'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Width', 'bricks' ),
            'type'    => 'number',
            'units'   => true,
            'css'     => [
                [
                    'property' => '--lamp-width-size',
                    'selector' => '',
                ],
            ],
            'placeholder' => '300px',
            'rerender'   => true,
        ];
        $this->controls['lampHeightSize'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Height', 'bricks' ),
            'type'    => 'number',
            'units'   => true,
            'css'     => [
                [
                    'property' => '--lamp-height-size',
                    'selector' => '',
                ],
            ],
            'placeholder' => '200px',
        ];
        $this->controls['lampMarginTop'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Top', 'bricks' ),
            'type'    => 'number',
            'units'   => true,
            'css'     => [
                [
                    'property' => 'margin-top',
                    'selector' => '& > *',
                ],
            ],
            'placeholder' => '50px',
        ];
        $this->controls['lampColor'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Color', 'bricks' ),
            'type'    => 'color',
            'css'     => [
                [
                    'property' => '--lamp-color',
                    'selector' => '',
                ],
            ],
        ];
        $this->controls['lampBlurIntensity'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'   => esc_html__( 'Blur intensity', 'bricks' ),
            'type' => 'slider',
            'units'    => [
              'px' => [
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
              ],
            ],
            'css'     => [
                [
                    'property' => '--lamp-blur-intensity',
                    'selector' => '',
                ],
            ],
            'default' => '0.5',
            'placeholder' => '0.5',
        ];
        $this->controls['lampLightIntensity'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Light intensity', 'bricks' ),
            'type'    => 'slider',
            'units'    => [
                'px' => [
                  'min' => 0.7,
                  'max' => 3,
                  'step' => 0.1,
                ],
            ],
            'css'     => [
                [
                    'property' => '--lamp-light-intensity',
                    'selector' => '',
                ],
            ],
            'default' => '1',
            'placeholder' => '1',
        ];

        /*Line style*/
        $this->controls['lineStyleSeparator'] = [
            'label'      => esc_html__( 'Line style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['lineHeight'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Height', 'bricks' ),
            'type'    => 'number',
            'units'   => true,
            'css'     => [
                [
                    'property' => '--line-height',
                    'selector' => '',
                ],
            ],
            'placeholder' => '1.25px',
        ];
        $this->controls['lineColor'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Color', 'bricks' ),
            'type'    => 'color',
            'css'     => [
                [
                    'property' => '--line-color',
                    'selector' => '',
                ],
            ],
        ];

        /*Animation*/
        $this->controls['animationSeparator'] = [
            'label'      => esc_html__( 'Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['trigger'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Trigger', 'bricks' ),
            'type'    => 'text',
            'placeholder' => 'this',
            'inline' => true,
        ];
        $this->controls['start'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Start', 'bricks' ),
            'type'    => 'text',
            'placeholder' => 'top bottom',
            'inline' => true,
        ];
        $this->controls['duration'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Duration', 'bricks' ),
            'type'    => 'number',
            'unit'    => 's',
            'placeholder' => '0.75s',
        ];
        $this->controls['delay'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Delay', 'bricks' ),
            'type'    => 'number',
            'unit'    => 's',
            'placeholder' => '0s',
        ];
        $this->controls['ease'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'GSAP easing', 'bricks' ),
            'type' => 'select',
            'options'     => [
            'none' => 'none',
            'power1' => 'power1',
            'power2' => 'power2',
            'power3' => 'power3',
            'power4' => 'power4',
            'back' => 'back',
            'bounce' => 'bounce',
            'circ' => 'circ',
            'elastic' => 'elastic',
            'expo' => 'expo',
            'sine' => 'sine',
            'steps' => 'steps'
            ],
            'inline' => true,
            'placeholder' => 'power1',
        ];
        $this->controls['toggleActions'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Toggle actions', 'bricks' ),
            'type'    => 'text',
            'placeholder' => 'play none none none',
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next-lamp', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_lamp.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;

        $lampAngle = ! empty( $settings['lampAngle'] ) ? $settings['lampAngle'] : '70deg';

        $start = ! empty( $settings['start'] ) ? $settings['start'] : 'top bottom';
        $duration = ! empty( $settings['duration'] ) ? $settings['duration'] : 0.75;
        $delay = ! empty( $settings['delay'] ) ? $settings['delay'] : 0;
        $trigger = ! empty( $settings['trigger'] ) ? $settings['trigger'] : 'this';
        $easing = ! empty( $settings['ease'] ) ? $settings['ease'] : 'power1';
        $toggleActions = ! empty( $settings['toggleActions'] ) ? $settings['toggleActions'] : 'play none none none';

        $this->set_attribute( '_root', 'class', 'next-lamp' );
        $this->set_attribute( '_root', 'data-lamp-angle', "$lampAngle");
        $this->set_attribute( '_root', 'data-start', "$start");
        $this->set_attribute( '_root', 'data-duration', "$duration");
        $this->set_attribute( '_root', 'data-delay', "$delay");
        $this->set_attribute( '_root', 'data-trigger', "$trigger");
        $this->set_attribute( '_root', 'data-easing', "$easing");
        $this->set_attribute( '_root', 'data-toggleActions', "$toggleActions");

        $output = "<div {$this->render_attributes( '_root' )}>
            <div class='next-lamp__mask-left'>
                <div class='next-lamp__mask-left__child-left'></div>
                <div class='next-lamp__mask-left__child-right'></div>
            </div>
            <div class='next-lamp__mask-right'>
                <div class='next-lamp__mask-right__child-left'></div>
                <div class='next-lamp__mask-right__child-right'></div>
            </div>
            
            <div class='next-lamp__blur-bg'></div>
            <div class='next-lamp__backdrop-blur'></div>

            <div class='next-lamp__bg-top-line'></div>
            <div class='next-lamp__bg-mid-line'></div>
            <div class='next-lamp__bg-bottom-line'></div>
            <div class='next-lamp__line'></div>
        </div>";

        echo $output;
    }
}