<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Looping_Tabs extends \Bricks\Element {
    public $category     = 'Next Bricks - Cores';
    public $name         = 'next_looping_tabs';
    public $icon         = 'ti-layout-tab';
    public $tag      = 'div';
    public $scripts      = ['next_looping_tabs'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Looping Tabs', 'bricks' );
    }

    public function set_controls() {
        $this->controls['tag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'HTML tag', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'div' => 'div',
                'section' => 'section',
                'article' => 'article',
                'aside' => 'aside',
                'header' => 'header',
                'footer' => 'footer',
                'main' => 'main',
                'nav' => 'nav',
                'custom' => 'custom',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'div',
            'default'     => 'div',
        ];
        $this->controls['customTag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Custom tag', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'placeholder' => 'div',
            'required'    => [ 'tag', '=', 'custom' ],
        ];
    
        /*css*/
        $this->controls['blockStyleSeparator'] = [
            'label'      => esc_html__( 'Block Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['gap'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Gap', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                    'property' => 'gap',
                    'selector' => '',
                ]
            ],
            'default' => '8px',
        ];
        $this->controls['padding'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type'  => 'spacing',
            'units' => true,
            'css' => [
                [
                    'property' => 'padding',
                    'selector' => '',
                ]
            ],
            'default' => [
                'top' => '8',
                'right' => '8',
                'bottom' => '8',
                'left' => '8',
            ],
        ];
        $this->controls['width'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'width',
                'selector' => '',
              ]
            ],
            'default' => '100%',
        ];
        $this->controls['maxWidth'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Max Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'max-width',
                'selector' => '',
              ]
            ],
            'default' => '768px',
        ];
        $this->controls['height'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
            [
                'property' => 'height',
                'selector' => '',
            ]
            ],
            'default' => 'auto',
        ];
        $this->controls['backgroundColor'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type'  => 'background',
            'inline' => true,
            'css' => [
            [
                'property' => 'background',
                'selector' => '',
            ]
            ],
            'default' => [
                'color' => [
                    'hex' => '#f5f5f5',
                ]
            ],
        ];
        $this->controls['border'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type'  => 'border',
            'inline' => true,
            'css' => [
                [
                    'property' => 'border',
                    'selector' => '',
                ]
            ],
            'default' => [
                'width' => [
                    'top' => '1',
                    'right' => '1',
                    'bottom' => '1',
                    'left' => '1',
                ],
                'style' => 'solid',
                'color' => [
                    'hex' => '#00000010',
                ],
                'radius' => [
                    'top' => '10',
                    'right' => '10',
                    'bottom' => '10',
                    'left' => '10',
                ],
            ],
        ];
        
        $this->controls['navStyleSeparator'] = [
            'label'      => esc_html__( 'Nav Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['navSpacing'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type'  => 'spacing',
            'css' => [
                [
                    'property' => 'padding',
                    'selector' => '.nb-looping-tabs__nav',
                ]
            ],
            'default' => [
                'top' => '8',
                'right' => '8',
                'bottom' => '8',
                'left' => '8',
            ],
        ];
        $this->controls['navGap'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Gap', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                    'property' => 'gap',
                    'selector' => '.nb-looping-tabs__nav',
                ]
            ],
            'default' => '8px',
        ];
        $this->controls['navWidth'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                    'property' => 'width',
                    'selector' => '.nb-looping-tabs__nav',
                ]
            ],
            'default' => '30%',
        ];
        $this->controls['navHeight'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                    'property' => 'min-height',
                    'selector' => '.nb-looping-tabs__nav',
                ]
            ],
            'default' => '100%',
        ];
        $this->controls['navBackground'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type'  => 'background',
            'css' => [
                [
                    'property' => 'background',
                    'selector' => '.nb-looping-tabs__nav',
                ]
            ],
            'default' => [
                'color' => [
                    'hex' => '#fff',
                ]
            ],
        ];
        $this->controls['navBorder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type'  => 'border',
            'css' => [
                [
                    'property' => 'border',
                    'selector' => '.nb-looping-tabs__nav',
                ]
            ],
            'default' => [
                'width' => [
                    'top' => '1',
                    'right' => '1',
                    'bottom' => '1',
                    'left' => '1',
                ],
                'style' => 'solid',
                'color' => [
                    'hex' => '#00000010',
                ],
                'radius' => [
                    'top' => '6',
                    'right' => '6',
                    'bottom' => '6',
                    'left' => '6',
                ],
            ],
        ];

        $this->controls['navItemStyleSeparator'] = [
            'label'      => esc_html__( 'Nav Item Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['navItemSpacing'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type'  => 'spacing',
            'css' => [
                [
                    'property' => 'padding',
                    'selector' => '.nb-looping-tabs__nav-item',
                ],
            ],
            'default' => [
                'top' => '8',
                'right' => '8',
                'bottom' => '8',
                'left' => '8',
            ],
        ];
        $this->controls['navItemGap'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Gap', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'gap',
                    'selector' => '.nb-looping-tabs__nav-item',
                ],
            ],
            'default' => '8px',
        ];
        $this->controls['navItemTypography'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Typography', 'bricks' ),
            'type'  => 'typography',
            'css' => [
                [
                    'property' => 'typography',
                    'selector' => '.nb-looping-tabs__nav-item',
                ],
            ],
            'default' => [
                'font-size' => '14px',
                'font-weight' => '500',
                'color' => [
                    'hex' => '#000',
                ],
                'line-height' => 'normal',
            ],
        ];
        $this->controls['navItemBackground'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type'  => 'background',
            'css' => [
                [
                    'property' => 'background',
                    'selector' => '.nb-looping-tabs__nav-item',
                ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#fff',
                ]
            ],
        ];
        $this->controls['navItemBorder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type'  => 'border',
            'css' => [
                [
                    'property' => 'border',
                    'selector' => '.nb-looping-tabs__nav-item',
                ],
            ],
            'default' => [
                'width' => [
                    'top' => '1',
                    'right' => '1',
                    'bottom' => '1',
                    'left' => '1',
                ],
                'style' => 'solid',
                'color' => [
                    'hex' => '#00000010',
                ],
                'radius' => [
                    'top' => '6',
                    'right' => '6',
                    'bottom' => '6',
                    'left' => '6',
                ],
            ],
        ];

        $this->controls['navItemActiveStyleSeparator'] = [
            'label'      => esc_html__( 'Nav Item Active Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['navItemActiveTypography'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Typography', 'bricks' ),
            'type'  => 'typography',
            'css' => [
                [
                    'property' => 'typography',
                    'selector' => '.nb-looping-tabs__nav-item--active, .nb-looping-tabs__nav-item:hover, .nb-looping-tabs__nav-item:focus-visible',
                ],
            ],
        ];
        $this->controls['navItemActiveBackground'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type'  => 'background',
            'css' => [
                [
                    'property' => 'background',
                    'selector' => '.nb-looping-tabs__nav-item--active, .nb-looping-tabs__nav-item:hover, .nb-looping-tabs__nav-item:focus-visible',
                ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#f5f5f5',
                ]
            ],
        ];
        $this->controls['navItemActiveBackgroundDuration'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background Duration', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                    'property' => '--nav-item-bg-duration',
                    'selector' => '.nb-looping-tabs__nav-item',
                ],
            ],
            'default' => '0.2s',
        ];
        $this->controls['navItemActiveBackgroundEasing'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background CSS Easing', 'bricks' ),
            'type'  => 'text',
            'inline' => true,
            'css' => [
                [
                    'property' => '--nav-item-bg-ease',
                    'selector' => '.nb-looping-tabs__nav-item',
                ],
            ],
            'default' => 'ease-in-out',
        ];

        $this->controls['progressStyleSeparator'] = [
            'label'      => esc_html__( 'Progress Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['mode'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Mode', 'bricks' ),
            'type'  => 'select',
            'inline' => true,
            'options' => [
                'horizontal' => esc_html__( 'Horizontal', 'bricks' ),
                'vertical' => esc_html__( 'Vertical', 'bricks' ),
            ],
            'default' => 'horizontal',
        ];
        $this->controls['loopPadding'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                    'property' => '--padding',
                    'selector' => '.nb-looping-tabs__loop',
                ],
            ],
            'default' => '3px',
        ];
        $this->controls['loopHorizontalWidth'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width (horizontal)', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'width',
                    'selector' => '.nb-looping-tabs__loop',
                ],
            ],
            'default' => '100%',
            'required' => [ 'mode', '=', 'horizontal'],
        ];
        $this->controls['loopHorizontalHeight'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height (horizontal)', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'height',
                    'selector' => '.nb-looping-tabs__loop',
                ],
            ],
            'default' => '14px',
            'required' => [ 'mode', '=', 'horizontal'],
        ];
        $this->controls['loopVerticalWidth'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width (vertical)', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'width',
                    'selector' => '&[data-mode="vertical"] .nb-looping-tabs__loop',
                ],
            ],
            'default' => '14px',
            'required' => [ 'mode', '=', 'vertical'],
        ];
        $this->controls['loopVerticalHeight'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height (vertical)', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'height',
                    'selector' => '&[data-mode="vertical"] .nb-looping-tabs__loop',
                ],
            ],
            'default' => '80px',
            'required' => [ 'mode', '=', 'vertical'],
        ];
        $this->controls['loopBackgroundColor'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Path Outer Color', 'bricks' ),
            'type'  => 'color',
            'css' => [
                [
                    'property' => 'background-color',
                    'selector' => '.nb-looping-tabs__loop',
                ],
            ],
            'default' => [
                'hex' => '#ffffff',
            ],
        ];
        $this->controls['loopBackgroundColor'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Path Inner Color', 'bricks' ),
            'type'  => 'color',
            'css' => [
                [
                    'property' => 'background-color',
                    'selector' => '.nb-looping-tabs__loop-mask',
                ],
            ],
            'default' => [
                'hex' => '#f5f5f5',
            ],
        ];
        $this->controls['loopBorder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type'  => 'border',
            'css' => [
                [
                    'property' => 'border',
                    'selector' => '.nb-looping-tabs__loop',
                ],
            ],
            'default' => [
                'width' => '1px',
                'style' => 'solid',
                'color' => [
                    'hex' => '#00000010',
                ],
            ],
            'exclude' => [
                'radius',
            ],
        ];
        $this->controls['loopBorderRadius'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border Radius', 'bricks' ),
            'type'  => 'number',
            'inline' => true,
            'css' => [
                [
                    'property' => '--shared-progress-radius',
                    'selector' => '.nb-looping-tabs__loop',
                ],
            ],
            'default' => '100px',
        ];
        $this->controls['loopBoxShadow'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Box Shadow', 'bricks' ),
            'type'  => 'box-shadow',
            'css' => [
                [
                    'property' => 'box-shadow',
                    'selector' => '.nb-looping-tabs__loop',
                ],
            ],
            'default' => [
                'values' => [
                    'offsetX' => 0,
                    'offsetY' => 2,
                    'blur' => 2,
                    'spread' => 1,
                ],
                'color' => [
                  'rgb' => 'rgba(0, 0, 0, 0.1)',
              ],
            ],
        ];

        $this->controls['animationSeparator'] = [
            'label'      => esc_html__( 'Progress Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['disablebuilder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
            'type'     => 'checkbox',
            'default' => false,
        ];
        $this->controls['loopDuration'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type' => 'number',
            'unit' => 's',
            'inline' => true,
            'default' => '3s',
        ];
        $this->controls['gsapEase'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'GSAP Easing', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'none' => 'none',
                'power1' => 'power1',
                'power2' => 'power2',
                'power3' => 'power3',
                'power4' => 'power4',
                'back' => 'back',
                'bounce' => 'bounce',
                'circ' => 'circ',
                'elastic' => 'elastic',
                'expo' => 'expo',
                'sine' => 'sine',
                'steps' => 'steps'
            ],
            'inline' => true,
            'placeholder' => 'power2',
        ];

        $this->controls['tabsWrapperSeparator'] = [
            'label'      => esc_html__( 'Tabs Wrapper', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['tabsWrapperWidth'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'width',
                    'selector' => '.nb-looping-tabs__tabs-wrapper',
                ],
            ],
            'default' => '70%'
        ];
        $this->controls['tabsWrapperHeight'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'min-height',
                    'selector' => '.nb-looping-tabs__tabs-wrapper',
                ],
            ],
            'default' => '100%'
        ];

        $this->controls['tabSeparator'] = [
            'label'      => esc_html__( 'Tab', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['activeTab'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Active Tab', 'bricks' ),
            'type'  => 'number',
            'inline' => true,
            'default' => '1',
        ];
        $this->controls['tabWidth'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'width',
                    'selector' => '.nb-looping-tabs__tab',
                ],
            ],
            'default' => '100%'
        ];
        $this->controls['tabHeight'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'height',
                    'selector' => '.nb-looping-tabs__tab',
                ],
            ],
            'default' => '100%'
        ];
        $this->controls['tabBackgroundColor'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type'  => 'background',
            'css' => [
                [
                    'property' => 'background',
                    'selector' => '.nb-looping-tabs__tab',
                ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#f9f9f9',
                ]
            ],
        ];
        $this->controls['tabBorder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type'  => 'border',
            'css' => [
                [
                    'property' => 'border',
                    'selector' => '.nb-looping-tabs__tab',
                ],
            ],
            'default' => [
                'width' => '1px',
                'style' => 'solid',
                'color' => [
                    'hex' => '#00000010',
                ],
                'radius' => [
                    'top' => '8',
                    'right' => '8',
                    'bottom' => '8',
                    'left' => '8',
                ],
            ],
        ];
    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Nav', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'nb-looping-tabs__nav',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'next_looping_nav_item',
                        'settings' => [
                            'gradient' => [
                                "applyTo" => "background",
                                "gradientType" => "linear",
                                "colors" => [
                                    ["id" => "yapkvw", "color" => ["hex" => "#ff0000"]],
                                    ["id" => "seeqqu", "color" => ["hex" => "#ffa500"]]
                                ],
                                "angle" => "90"
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'heading',
                                'label'    => esc_html__( 'Heading', 'bricks' ),
                                'settings' => [
                                    'text' => esc_html__( 'Tab', 'bricks' ),
                                    'tag'  => 'span',
                                ],
                            ],
                        ],
                    ],
                    [
                        'name'     => 'next_looping_nav_item',
                        'settings' => [
                            'gradient' => [
                                "applyTo" => "background",
                                "gradientType" => "linear",
                                "colors" => [
                                    ["id" => "yapkvw", "color" => ["hex" => "#0066ff"]],
                                    ["id" => "seeqqu", "color" => ["hex" => "#00ccff"]]
                                ],
                                "angle" => "90"
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'heading',
                                'label'    => esc_html__( 'Heading', 'bricks' ),
                                'settings' => [
                                    'text' => esc_html__( 'Tab', 'bricks' ),
                                    'tag'  => 'span',
                                ],
                            ],
                        ],
                    ],
                    [
                        'name'     => 'next_looping_nav_item',
                        'settings' => [
                            'gradient' => [
                                "applyTo" => "background",
                                "gradientType" => "linear",
                                "colors" => [
                                    ["id" => "yapkvw", "color" => ["hex" => "#00cc66"]],
                                    ["id" => "seeqqu", "color" => ["hex" => "#33ff99"]]
                                ],
                                "angle" => "90"
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'heading',
                                'label'    => esc_html__( 'Heading', 'bricks' ),
                                'settings' => [
                                    'text' => esc_html__( 'Tab', 'bricks' ),
                                    'tag'  => 'span',
                                ],
                            ],
                        ],
                    ],
                    [
                        'name'     => 'next_looping_nav_item',
                        'settings' => [
                            'gradient' => [
                                "applyTo" => "background",
                                "gradientType" => "linear",
                                "colors" => [
                                    ["id" => "yapkvw", "color" => ["hex" => "#6600cc"]],
                                    ["id" => "seeqqu", "color" => ["hex" => "#cc66ff"]]
                                ],
                                "angle" => "90"
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'heading',
                                'label'    => esc_html__( 'Heading', 'bricks' ),
                                'settings' => [
                                    'text' => esc_html__( 'Tab', 'bricks' ),
                                    'tag'  => 'span',
                                ],
                            ],
                        ],
                    ],
                ]
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Tabs', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'nb-looping-tabs__tabs-wrapper',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Tab', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'nb-looping-tabs__tab',
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'image',
                                'label'    => esc_html__( 'Image', 'bricks' ),
                                'settings' => [
                                        'image'  => [
                                        'url' => 'https://oxyfolio.com/wp-content/uploads/2025/04/14-1-scaled.jpg',
                                    ],
                                ],
                            ],
                        ],
                    ],
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Tab', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'nb-looping-tabs__tab',
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'image',
                                'label'    => esc_html__( 'Image', 'bricks' ),
                                'settings' => [
                                        'image'  => [
                                        'url' => 'https://oxyfolio.com/wp-content/uploads/2025/04/24-scaled.jpg',
                                    ],
                                ],
                            ],
                        ],
                    ],
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Tab', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'nb-looping-tabs__tab',
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'image',
                                'label'    => esc_html__( 'Image', 'bricks' ),
                                'settings' => [
                                        'image'  => [
                                        'url' => 'https://oxyfolio.com/wp-content/uploads/2025/04/74-scaled.jpg',
                                    ],
                                ],
                            ],
                        ],
                    ],
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Tab', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'nb-looping-tabs__tab',
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'image',
                                'label'    => esc_html__( 'Image', 'bricks' ),
                                'settings' => [
                                        'image'  => [
                                        'url' => 'https://oxyfolio.com/wp-content/uploads/2025/04/83-scaled.jpg',
                                    ],
                                ],
                            ],
                        ],
                    ],
                ]
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_looping_tabs', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_looping_tabs.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
        $mode = ! empty( $settings['mode'] ) ? $settings['mode'] : 'horizontal';
        $activeTab = ! empty( $settings['activeTab'] ) ? $settings['activeTab'] : 1;
        $loopDuration = ! empty( $settings['loopDuration'] ) ? $settings['loopDuration'] : 3;
        $gsapEase = ! empty( $settings['gsapEase'] ) ? $settings['gsapEase'] : 'power2';

        $this->set_attribute( '_root', 'class', "nb-looping-tabs");
        $this->set_attribute( '_root', 'data-flickering', '1');
        $this->set_attribute( '_root', 'data-disable-builder', $disablebuilder);
        $this->set_attribute( '_root', 'data-mode', $mode);
        $this->set_attribute( '_root', 'data-active-tab', $activeTab);
        $this->set_attribute( '_root', 'data-loop-duration', $loopDuration);
        $this->set_attribute( '_root', 'data-gsap-ease', $gsapEase);

        $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
        $output .= Frontend::render_children( $this );
        $output .= "</{$this->tag}>";

        echo $output;
    }
}