<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Meteors extends \Bricks\Element {
    public $category     = 'Next Bricks - Backgrounds';
    public $name         = 'next_meteors';
    public $icon         = 'fas fa-meteor';
    public $tag      = 'div';
    public $scripts      = ['next_meteors'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Meteors', 'bricks' );
    }

    public function set_controls() {
        $this->controls['tag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'HTML tag', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'div' => 'div',
                'section' => 'section',
                'article' => 'article',
                'aside' => 'aside',
                'header' => 'header',
                'footer' => 'footer',
                'main' => 'main',
                'nav' => 'nav',
                'custom' => 'custom',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'div',
            'default'     => 'div',
        ];
        $this->controls['customTag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Custom tag', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'placeholder' => 'div',
            'required'    => [ 'tag', '=', 'custom' ],
        ];
        $this->controls['note0'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Each Meteor settings and styles can be edited at its own element.', 'bricks' )))
        ];
        $this->controls['disablebuilder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Disable Meteors at builder', 'bricks' ),
            'type'     => 'checkbox',
            'default' => false,
        ];

        $this->controls['width'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => 'width',
                    'selector' => '',
                ],
            ],
            'placeholder' => '100vw',
        ];
        $this->controls['height'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => 'height',
                    'selector' => '',
                ],
            ],
            'placeholder' => '100vh',
        ];

        /*Content*/
        $this->controls['contentSeparator'] = [
            'label'      => esc_html__( 'Content', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Meteors children elements must be placed at Content element. Content styles can be edited here or at its style tab.', 'bricks' )))
        ];
        $this->controls['CONTENTwidth'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => 'width',
                    'selector' => '.next-meteors__content',
                ],
            ],
            'placeholder' => '350px',
        ];
        $this->controls['CONTENTheight'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => 'height',
                    'selector' => '.next-meteors__content',
                ],
            ],
            'placeholder' => '300px',
        ];
        $this->controls['CONTENTbackground'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type'  => 'background',
            'inline' => true,
            'css' => [
              [
                'property' => 'background',
                'selector' => '.next-meteors__content',
              ]
            ],
            'default' => [
                'color' => [
                  'hex' => '#00000056',
                ],
            ],
        ];
        $this->controls['CONTENTborder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type'  => 'border',
            'inline' => true,
            'css' => [
              [
                'property' => 'border',
                'selector' => '.next-meteors__content',
              ]
            ],
            'default' => [
                'radius' => [
                  'top' => 12,
                  'right' => 12,
                  'bottom' => 12,
                  'left' => 12,
                ],
            ],
        ];
        $this->controls['CONTENTblur'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Backdrop blur', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => '--blur',
                    'selector' => '.next-meteors__content',
                ],
            ],
            'placeholder' => '5px',
        ];
    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'next_meteor',
                'settings' => [
                    'top' => '20%',
                ],
            ],
            [
                'name'     => 'next_meteor',
                'settings' => [
                    'top' => '40%',
                ],
            ],
            [
                'name'     => 'next_meteor',
                'settings' => [
                    'top' => '60%',
                ],
            ],
            [
                'name'     => 'next_meteor',
                'settings' => [
                    'top' => '80%',
                ],
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Content', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-meteors__content',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Heading', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Meteors', 'bricks' ),
                            'tag'  => 'h3',
                        ],
                    ]
                ]
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_meteors', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_meteors.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;

        $this->set_attribute( '_root', 'class', "next-meteors");

        $output = "<{$this->tag} {$this->render_attributes( '_root' )}
            data-disable-builder='{$disablebuilder}'
        >";
        $output .= Frontend::render_children( $this );
        $output .= "</{$this->tag}>";

        echo $output;
    }
}