<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Mouse_Parallax extends \Bricks\Element {
    public $category     = 'Next Bricks - Cursors';
    public $name         = 'next_mouse_parallax';
    public $icon         = 'ti-layout-list-large-image';
    public $scripts      = ['next_mouse_parallax'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Mouse Parallax', 'bricks' );
    }

    public function set_controls() {
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Set a Parallax Class and apply it to the elements you want to have the parallax effect. They will receive an absolute position, so top, left, bottom and right can be set at their Style tab. These elements have also to be placed inside Mouse Parallax element.', 'bricks' )))
        ];
        $this->controls['customClass'] = [
            'tab' => 'content',
            'label' => esc_html__('Parallax Class', 'bricks'),
            'type' => 'text',
            'placeholder' => '.className',
        ];

        $this->controls['styleSeparator'] = [
            'label'      => esc_html__( 'Style', 'bricks' ),
            'type'       => 'separator',
        ];

        $this->controls['width'] = [
            'tab' => 'content',
            'label' => esc_html__('Width', 'bricks'),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                  'property' => 'width',
                  'selector' => '',
                ]
              ],
            'default' => '100%',
        ];

        $this->controls['height'] = [
            'tab' => 'content',
            'label' => esc_html__('Height', 'bricks'),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                  'property' => 'height',
                  'selector' => '',
                ]
              ],
            'default' => '100vh',
        ];

        $this->controls['background'] = [
            'tab' => 'content',
            'label' => esc_html__('Background', 'bricks'),
            'type' => 'background',
            'css' => [
                [
                  'property' => 'background',
                  'selector' => '',
                ]
              ],
            'default' => [
                'color' => [
                    'hex' => '#171717',
                ],
            ],
        ];

        $this->controls['animationSeparator'] = [
            'label'      => esc_html__( 'Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['note2'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'To customize the floating intensity of each element, use the attribute data-depth at the element Style tab > Attributes group. Elements have a data-depth of 1 by default.', 'bricks' )))
        ];
        $this->controls['sensitivity'] = [
            'tab' => 'content',
            'label' => esc_html__('Sensitivity', 'bricks'),
            'type' => 'number',
            'default' => 1,
        ];

        $this->controls['easingFactor'] = [
            'tab' => 'content', 
            'label' => esc_html__('Easing Factor', 'bricks'),
            'type' => 'number',
            'default' => 0.05,
        ];

        $this->controls['invertMovement'] = [
            'tab' => 'content',
            'label' => esc_html__('Invert Movement', 'bricks'),
            'type' => 'checkbox',
            'default' => true,
        ];

        $this->controls['useDeviceOrientation'] = [
            'tab' => 'content',
            'label' => esc_html__('Use Device Orientation', 'bricks'),
            'type' => 'checkbox',
            'default' => true,
        ];

        $this->controls['maxTilt'] = [
            'tab' => 'content',
            'label' => esc_html__('Max Tilt', 'bricks'),
            'type' => 'number',
            'default' => 15,
        ];
    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'heading',
                'label'    => esc_html__( 'Heading', 'bricks' ),
                'settings' => [
                    'text' => esc_html__( 'Mouse Parallax', 'bricks' ),
                ],
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_mouse_parallax', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_mouse_parallax.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $customClass = ! empty( $settings['customClass'] ) ? $settings['customClass'] : '';
        $sensitivity = ! empty( $settings['sensitivity'] ) ? $settings['sensitivity'] : 1;
        $easingFactor = ! empty( $settings['easingFactor'] ) ? $settings['easingFactor'] : 0.05;
        $invertMovement = ! empty( $settings['invertMovement'] ) ? $settings['invertMovement'] : 0;
        $useDeviceOrientation = ! empty( $settings['useDeviceOrientation'] ) ? $settings['useDeviceOrientation'] : 0;
        $maxTilt = ! empty( $settings['maxTilt'] ) ? $settings['maxTilt'] : 15;

        $this->set_attribute( '_root', 'class', "next-mouse-parallax");
        $this->set_attribute( '_root', 'data-custom-class', $customClass);
        $this->set_attribute( '_root', 'data-sensitivity', $sensitivity);
        $this->set_attribute( '_root', 'data-easing-factor', $easingFactor);
        $this->set_attribute( '_root', 'data-invert-movement', $invertMovement);
        $this->set_attribute( '_root', 'data-use-device-orientation', $useDeviceOrientation);
        $this->set_attribute( '_root', 'data-max-tilt', $maxTilt);

        $output = "<div {$this->render_attributes( '_root' )}>";
        $output .= Frontend::render_children( $this );
        $output .= '</div>';

        echo $output;
    }
}