<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Overlay_Shadows extends \Bricks\Element {
  public $category     = 'Next Bricks - Backgrounds';
  public $name         = 'next_overlay_shadows';
  public $icon         = 'fas fa-cannabis';
  public $tag      = 'div';
  public $scripts      = ['next_overlay_shadows'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Overlay Shadows', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
        'div' => 'div',
        'section' => 'section',
        'article' => 'article',
        'aside' => 'aside',
        'header' => 'header',
        'footer' => 'footer',
        'main' => 'main',
        'nav' => 'nav',
        'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['note'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Overlay Shadows is a nestable block element. You can put any elements at it and edit its display settings at the Style tab.', 'bricks' )))
    ];

    /*css*/
    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Block Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['width'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'width',
            'selector' => '',
          ]
        ],
        'default' => '100%',
    ];
    $this->controls['height'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'height',
            'selector' => '',
          ]
        ],
        'default' => '500px',
    ];
    $this->controls['background'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Background', 'bricks' ),
        'type'  => 'color',
        'inline' => true,
        'css' => [
          [
            'property' => 'background',
            'selector' => '.nb-overlay-shadows__background',
          ]
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];

    /*js settings*/
    $this->controls['shadowsSeparator'] = [
        'label'      => esc_html__( 'Shadows', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['type'] = [
      'tab' => 'content',
      'label' => esc_html__('Type', 'bricks'),
      'type' => 'select',
      'options' => [
        '1' => esc_html__('1', 'bricks'),
        '2' => esc_html__('2', 'bricks'),
        '3' => esc_html__('3', 'bricks'),
        '4' => esc_html__('4', 'bricks'),
        '5' => esc_html__('5', 'bricks'),
        '6' => esc_html__('6', 'bricks'),
        '7' => esc_html__('7', 'bricks'),
        '8' => esc_html__('8', 'bricks'),
        '9' => esc_html__('9', 'bricks'),
        '10' => esc_html__('10', 'bricks'),
        '11' => esc_html__('11', 'bricks'),
        '12' => esc_html__('12', 'bricks'),
        '13' => esc_html__('13', 'bricks'),
        '14' => esc_html__('14', 'bricks'),
        '15' => esc_html__('15', 'bricks'),
        '16' => esc_html__('16', 'bricks'),
        '17' => esc_html__('17', 'bricks'),
        '18' => esc_html__('18', 'bricks'),
        '19' => esc_html__('19', 'bricks'),
        '20' => esc_html__('20', 'bricks'),
        '21' => esc_html__('21', 'bricks'),
        '22' => esc_html__('22', 'bricks'),
        '23' => esc_html__('23', 'bricks'),
        '24' => esc_html__('24', 'bricks'),
        '25' => esc_html__('25', 'bricks'),
        '26' => esc_html__('26', 'bricks'),
        '27' => esc_html__('27', 'bricks'),
        '28' => esc_html__('28', 'bricks'),
        '29' => esc_html__('29', 'bricks'),
        '30' => esc_html__('30', 'bricks'),
        '31' => esc_html__('31', 'bricks'),
        '32' => esc_html__('32', 'bricks'),
      ],
      'default' => '1',
      'inline' => true,
      'small' => true,
      'clearable' => false,
    ];
    $this->controls['maskColor'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Color', 'bricks' ),
        'type'  => 'color',
        'inline' => true,
        'css' => [
          [
            'property' => 'background',
            'selector' => '.nb-overlay-shadows__mask',
          ]
        ],
        'default' => [
            'rgb' => 'rgb(0,0,0,0.2)',
        ],
    ];
    $this->controls['includeNoise'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Noise', 'bricks' ),
        'type'  => 'checkbox',
        'default' => true,
    ];
    $this->controls['noiseOpacity'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Noise Opacity', 'bricks' ),
        'type'  => 'number',
        'css' => [
          [
            'property' => 'opacity',
            'selector' => '.nb-overlay-shadows__noise',
          ]
        ],
        'min' => 0,
        'max' => 1,
        'step' => 0.01,
        'default' => 0.25,
        'required' => [ 'includeNoise', '=', true],
    ];
  }

  public function get_nestable_children() {
    return [
        [
            'name'     => 'block',
            'label'    => esc_html__( 'Content', 'bricks' ),
            'settings' => [
                '_hidden'  => [
                    '_cssClasses' => 'nb-overlay-shadows__content',
                ],
            ],
            'children' => [
                [
                    'name'     => 'heading',
                    'label'    => esc_html__( 'Heading', 'bricks' ),
                    'settings' => [
                        'text' => esc_html__( 'Overlay Shadows', 'bricks' ),
                        'tag'  => 'h3',
                    ],
                ]
            ]
        ],
    ];
}

  public function enqueue_scripts() {
    wp_enqueue_script( 'next_overlay_shadows', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_overlay_shadows.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $type    = ! empty( $settings['type'] ) ? $settings['type'] : 1;
    $includeNoise = ! empty( $settings['includeNoise'] ) ? $settings['includeNoise'] : 0;

    $this->set_attribute( '_root', 'class', "nb-overlay-shadows");
    switch($type) {
      case 1:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/1.png';
        break;
      case 2:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/2.png';
        break;
      case 3:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/3.png';
        break;
      case 4:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/4.png';
        break;
      case 5:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/5.png';
        break;
      case 6:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/6.png';
        break;
      case 7:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/7.png';
        break;
      case 8:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/8.png';
        break;
      case 9:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/9.png';
        break;
      case 10:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/10.png';
        break;
      case 11:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/11.png';
        break;
      case 12:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/12.png';
        break;
      case 13:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/13.png';
        break;
      case 14:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/14.png';
        break;
      case 15:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/15.png';
        break;
      case 16:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/16.png';
        break;
      case 17:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/17.png';
        break;
      case 18:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/18.png';
        break;
      case 19:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/19.png';
        break;
      case 20:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/20.png';
        break;
      case 21:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/21.png';
        break;
      case 22:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/22.png';
        break;
      case 23:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/23.png';
        break;
      case 24:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/24.png';
        break;
      case 25:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/25.png';
        break;
      case 26:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/26.png';
        break;
      case 27:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/27.png';
        break;
      case 28:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/28.png';
        break;
      case 29:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/29.png';
        break;
      case 30:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/30.png';
        break;
      case 31:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/31.png';
        break;
      case 32:
        $src = NEXTBRICKS_PLUGIN_URL . 'elements/css/srcs/32.png';
        break;
    }
    $includeNoiseAttr = ($includeNoise == 0) ? "data-include-noise='false'" : '';

    $output = "<{$this->tag} {$this->render_attributes( '_root' )}
    data-src='{$src}'
    {$includeNoiseAttr}
    data-flickering='1'>";
    $output .= '<div class="nb-overlay-shadows__background"></div>
                <div class="nb-overlay-shadows__mask"></div>
                <div class="nb-overlay-shadows__noise"></div>';
    $output .= Frontend::render_children( $this );
    $output .= "</{$this->tag}>";

	echo $output;
  }
}