<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Parallax_Slider_Item extends \Bricks\Element {
    public $name         = 'next_parallax_slider_item';
    public $icon         = 'ti-layout-list-large-image';
    public $scripts      = ['next_parallax_slider_item'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Slider Item', 'bricks' );
    }

    public function set_controls() {
        $this->controls['image'] = [
            'hasDynamicData' => true,
            'tab' => 'content',
            'label' => esc_html__( 'Image', 'bricks' ),
            'type' => 'image',
        ];
        $this->controls['alt'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Alt text', 'bricks' ),
            'type' => 'text',
            'inline' => true,
        ];
        $this->controls['_objectFit'] = [
            'label'   => esc_html__( 'Object fit', 'bricks' ),
            'type'    => 'select',
            'inline'  => true,
            'options' => $this->control_options['objectFit'],
            'css' => [
                [
                    'property' => 'object-fit',
                    'selector' => '.next-parallax-slider__item-img',
                ],
            ],
        ];
        $this->controls['_objectPosition'] = [
            'tab' => 'content',
            'label'  => esc_html__( 'Object position', 'bricks' ),
            'type'   => 'text',
            'inline' => true,
            'dd'     => false,
            'css' => [
                [
                    'property' => 'object-position',
                    'selector' => '.next-parallax-slider__item-img',
                ],
            ],
        ];
        $this->controls['imageFilters'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Filters', 'bricks' ),
            'type' => 'filters',
            'inline' => true,
            'css' => [
                [
                    'property' => 'filter',
                    'selector' => '.next-parallax-slider__item-img',
                ],
            ],
        ];
    }

    public function render() {
        $settings = $this->settings;

        //Render dynamic data
        if (isset($settings['image']['useDynamicData'])){
            $source = $this->render_dynamic_data_tag($settings['image']['useDynamicData'], 'image');
            $source = wp_get_attachment_url($source[0]);
        }
        //Render normal image
        else if (isset($settings['image'])) {
            $source = $settings['image']['url'];
        }
        //Render default
        else{
            $source = 'https://images.unsplash.com/photo-1523181729404-8a3b7b6f918d?ixlib=rb-1.2.1&ixid=eyJhcHBfaWQiOjEyMDd9&auto=format&fit=crop&w=800&q=80&ar=0.5';
        }

        $this->set_attribute( '_root', 'class', "next-parallax-slider__item");
        $this->set_attribute( '_image', 'class', "next-parallax-slider__item-img");
        $this->set_attribute( '_image', 'src', $source);

        $output = "<div {$this->render_attributes( '_root' )}>";

        $output .= '<div class="next-parallax-slider__item-img-wrap">';
        $output .= "<img {$this->render_attributes( '_image' )}>";
        $output .= '</div>';

        $output .= '<div class="next-parallax-slider__item-content">';
        $output .= Frontend::render_children( $this );
        $output .= '</div>';
        
        $output .= '</div>';

        echo $output;
    }
}