<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Physics extends \Bricks\Element {
  public $category     = 'Next Bricks - Backgrounds';
  public $name         = 'next_physics';
  public $icon         = 'fas fa-draw-polygon';
  public $tag      = 'div';
  public $scripts      = ['next_physics'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Physics', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'div' => 'div',
            'section' => 'section',
            'article' => 'article',
            'aside' => 'aside',
            'header' => 'header',
            'footer' => 'footer',
            'main' => 'main',
            'nav' => 'nav',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'div',
        'default'     => 'div',
    ];
    $this->controls['customTag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Custom tag', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'placeholder' => 'div',
        'required'    => [ 'tag', '=', 'custom' ],
    ];
    $this->controls['note'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Physics is a nestable block element. You can put any elements at it and edit its display settings at the Style tab.', 'bricks' )))
    ];
    $this->controls['elements'] = [
        'tab'           => 'content',
        'type'          => 'repeater',
        'label'         => esc_html__( 'Physics Objects', 'bricks' ),
        'placeholder'   => esc_html__( 'Physics Object', 'bricks' ),
        'titleProperty' => 'title',
        'default' => [
            [
                'shape' => 'rectangle',
                'horizontal' => '50',
                'vertical' => '100',
                'borderradius' => '10',
                'fill' => 'lightblue',
                'static' => false,
                'restitution' => '0.3',
                'friction' => '0.1',
                'frictionAir' => '0.01',
                'density' => '0.001',
            ],
            [
                'shape' => 'rectangle',
                'horizontal' => '100',
                'vertical' => '100',
                'borderradius' => '10',
                'fill' => 'lightblue',
                'static' => false,
                'restitution' => '0.3',
                'friction' => '0.1',
                'frictionAir' => '0.01',
                'density' => '0.001',
            ],
            [
                'shape' => 'rectangle',
                'horizontal' => '150',
                'vertical' => '100',
                'borderradius' => '10',
                'fill' => 'lightblue',
                'static' => false,
                'restitution' => '0.3',
                'friction' => '0.1',
                'frictionAir' => '0.01',
                'density' => '0.001',
            ],
          ],
        'fields'        => [
            'style'       => [
                'type'    => 'separator',
                'label'   => esc_html__( 'Style', 'bricks' ),
            ],
            'shape'       => [
                'label'   => esc_html__( 'Shape', 'bricks' ),
                'type'        => 'select',
                'options'     => [
                    'rectangle' => 'rectangle',
                    'circle' => 'circle',
                    'polygon' => 'polygon',
                ],
                'placeholder' => 'rectangle',
                'inline'    => true,
                'clearable'    => false,
            ],
            'horizontal'       => [
                'type'    => 'text',
                'label'   => esc_html__( 'Horizontal position', 'bricks' ),
                'placeholder' => '100',
                'inline'    => true,
            ],
            'vertical'       => [
                'type'    => 'text',
                'label'   => esc_html__( 'Vertical position', 'bricks' ),
                'placeholder' => '100',
                'inline'    => true,
            ],
            'width'       => [
                'type'    => 'text',
                'label'   => esc_html__( 'Width', 'bricks' ),
                'placeholder' => '100',
                'required'    => [ ['shape', '!=', 'circle'] , [ 'shape', '!=', 'polygon' ] ],
                'inline'    => true,
            ],
            'height'       => [
                'type'    => 'text',
                'label'   => esc_html__( 'Height', 'bricks' ),
                'placeholder' => '50',
                'required'    => [ ['shape', '!=', 'circle'] , [ 'shape', '!=', 'polygon' ] ],
                'inline'    => true,
            ],
            'radiusCircle'       => [
                'type'    => 'text',
                'label'   => esc_html__( 'Radius', 'bricks' ),
                'placeholder' => '100',
                'required'    => ['shape', '=', 'circle'],
                'inline'    => true,
            ],
            'radiusPolygon'       => [
                'type'    => 'text',
                'label'   => esc_html__( 'Radius', 'bricks' ),
                'placeholder' => '100',
                'required'    => ['shape', '=', 'polygon'],
                'inline'    => true,
            ],
            'sides'       => [
                'type'    => 'text',
                'label'   => esc_html__( 'Sides', 'bricks' ),
                'placeholder' => '5',
                'required'    => ['shape', '=', 'polygon'],
                'inline'    => true,
            ],
            'borderradius'       => [
                'type'    => 'text',
                'label'   => esc_html__( 'Border radius', 'bricks' ),
                'inline'    => true,
                'placeholder'    => '10',
            ],

            'imageNote'       => [
                'description' => sprintf(html_entity_decode(esc_html__( 'Image is a texture for the shape. Dimensions or collision borders come from the shape crafted.', 'bricks' )))
            ],
            'useimage'       => [
                'type'    => 'checkbox',
                'label'   => esc_html__( 'Load image', 'bricks' ),
            ],
            'image'       => [
                'type'    => 'image',
                'label'   => esc_html__( 'Image', 'bricks' ),
                'required'    => ['useimage', '=', true],
            ],
            'imagescale'       => [
                'type'    => 'text',
                'label'   => esc_html__( 'Image scale', 'bricks' ),
                'required'    => ['useimage', '=', true],
                'inline'    => true,
                'placeholder'    => '1',
            ],
            'fill'       => [
                'type'    => 'color',
                'label'   => esc_html__( 'Fill', 'bricks' ),
                'required'    => ['useimage', '!=', true],
            ],
            'strokecolor'       => [
                'type'    => 'color',
                'label'   => esc_html__( 'Stroke color', 'bricks' ),
                'required'    => ['useimage', '!=', true],
            ],
            'strokewidth'       => [
                'type'    => 'text',
                'label'   => esc_html__( 'Stroke width', 'bricks' ),
                'required'    => ['useimage', '!=', true],
                'inline'    => true,
                'placeholder'    => '0',
            ],

            'settings'       => [
                'type'    => 'separator',
                'label'   => esc_html__( 'Settings', 'bricks' ),
            ],
            'link' => [
                'type'    => 'text',
                'label'   => esc_html__( 'Link URL', 'bricks' ),
                'inline'  => true,
                'placeholder' => 'URL',
            ],
            'link_target' => [
                'type'    => 'checkbox',
                'label'   => esc_html__( 'Open in new tab', 'bricks' ),
                'inline'     => true,
                'required'   => ['link', '!=', ''],
            ],
            'static'       => [
                'type'    => 'checkbox',
                'label'   => esc_html__( 'Static', 'bricks' ),
            ],
            'restitution'       => [
                'type'    => 'text',
                'label'   => esc_html__( 'Restitution', 'bricks' ),
                'placeholder' => '0.3',
                'inline'    => true,
            ],
            'friction'       => [
                'type'    => 'text',
                'label'   => esc_html__( 'Friction', 'bricks' ),
                'placeholder' => '0.1',
                'inline'    => true,
            ],
            'frictionAir'       => [
                'type'    => 'text',
                'label'   => esc_html__( 'Friction Air', 'bricks' ),
                'placeholder' => '0.01',
                'inline'    => true,
            ],
            'density'       => [
                'type'    => 'text',
                'label'   => esc_html__( 'Density', 'bricks' ),
                'placeholder' => '0.001',
                'inline'    => true,
            ],
        ],
    ];

    //wrapper style section
    $this->controls['wrapperStyleSeparator'] = [
        'label'      => esc_html__( 'Block Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['width'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type' => 'number',
        'units' => true,
        'css' => [
            [
                'property' => 'width',
                'selector' => '',
            ]
        ],
        'placeholder' => '100%',
        'rerender' => true,
    ];
    $this->controls['height'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type' => 'number',
        'units' => true,
        'css' => [
            [
                'property' => 'height',
                'selector' => '',
            ]
        ],
        'placeholder' => '500px',
        'rerender' => true,
    ];
    $this->controls['background'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Background', 'bricks' ),
        'type' => 'color',

        'css' => [
            [
                'property' => '--background-color',
                'selector' => '',
            ]
        ],
        'placeholder' => '500px',
    ];

    //settings section
    $this->controls['settingsSeparator'] = [
        'label'      => esc_html__( 'Settings', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['builderedit'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
        'type'     => 'checkbox',
    ];
    $this->controls['gravityHorizontal'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Horizontal Gravity', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'small' => true,
        'placeholder' => '0',
    ];
    $this->controls['gravityVertical'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Vertical Gravity', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'small' => true,
        'placeholder' => '1',
    ];
    $this->controls['timeScale'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Time scale', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'small' => true,
        'placeholder' => '1',
    ];
    $this->controls['stiffness'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Mouse stiffness', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'small' => true,
        'placeholder' => '0.2',
    ];
    $this->controls['wireframes'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Wireframes', 'bricks' ),
        'type' => 'checkbox',
        'default' => false,
    ];

    //walls section
    $this->controls['wallsSeparator'] = [
        'label'      => esc_html__( 'Walls', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['enableTopWall'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Top', 'bricks' ),
        'type' => 'checkbox',
        'default' => true,
    ];
    $this->controls['enableBottomWall'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Bottom', 'bricks' ),
        'type' => 'checkbox',
        'default' => true,
    ];
    $this->controls['enableLeftWall'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Left', 'bricks' ),
        'type' => 'checkbox',
        'default' => true,
    ];
    $this->controls['enableRightWall'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Right', 'bricks' ),
        'type' => 'checkbox',
        'default' => true,
    ];
    $this->controls['wallVisible'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Visible', 'bricks' ),
        'type' => 'checkbox',
        'default' => true,
    ];
    $this->controls['wallFill'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Background', 'bricks' ),
        'type' => 'color',
        'css' => [
            [
                'property' => '--fill-wall',
                'selector' => '',
            ]
        ],
        'clearable' => false,
        'default' => [
            'hex' => '#9e9e9e',
        ],
        'rerender' => true,
    ];
    $this->controls['wallWidth'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'small' => true,
        'placeholder' => '10',
    ];

    //ScrollTrigger section
    $this->controls['scrollTriggerSeparator'] = [
        'label'      => esc_html__( 'ScrollTrigger', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['trigger'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Trigger', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'this',
    ];
    $this->controls['start'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Start', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'top bottom',
    ];
  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'jquery-core' ); //Load WP jQuery
    
    wp_enqueue_script( 'next_physics', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_physics.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);

    wp_enqueue_script( 'next_matterjs_library', NEXTBRICKS_PLUGIN_URL . 'local_assets/next_matterjs_library.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $elements = ! empty( $settings['elements'] ) ? $settings['elements'] : false;
    $builderedit = ! empty( $settings['builderedit'] ) ? $settings['builderedit'] : 0;

    /*Settings*/
    $gravityHorizontal = ! empty( $settings['gravityHorizontal'] ) ? $settings['gravityHorizontal'] : 0;
    $gravityVertical = ! empty( $settings['gravityVertical'] ) ? $settings['gravityVertical'] : 1;
    $timeScale = ! empty( $settings['timeScale'] ) ? $settings['timeScale'] : 1;
    $wireframes = ! empty( $settings['wireframes'] ) ? $settings['wireframes'] : false;
    $stiffness = ! empty( $settings['stiffness'] ) ? $settings['stiffness'] : '0.2';

    /*Walls*/
    $enableTopWall = ! empty( $settings['enableTopWall'] ) ? $settings['enableTopWall'] : false;
    $enableBottomWall = ! empty( $settings['enableBottomWall'] ) ? $settings['enableBottomWall'] : false;
    $enableLeftWall = ! empty( $settings['enableLeftWall'] ) ? $settings['enableLeftWall'] : false;
    $enableRightWall = ! empty( $settings['enableRightWall'] ) ? $settings['enableRightWall'] : false;
    $wallVisible = ! empty( $settings['wallVisible'] ) ? $settings['wallVisible'] : false;
    $wallWidth = ! empty( $settings['wallWidth'] ) ? $settings['wallWidth'] : 10;

    /*scrollTrigger*/
    $trigger = ! empty( $settings['trigger'] ) ? $settings['trigger'] : 'this';
    $start = ! empty( $settings['start'] ) ? $settings['start'] : 'top bottom';

    /*Settings*/
    /*Walls*/
    /*scrollTrigger*/

    $this->set_attribute( '_root', 'class', "next-physics");
    $output = "<{$this->tag} {$this->render_attributes( '_root' )}
        data-disable-builder='{$builderedit}'
        data-gravity-horizontal='{$gravityHorizontal}'
        data-gravity-vertical='{$gravityVertical}'
        data-time-scale='{$timeScale}'
        data-wireframes='{$wireframes}'
        data-stiffness='{$stiffness}'
        data-enable-top-wall='{$enableTopWall}'
        data-enable-bottom-wall='{$enableBottomWall}'
        data-enable-left-wall='{$enableLeftWall}'
        data-enable-right-wall='{$enableRightWall}'
        data-wall-visible='{$wallVisible}'
        data-wall-width='{$wallWidth}'
        data-trigger='{$trigger}'
        data-start='{$start}'
    >";
    $output .= Frontend::render_children( $this );
    if ($elements) {
        $output .= '<div class="next-elements-list" data-horizontal="';
        foreach ( $elements as $element ) {
            if ( isset($element['horizontal'])) {
                $output .= $element['horizontal'] . 'd4511782';
            }
            else{
                $output .= '100' . 'd4511782';
            }
        }
        $output .= '" data-vertical="';
        foreach ( $elements as $element ) {
            if ( isset($element['vertical'])) {
                $output .= $element['vertical'] . 'd4511782';
            }
            else{
                $output .= '100' . 'd4511782';
            }
        }
        $output .= '" data-shape="';
        foreach ( $elements as $element ) {
            if ( isset($element['shape'])) {
                $output .= $element['shape'] . 'd4511782';
            }
            else{
                $output .= 'rectangle' . 'd4511782';
            }
        }
        $output .= '" data-width="';
        foreach ( $elements as $element ) {
            if ( isset($element['width'])) {
                $output .= $element['width'] . 'd4511782';
            }
            else{
                $output .= '100' . 'd4511782';
            }
        }
        $output .= '" data-height="';
        foreach ( $elements as $element ) {
            if ( isset($element['height'])) {
                $output .= $element['height'] . 'd4511782';
            }
            else{
                $output .= '50' . 'd4511782';
            }
        }
        $output .= '" data-radius-circle="';
        foreach ( $elements as $element ) {
            if ( isset($element['radiusCircle'])) {
                $output .= $element['radiusCircle'] . 'd4511782';
            }
            else{
                $output .= '100' . 'd4511782';
            }
        }
        $output .= '" data-radius-polygon="';
        foreach ( $elements as $element ) {
            if ( isset($element['radiusPolygon'])) {
                $output .= $element['radiusPolygon'] . 'd4511782';
            }
            else{
                $output .= '100' . 'd4511782';
            }
        }
        $output .= '" data-sides="';
        foreach ( $elements as $element ) {
            if ( isset($element['sides'])) {
                $output .= $element['sides'] . 'd4511782';
            }
            else{
                $output .= '5' . 'd4511782';
            }
        }
        $output .= '" data-border-radius="';
        foreach ( $elements as $element ) {
            if ( isset($element['borderradius'])) {
                $output .= $element['borderradius'] . 'd4511782';
            }
            else{
                $output .= '10' . 'd4511782';
            }
        }
        $output .= '" data-image-url="';
        foreach ( $elements as $element ) {
            if ( !isset($element['useimage'])) {
                $output .= 'unset' . 'd4511782';
            }else if ( isset($element['image']['mediaData']['url'])) {
                $output .= $element['image']['mediaData']['url'] . 'd4511782';
            }else if ( isset($element['image']['url'])) {
                $output .= $element['image']['url'] . 'd4511782';
            }else{
                $output .= 'unset' . 'd4511782';
            }
        }
        $output .= '" data-image-scale="';
        foreach ( $elements as $element ) {
            if ( isset($element['imagescale'])) {
                $output .= $element['imagescale'] . 'd4511782';
            }else{
                $output .= '1' . 'd4511782';
            }
        }
        $output .= '" data-fill="';
        foreach ( $elements as $element ) {
            if ( isset($element['fill']['rgb'])) {
                $output .= $element['fill']['rgb'] . 'd4511782';
            }else if ( isset($element['fill']['raw'])) {
                $output .= $element['fill']['raw'] . 'd4511782';
            }else if ( isset($element['fill']['hex'])) {
                $output .= $element['fill']['hex'] . 'd4511782';
            }else{
                $output .= 'lightblue' . 'd4511782';
            }
        }
        $output .= '" data-stroke-color="';
        foreach ( $elements as $element ) {
            if ( isset($element['strokecolor']['rgb'])) {
                $output .= $element['strokecolor']['rgb'] . 'd4511782';
            }else if ( isset($element['strokecolor']['raw'])) {
                $output .= $element['strokecolor']['raw'] . 'd4511782';
            }else if ( isset($element['strokecolor']['hex'])) {
                $output .= $element['strokecolor']['hex'] . 'd4511782';
            }else{
                $output .= 'green' . 'd4511782';
            }
        }
        $output .= '" data-stroke-width="';
        foreach ( $elements as $element ) {
            if ( isset($element['strokewidth'])) {
                $output .= $element['strokewidth'] . 'd4511782';
            }
            else{
                $output .= '0' . 'd4511782';
            }
        }
        $output .= '" data-links="';
        foreach ( $elements as $element ) {
            if ( isset($element['link'])) {
                $output .= $element['link'] . 'd4511782';
            }
            else {
                $output .= 'unset' . 'd4511782';
            }
        }
        $output .= '" data-links-tabs="';
        foreach ( $elements as $element ) {
            if ( isset($element['link_target']) && $element['link_target'] != '') {
                $output .= $element['link_target'] . 'd4511782';
            }
            else{
                $output .= '0' . 'd4511782';
            }
        }
        $output .= '" data-static="';
        foreach ( $elements as $element ) {
            if ( isset($element['static']) && $element['static'] != '') {
                $output .= $element['static'] . 'd4511782';
            }
            else{
                $output .= '0' . 'd4511782';
            }
        }
        $output .= '" data-restitution="';
        foreach ( $elements as $element ) {
            if ( isset($element['restitution'])) {
                $output .= $element['restitution'] . 'd4511782';
            }
            else{
                $output .= '0.3' . 'd4511782';
            }
        }
        $output .= '" data-friction="';
        foreach ( $elements as $element ) {
            if ( isset($element['friction'])) {
                $output .= $element['friction'] . 'd4511782';
            }
            else{
                $output .= '0.1' . 'd4511782';
            }
        }
        $output .= '" data-friction-air="';
        foreach ( $elements as $element ) {
            if ( isset($element['frictionAir'])) {
                $output .= $element['frictionAir'] . 'd4511782';
            }
            else{
                $output .= '0.01' . 'd4511782';
            }
        }
        $output .= '" data-density="';
        foreach ( $elements as $element ) {
            if ( isset($element['density'])) {
                $output .= $element['density'] . 'd4511782';
            }
            else{
                $output .= '0.001' . 'd4511782';
            }
        }
        $output .= '"></div>';
    }

    $output .= "</{$this->tag}>";

	echo $output;
  }
}