<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Pixels_Button extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'next-pixels-button';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';

  public function get_label() {
    return esc_html__( 'Pixels Button', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Pixels Button', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['iconsSeparator'] = [
        'label'      => esc_html__( 'Icons', 'bricks' ),
        'type'       => 'separator',
      ];
      $this->controls['includeLeftIcon'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Left Icon', 'bricks' ),
        'type' => 'checkbox',
        'default' => false,
      ];
      $this->controls['leftIcon'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Icon', 'bricks' ),
        'type' => 'icon',
        'css' => [
          [
            'selector' => '&{pseudo} .nb-pixels-button__left-icon',
          ],
        ],
        'required'   => [ 'includeLeftIcon', '=', true ],
      ];
      $this->controls['leftIconMargin'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Margin', 'bricks' ),
        'type'  => 'spacing',
        'css'   => [
          [
            'property' => 'margin',
            'selector' => '&{pseudo} .nb-pixels-button__left-icon',
          ],
        ],
        'required' => [ 'includeLeftIcon', '=', true ],
      ];
      $this->controls['leftIconSize'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Size', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'css'   => [
          [
            'property' => 'font-size',
            'selector' => '&{pseudo} .nb-pixels-button__left-icon',
          ],
        ],
        'required' => [ 'includeLeftIcon', '=', true ],
      ];
      $this->controls['leftIconColor'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Color', 'bricks' ),
        'type'  => 'color',
        'css'   => [
          [
            'property' => 'color',
            'selector' => '&{pseudo} .nb-pixels-button__left-icon',
          ],
        ],
        'required' => [ 'includeLeftIcon', '=', true ],
      ];
      $this->controls['includeRightIcon'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Right Icon', 'bricks' ),
        'type' => 'checkbox',
        'default' => false,
      ];
      $this->controls['rightIcon'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Icon', 'bricks' ),
        'type' => 'icon',
        'css' => [
          [
            'selector' => '&{pseudo} .nb-pixels-button__right-icon',
          ],
        ],
        'required'   => [ 'includeRightIcon', '=', true ],
      ];
      $this->controls['rightIconMargin'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Margin', 'bricks' ),
        'type'  => 'spacing',
        'css'   => [
          [
            'property' => 'margin',
            'selector' => '&{pseudo} .nb-pixels-button__right-icon',
          ],
        ],
        'required' => [ 'includeRightIcon', '=', true ],
      ];
      $this->controls['rightIconSize'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Size', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'css'   => [
          [
            'property' => 'font-size',
            'selector' => '&{pseudo} .nb-pixels-button__right-icon',
          ],
        ],
        'required' => [ 'includeRightIcon', '=', true ],
      ];
      $this->controls['rightIconColor'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Color', 'bricks' ),
        'type'  => 'color',
        'css'   => [
          [
            'property' => 'color',
            'selector' => '&{pseudo} .nb-pixels-button__right-icon',
          ],
        ],
        'required' => [ 'includeRightIcon', '=', true ],
      ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['padding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => '--padding',
                'selector' => '',
            ],
        ],
        'default' => [
            'top'    => 10,
            'right'  => 15, 
            'bottom' => 10,
            'left'   => 15,
        ],
    ];
    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'font-weight' => '500',
            'color' => [
                'hex' => '#ffffff',
              ]
        ],
    ];
    $this->controls['background'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&{pseudo} .nb-pixels-button__background',
            ],
        ],
        'default' => [
            'hex' => '#368bf9',
        ],
    ];
    $this->controls['border'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Border', 'bricks'),
        'type'    => 'border',
        'css'     => [
          [
            'property' => 'border',
            'selector' => '&{pseudo} .nb-pixels-button__background',
          ],
        ],
        'default' => [
            'radius' => [
                'top' => 8,
                'right' => 8,
                'bottom' => 8,
                'left' => 8,
            ],
        ]
    ];

    $this->controls['pixelsSeparator'] = [
        'label'      => esc_html__( 'Pixels', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['pixelsCells'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Cells', 'bricks' ),
        'type'    => 'number',
        'css'     => [
            [
                'property' => '--pixels-cells',
                'selector' => '&{pseudo} .nb-pixels-button__background',
            ],
        ],
        'default' => 9,
    ];
    $this->controls['pixelsColor'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background-color',
                'selector' => '&{pseudo} .nb-pixels-button__pixel',
            ],
        ],
        'default' => [
            'hex' => '#ffffff46',
        ],
    ];
    $this->controls['pixelsDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Duration', 'bricks' ),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
            [
                'property' => '--pixels-duration',
                'selector' => '',
            ],
        ],
        'default' => '0.6s',
    ];
    $this->controls['pixelsEase'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'CSS Easing', 'bricks' ),
        'type'    => 'text',
        'css'     => [
            [
                'property' => '--pixels-ease',
                'selector' => '',
            ],
        ],
        'default' => 'cubic-bezier(0.215, 0.61, 0.355, 1)',
    ];
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Pixels Button';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $includeLeftIcon = ! empty( $settings['includeLeftIcon'] ) ? $settings['includeLeftIcon'] : 0;
    $includeRightIcon = ! empty( $settings['includeRightIcon'] ) ? $settings['includeRightIcon'] : 0;
    if ( $includeLeftIcon !== 0 ) {
      $leftIcon = self::render_icon( $settings['leftIcon'], [ 'nb-pixels-button__left-icon' ] );
    }else{
      $leftIcon = '';
    }
    if ( $includeRightIcon !== 0 ) {
      $rightIcon = self::render_icon( $settings['rightIcon'], [ 'nb-pixels-button__right-icon' ] );
    }else{
      $rightIcon = '';
    }

    $this->set_attribute( '_root', 'class', 'nb-pixels-button' );

    $output = "
    <$root_tag  {$this->render_attributes( '_root' )}>
        <span class='nb-pixels-button__container'>
            <span class='nb-pixels-button__text'>$leftIcon$inner_title$rightIcon</span>
        </span>
        <span class='nb-pixels-button__background'>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
            <span class='nb-pixels-button__pixel'></span>
        </span>
    </$root_tag>
    ";

	echo $output;
  }
}