<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Pixels_Shimmer_Card extends \Bricks\Element {
    public $category     = 'Next Bricks - Cores';
    public $name         = 'next-pixels-shimmer-card';
    public $icon         = 'ti-layout-width-default-alt';
    public $scripts      = ['next_pixels_shimmer_card'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Pixels Shimmer Card', 'bricks' );
    }

    public function set_controls() {
        $this->controls['styleSeparator'] = [
            'label'      => esc_html__( 'Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['width'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Width', 'bricks' ),
            'type'    => 'number',
            'units'    =>  true,
            'css'     => [
                [
                    'property' => 'width',
                    'selector' => '',
                ],
            ],
            'default' => 300,
        ];
        $this->controls['height'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Height', 'bricks' ),
            'type'    => 'number',
            'units'    =>  true,
            'css'     => [
                [
                    'property' => 'height',
                    'selector' => '',
                ],
            ],
            'default' => 300,
        ];
        $this->controls['padding'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Padding', 'bricks' ),
            'type'    => 'spacing',
            'css'     => [
                [
                    'property' => 'padding',
                    'selector' => '',
                ],
            ],
          ];
        $this->controls['background'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Background', 'bricks' ),
            'type'    => 'color',
            'css'     => [
                [
                    'property' => 'background',
                    'selector' => '',
                ],
            ],
            'default' => [
                'hex' => '#888888',
            ],
        ];
        $this->controls['border'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Border', 'bricks' ),
            'type'    => 'border',
            'units'   => true,
            'css'     => [
                [
                    'property' => 'border',
                    'selector' => '',
                ],
            ],
            'default' => [
                'style' => 'solid',
                'width' => [
                    'top' => 1,
                    'right' => 1,
                    'bottom' => 1,
                    'left' => 1,
                ],
                'color' => [
                    'rgb' => 'rgba(0, 0, 0, 0.1)',
                ],
                'radius' => [
                  'top' => 8,
                  'right' => 8,
                  'bottom' => 8,
                  'left' => 8,
                ],
            ],
        ];

        $this->controls['pixelsAnimationSeparator'] = [
            'label'      => esc_html__( 'Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['speed'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Speed', 'bricks' ),
            'type'        => 'number',
            'default'     => 20,
        ];
        $this->controls['gap'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Pixels Gap', 'bricks' ),
            'type'        => 'number',
            'default'     => 3,
        ];
        $this->controls['pixelColors'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Pixels Colors', 'bricks' ),
            'type'        => 'repeater',
            'titleProperty' => 'title',
            'fields'      => [
                'color'   => [
                    'label' => esc_html__( 'Color', 'bricks' ),
                    'type'  => 'color',
                ],
            ],
            'default'     => [
                ['color' => ['hex' => '#fef08a']],
                ['color' => ['hex' => '#fde047']],
                ['color' => ['hex' => '#eab308']], 
            ],
        ];

        $this->controls['borderAnimationSeparator'] = [
            'label'      => esc_html__( 'Border Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['activeColor'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Active border Color', 'bricks' ),
            'type'        => 'color',
            'css'         => [
                [
                    'property' => '--active-color',
                    'selector' => '',
                ],
            ],
            'default'     => [
                'hex' => '#fef08a',
            ],
        ];
        $this->controls['duration'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Duration', 'bricks' ),
            'type'        => 'number',
            'unit'        => 's',
            'css'         => [
                [
                    'property' => '--border-duration',
                    'selector' => '',
                ],
            ],
            'default'     => '0.8s',
        ];
        $this->controls['ease'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'CSS Easing', 'bricks' ),
            'type'        => 'text',
            'css'         => [
                [
                    'property' => '--border-ease',
                    'selector' => '',
                ],
            ],
            'default'     => 'cubic-bezier(0.45,0,0.55,1)',
        ];
    }

    /*Render children*/
    public function get_nestable_children() {
        return [
            [
                'name'     => 'heading',
                'label'    => esc_html__( 'Title', 'bricks' ),
                'settings' => [
                    'text' => esc_html__( 'Pixels', 'bricks' ),
                    'tag'  => 'h3',
                ],
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next-pixels-shimmer-card', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_pixels_shimmer_card.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $speed    = ! empty( $settings['speed'] ) ? $settings['speed'] : 20;
        $gap      = ! empty( $settings['gap'] ) ? $settings['gap'] : 3;
        $activeColor = ! empty( $settings['activeColor'] ) ? $settings['activeColor'] : '#fef08a';
        $pixelColors = ! empty( $settings['pixelColors'] ) ? $settings['pixelColors'] : [
            ['color' => ['hex' => '#fef08a']],
            ['color' => ['hex' => '#fde047']],
            ['color' => ['hex' => '#eab308']], 
        ];

        // Convert pixel colors array to comma-separated string
        $colorString = array_map(function($item) {
            return $item['color']['hex'];
        }, $pixelColors);
        $colorString = implode(', ', $colorString);

        $this->set_attribute( '_root', 'class', 'nb-pixels-shimmer-card' );
        $this->set_attribute( '_root', 'data-flickering', '1' );
        $this->set_attribute( '_inner', 'data-speed', $speed );
        $this->set_attribute( '_inner', 'data-gap', $gap );
        $this->set_attribute( '_inner', 'data-active-color', $activeColor );
        $this->set_attribute( '_inner', 'data-colors', $colorString );

        $output = "<div {$this->render_attributes( '_root' )}>";
        $output .= "<pixel-canvas {$this->render_attributes( '_inner' )}></pixel-canvas>";
        $output .= Frontend::render_children( $this );
        $output .= "</div>";

        echo $output;
    }
}