<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Progress_Bar extends \Bricks\Element {
    public $category     = 'Next Bricks - Cores';
    public $name         = 'next_progress_bar';
    public $icon         = 'fas fa-grip-lines-vertical';
    public $scripts      = ['next_progress_bar'];

    public function get_label() {
        return esc_html__( 'Progress Bar', 'bricks' );
    }

    public function set_controls() {
        $this->controls['width'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => 'width',
                    'selector' => '',
                ],
            ],
            'placeholder' => '1px',
        ];
        $this->controls['height'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => 'height',
                    'selector' => '',
                ],
            ],
            'placeholder' => '100px',
        ];

        /*Position*/
        $this->controls['POSITION'] = [
            'label'      => esc_html__( 'Position', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['zIndex'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'z-index', 'bricks' ),
            'type'  => 'text',
            'inline' => true,
            'small' => true,
            'css'   => [
                [
                    'property' => 'z-index',
                    'selector' => '',
                ],
            ],
            'placeholder' => '9999',
        ];
        $this->controls['top'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Top', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => 'top',
                    'selector' => '',
                ],
            ],
        ];
        $this->controls['left'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Left', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => 'left',
                    'selector' => '',
                ],
            ],
        ];
        $this->controls['bottom'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Bottom', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => 'bottom',
                    'selector' => '',
                ],
            ],
            'placeholder' => '50px',
        ];
        $this->controls['right'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Right', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => 'right',
                    'selector' => '',
                ],
            ],
            'placeholder' => '75px',
        ];

        /*Progress*/
        $this->controls['PROGRESS'] = [
            'label'      => esc_html__( 'Progress', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['pathColor'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Path color', 'bricks' ),
            'type'  => 'color',
            'css'   => [
                [
                    'property' => 'background',
                    'selector' => '',
                ],
            ],
            'default' => [
                'hex' => '#0080ff3f',
            ],
        ];
        $this->controls['fillColor'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Fill color', 'bricks' ),
            'type'  => 'color',
            'css'   => [
                [
                    'property' => 'background',
                    'selector' => '.next-progress-bar__inner',
                ],
            ],
            'default' => [
                'hex' => '#007fff',
            ],
        ];

        /*Number*/
        $this->controls['NUMBER'] = [
            'label'      => esc_html__( 'Number', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['NUMBERtypography'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Typography', 'bricks' ),
            'type'    => 'typography',
            'css'     => [
                [
                    'property' => 'typography',
                    'selector' => '.next-progress-bar__number',
                ],
            ],
        ];
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Number position is relative to the progress bar.', 'bricks' )))
        ];
        $this->controls['NUMBERtop'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Top', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => '--top',
                    'selector' => '.next-progress-bar__number',
                ],
            ],
            'placeholder' => '-15px',
        ];
        $this->controls['NUMBERleft'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Left', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'css'   => [
                [
                    'property' => 'left',
                    'selector' => '.next-progress-bar__number',
                ],
            ],
            'placeholder' => '10px',
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_progress_bar', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_progress_bar.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;

        $this->set_attribute( '_root', 'class', "next-progress-bar");

        $output =
        "
        <div {$this->render_attributes( '_root' )}>
            <div class='next-progress-bar__inner'></div>
            <div class='next-progress-bar__number'>0%</div>
        </div>
        ";

        echo $output;
    }
}