<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_QR_Code extends \Bricks\Element {
    public $category     = 'Next Bricks - Cores';
    public $name         = 'next_qr_code';
    public $icon         = 'fas fa-qrcode';
    public $scripts      = ['next_qr_code'];

    public function get_label() {
        return esc_html__( 'QR Code', 'bricks' );
    }

    public function set_controls() {
        $this->controls['content'] = [
            'tab' => 'content',
            'label' => esc_html__( 'QR Content', 'bricks' ),
            'type' => 'text',
            'default' => 'https://nextbricks.io',
            'rerender' => true,
        ];
        $this->controls['enableIcon'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Enable Icon', 'bricks' ),
            'type'     => 'checkbox',
            'default' => true,
        ];
        $this->controls['icon'] = [
            'hasDynamicData' => true,
            'tab' => 'content',
            'label' => esc_html__( 'Icon', 'bricks' ),
            'type' => 'image',
            'required' => [ 'enableIcon', '=', true],
        ];

        //Block Style
        $this->controls['blockStyleSeparator'] = [
            'label'      => esc_html__( 'Block Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['width'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'width',
                'selector' => '',
              ]
            ],
            'placeholder' => '300px',
            'rerender' => true,
        ];
        $this->controls['height'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'height',
                'selector' => '',
              ]
            ],
            'placeholder' => '300px',
            'rerender' => true,
        ];
        $this->controls['background'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type'  => 'background',
            'inline' => true,
            'css' => [
              [
                'property' => 'background',
                'selector' => '',
              ]
            ],
            'default' => [
                'color' => [
                    'hex' => '#fff',
                ],
            ],
            'rerender' => true,
        ];
        $this->controls['border'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type' => 'border',
            'inline' => true,
            'css' => [
              [
                'property' => 'border',
                'selector' => '',
              ]
            ],
            'rerender' => true,
        ];
        $this->controls['boxShadow'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Box Shadow', 'bricks' ),
            'type' => 'box-shadow',
            'inline' => true,
            'css' => [
              [
                'property' => 'box-shadow',
                'selector' => '',
              ]
            ],
            'rerender' => true,
        ];

        //QR Style
        $this->controls['qrStyleSeparator'] = [
            'label'      => esc_html__( 'QR Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Builder may need to be reloaded after applying a new color to see the changes.', 'bricks' )))
        ];
        $this->controls['module_color'] = [
            'tab' => 'content',
            'label' => esc_html__( 'QR Color', 'bricks' ),
            'type' => 'color',
            'default' => [
                'hex' => '#0096FE',
            ],
            'rerender' => true,
        ];
        $this->controls['position_center_color'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Squares Color', 'bricks' ),
            'type' => 'color',
            'default' => [
                'hex' => '#9D2DF6',
            ],
            'reloadScripts' => true,
        ];
        $this->controls['position_ring_color'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Squares Border Color', 'bricks' ),
            'type' => 'color',
            'default' => [
                'hex' => '#000000',
            ],
            'rerender' => true,
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script('qr-code-library', 'https://unpkg.com/@bitjson/qr-code@1.0.2/dist/qr-code.js', array(), '1.0.2', true);
        wp_enqueue_script('next_qr_code', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_qr_code.min.js', array('bricks-scripts', 'qr-code-library'), NEXTBRICKS_VERSION, true);
    }

    public function render() {
        $settings = $this->settings;
        $content    = ! empty( $settings['content'] ) ? $settings['content'] : 'https://nextbricks.io';
        $enableIcon    = ! empty( $settings['enableIcon'] ) ? $settings['enableIcon'] : 0;

        $module_color    = ! empty( $settings['module_color'] ) ? $settings['module_color'] : '#0096FE';
        if (isset($module_color['rgb'])) {
            $module_color = $module_color['rgb'];
        } else if(isset($module_color['raw'])){
            $module_color = $module_color['raw'];
        }else if(isset($module_color['hex'])){
            $module_color = $module_color['hex'];
        }
        $position_ring_color    = ! empty( $settings['position_ring_color'] ) ? $settings['position_ring_color'] : '#000000';
        if (isset($position_ring_color['rgb'])) {
            $position_ring_color = $position_ring_color['rgb'];
        } else if(isset($position_ring_color['raw'])){
            $position_ring_color = $position_ring_color['raw'];
        }else if(isset($position_ring_color['hex'])){
            $position_ring_color = $position_ring_color['hex'];
        }
        $position_center_color    = ! empty( $settings['position_center_color'] ) ? $settings['position_center_color'] : '#9D2DF6';
        if (isset($position_center_color['rgb'])) {
            $position_center_color = $position_center_color['rgb'];
        } else if(isset($position_center_color['raw'])){
            $position_center_color = $position_center_color['raw'];
        }else if(isset($position_center_color['hex'])){
            $position_center_color = $position_center_color['hex'];
        }

        //Render dynamic data
        if (isset($settings['icon']['useDynamicData'])){
            $source = $this->render_dynamic_data_tag($settings['icon']['useDynamicData'], 'image');
            $source = wp_get_attachment_url($source[0]);
        }
        //Render normal image
        else if (isset($settings['icon'])) {
            $source = $settings['icon']['url'];
        }
        //Render default
        else{
            $source = 'https://nextbricks.io/wp-content/uploads/2024/07/logo-next-bricks.png';
        }
        
        $this->set_attribute( '_root', 'class', "next-qr-code");
        $this->set_attribute( '_root', 'data-flickering', '');
        $this->set_attribute( '_root', 'contents', $content);
        $this->set_attribute( '_root', 'module-color', $module_color);
        $this->set_attribute( '_root', 'position-ring-color', $position_ring_color);
        $this->set_attribute( '_root', 'position-center-color', $position_center_color);
        
        $output = "<qr-code {$this->render_attributes( '_root' )}>";
        if($enableIcon == '1'){
            $output .= "<img src='{$source}' slot='icon'/>";
        }
        $output .= '</qr-code>';

        echo $output;
    }
}