<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Read_More extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'next_read_more';
  public $icon         = 'fas fa-align-left';
  public $tag      = 'div';
  public $scripts      = ['next_read_more'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Read More', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
        'div' => 'div',
        'section' => 'section',
        'article' => 'article',
        'aside' => 'aside',
        'header' => 'header',
        'footer' => 'footer',
        'main' => 'main',
        'nav' => 'nav',
        'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['note'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'The elements to be included inside the Show more/less have to be placed inside the Content element. Anything else like the Read more button should be placed outside.', 'bricks' )))
    ];

    /*css*/
    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Block Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['width'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'width',
            'selector' => '',
          ]
        ],
        'default' => '100%',
    ];
    $this->controls['maxWidth'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Max Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'max-width',
            'selector' => '',
          ]
        ],
        'default' => '500px',
    ];
    $this->controls['height'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'height',
            'selector' => '',
          ]
        ],
        'default' => 'auto',
    ];
    $this->controls['background'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Background', 'bricks' ),
        'type'  => 'color',
        'inline' => true,
        'css' => [
          [
            'property' => 'background',
            'selector' => '',
          ]
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];

    /*content container*/
    $this->controls['contentContainer'] = [
        'label'      => esc_html__( 'Content element', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['note2'] = [
        'tab' => 'content',
        'description' => sprintf(html_entity_decode(esc_html__( 'Content element will cut and fade all the elements inside.', 'bricks' )))
    ];
    $this->controls['marginContainer'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Margin', 'bricks' ),
        'type'  => 'spacing',
        'units' => true,
        'css' => [
          [
            'property' => 'margin',
            'selector' => '.nb-read-more__container',
          ]
        ],
        'default' => [
            'top'    => 0,
            'right'  => 0, 
            'bottom' => 12,
            'left'   => 0,
        ],
    ];
    $this->controls['defaultHeight'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Default height to show', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'height',
            'selector' => '.nb-read-more__container',
          ]
        ],
        'default' => '100px',
    ];
    $this->controls['blurHeight'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Fade height', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'height',
            'selector' => '.nb-read-more__container::before',
          ]
        ],
        'default' => '30px',
    ];
    $this->controls['blurColor'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Fade color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--blur-color',
                'selector' => '.nb-read-more__container',
            ],
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];

    /*read more button*/
    $this->controls['readMoreButton'] = [
        'label'      => esc_html__( 'Read More Button', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['note3'] = [
        'tab' => 'content',
        'description' => sprintf(html_entity_decode(esc_html__( 'Read More text can be set in the Read More Button element.', 'bricks' )))
    ];
    $this->controls['readLessText'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Read less text', 'bricks' ),
        'type'    => 'text',
        'default' => esc_html__( 'Show less', 'bricks' ),
    ];
    $this->controls['readMoreTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '.nb-read-more__btn',
            ],
        ],
        'default' => [
            'font-size' => '13px',
            'text-align' => 'left',
            'color' => [
                'hex' => '#1087f0',
            ],
        ],
    ];
    $this->controls['hoverColor'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Hover color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--show-more-color-hover',
                'selector' => '.nb-read-more__btn',
            ],
        ],
        'default' => [
            'hex' => '#000000',
        ],
    ];
    $this->controls['colorTransitionDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Hover color duration', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'inline'  => true,
        'css'     => [
            [
                'property' => '--show-more-color-duration',
                'selector' => '.nb-read-more__btn',
            ],
        ],
        'default' => '0.3s',
    ];
    $this->controls['colorTransitionEase'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Hover color CSS easing', 'bricks' ),
        'type'    => 'text',
        'inline'  => true,
        'css'     => [
            [
                'property' => '--show-more-color-ease',
                'selector' => '.nb-read-more__btn',
            ],
        ],
        'default' => 'ease-in-out',
    ];
    
    /*js settings*/
    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Read More Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['inDuration'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'In Duration', 'bricks' ),
        'type'  => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '0.5s',
    ];
    $this->controls['outDuration'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Out Duration', 'bricks' ),
        'type'  => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '0.5s',
    ];
    $this->controls['inEase'] = [
        'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'In GSAP Easing', 'bricks' ),
          'type' => 'select',
          'options'     => [
            'none' => 'none',
            'power1' => 'power1',
            'power2' => 'power2',
            'power3' => 'power3',
            'power4' => 'power4',
            'back' => 'back',
            'bounce' => 'bounce',
            'circ' => 'circ',
            'elastic' => 'elastic',
            'expo' => 'expo',
            'sine' => 'sine',
            'steps' => 'steps'
          ],
          'inline' => true,
          'default' => 'back',
    ];
    $this->controls['outEase'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Out GSAP Easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
        'none' => 'none',
        'power1' => 'power1',
        'power2' => 'power2',
        'power3' => 'power3',
        'power4' => 'power4',
        'back' => 'back',
        'bounce' => 'bounce',
        'circ' => 'circ',
        'elastic' => 'elastic',
        'expo' => 'expo',
        'sine' => 'sine',
        'steps' => 'steps'
        ],
        'inline' => true,
        'default' => 'back',
    ];
  }

  public function get_nestable_children() {
    return [
        [
            'name'     => 'block',
            'label'    => esc_html__( 'Content', 'bricks' ),
            'settings' => [
                '_hidden'  => [
                    '_cssClasses' => 'nb-read-more__container',
                ],
            ],
            'children' => [
                [
                    'name'     => 'heading',
                    'label'    => esc_html__( 'Heading', 'bricks' ),
                    'settings' => [
                        'text' => esc_html__( 'Read more.', 'bricks' ),
                        'tag'  => 'h2',
                    ],
                ],
                [
                    'name'     => 'text-basic',
                    'label'    => esc_html__( 'Text', 'bricks' ),
                    'settings' => [
                        'text' => esc_html__( '
                        Lorem ipsum dolor sit amet, consectetur adipisicing elit.
                        Beatae consectetur dicta, eos libero non perspiciatis quia recusandae repellat tempore ullam unde vero!
                        Culpa debitis dolorem laudantium possimus reprehenderit temporibus voluptatem?', 'bricks' ),
                        'tag'  => 'p',
                    ],
                ],
            ],
        ],
        [
            'name'     => 'text-link',
            'label'    => esc_html__( 'Read More Button', 'bricks' ),
            'settings' => [
                'text' => esc_html__( 'Show more', 'bricks' ),
                'tag'  => 'a',
                '_hidden'  => [
                    '_cssClasses' => 'nb-read-more__btn',
                ],
            ],
        ],
    ];
}

  public function enqueue_scripts() {
    wp_enqueue_script( 'next_read_more', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_read_more.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $readLessText = !empty($settings['readLessText']) ? $settings['readLessText'] : 'Show less';
    $inDuration = !empty($settings['inDuration']) ? $settings['inDuration'] : '0.5';
    $outDuration = !empty($settings['outDuration']) ? $settings['outDuration'] : '0.5';
    $inEase = !empty($settings['inEase']) ? $settings['inEase'] : 'back';
    $outEase = !empty($settings['outEase']) ? $settings['outEase'] : 'back';
    
    $this->set_attribute( '_root', 'class', "nb-read-more");
    $this->set_attribute('_root', 'data-switch-title', $readLessText);
    $this->set_attribute('_root', 'data-in-duration', $inDuration);
    $this->set_attribute('_root', 'data-out-duration', $outDuration);
    $this->set_attribute('_root', 'data-in-ease', $inEase);
    $this->set_attribute('_root', 'data-out-ease', $outEase);

    $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
    $output .= Frontend::render_children( $this );
    $output .= "</{$this->tag}>";

	echo $output;
  }
}