<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Ripple_Button_v3 extends \Bricks\Element {
    public $category     = 'Next Bricks - Buttons';
    public $name         = 'ripple_button_v3';
    public $icon         = 'fa-solid fa-square-minus';
    public $tag      = 'div';
    public $scripts      = ['ripple_button_v3'];

    public function get_label() {
        return esc_html__( 'Ripple Button v3', 'bricks' );
    }

    public function set_controls() {
        $this->controls['tag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'HTML tag', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'div' => 'div',
                'span' => 'span',
                'button' => 'button',
                'custom' => 'custom',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'div',
            'default'     => 'div',
        ];
        $this->controls['customTag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Custom tag', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'placeholder' => 'div',
            'required'    => [ 'tag', '=', 'custom' ],
        ];
        $this->controls['link'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Link to', 'bricks' ),
            'type'  => 'link',
        ];
        $this->controls['type'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Ripple Type', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'fromTop' => 'from top',
                'fromBottom' => 'from bottom'
            ],
            'inline' => true,
            'placeholder' => 'from bottom',
        ];

        /*General style*/
        $this->controls['generalStyleSeparator'] = [
            'label'      => esc_html__( 'General style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['padding'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Padding', 'bricks' ),
            'type'        => 'spacing',
            'css'     => [
                [
                  'property' => 'padding',
                  'selector' => '&{pseudo} .next-ripple-button-v3__wrapper',
                ],
            ],
            'rerender' => true,
        ];
        $this->controls['typography'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Typography', 'bricks' ),
            'type'        => 'typography',
            'inline'      => true,
            'css'     => [
                [
                  'property' => 'typography',
                  'selector' => '&{pseudo} .next-ripple-button-v3__title--top',
                ],
                [
                    'property' => 'typography',
                    'selector' => '&{pseudo} .next-ripple-button-v3__title--bottom',
                ],
              ],
            'exclude' => [
              'color',
            ],
            'rerender' => true,
        ];
        $this->controls['border'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Border', 'bricks' ),
            'type'        => 'border',
            'inline'      => true,
            'css'     => [
                [
                  'property' => 'border',
                  'selector' => '',
                ],
            ],
            'exclude' => [
                'radius',
            ],
            'rerender' => true,
        ];
        $this->controls['borderRadius'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Border radius', 'bricks' ),
            'type'        => 'number',
            'units'      => true,
            'css'     => [
                [
                  'property' => '--border-radius',
                  'selector' => '',
                ],
            ],
            'placeholder' => '100px',
            'rerender' => true,
        ];

        /*Top Ripple*/
        $this->controls['topRippleSeparator'] = [
            'label'      => esc_html__( 'Top Ripple', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['topRippleInnerTitle'] = [
            'tab'            => 'content',
            'type'           => 'text',
            'hasDynamicData' => 'text',
            'default'        => esc_html__( 'Top Ripple', 'bricks' ),
            'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
        ];
        $this->controls['topRippleBackground'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Background', 'bricks' ),
            'type'        => 'background',
            'inline'      => true,
            'css'     => [
                [
                  'property' => 'background',
                  'selector' => '',
                ],
            ],
        ];
        $this->controls['topRippleColor'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Color', 'bricks' ),
            'type'        => 'color',
            'inline'      => true,
            'css'     => [
                [
                  'property' => 'color',
                  'selector' => '&{pseudo} .next-ripple-button-v3__title--top',
                ],
            ],
        ];

        /*Bottom Ripple*/
        $this->controls['bottomRippleSeparator'] = [
            'label'      => esc_html__( 'Bottom Ripple', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['bottomRippleInnerTitle'] = [
            'tab'            => 'content',
            'type'           => 'text',
            'hasDynamicData' => 'text',
            'default'        => esc_html__( 'Bottom Ripple', 'bricks' ),
            'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
        ];
        $this->controls['bottomRippleBackground'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Background', 'bricks' ),
            'type'        => 'background',
            'inline'      => true,
            'css'     => [
                [
                  'property' => 'background',
                  'selector' => '&{pseudo} .next-ripple-button-v3__mask',
                ],
            ],
        ];
        $this->controls['bottomRippleColor'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Color', 'bricks' ),
            'type'        => 'color',
            'inline'      => true,
            'css'     => [
                [
                  'property' => 'color',
                  'selector' => '&{pseudo} .next-ripple-button-v3__title--bottom',
                ],
            ],
        ];

        /*translate animation*/
        $this->controls['translateAnimationSeparator'] = [
            'label'      => esc_html__( 'Translate Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['translateAnimationDuration'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Duration', 'bricks' ),
            'type'        => 'number',
            'unit'        => 's',
            'inline'      => true,
            'css'     => [
                [
                    'property' => '--translate-animation-duration',
                    'selector' => '&{pseudo} .next-ripple-button-v3__wrapper',
                ],
            ],
            'placeholder' => '0.4s',
        ];
        $this->controls['translateAnimationDelay'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Delay', 'bricks' ),
            'type'        => 'number',
            'unit'        => 's',
            'inline'      => true,
            'css'     => [
                [
                    'property' => '--translate-animation-delay',
                    'selector' => '&{pseudo} .next-ripple-button-v3__wrapper',
                ],
            ],
            'placeholder' => '0s',
        ];
        $this->controls['translateAnimationEasing'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'CSS Easing', 'bricks' ),
            'type'        => 'text',
            'css'     => [
                [
                    'property' => '--translate-animation-easing',
                    'selector' => '&{pseudo} .next-ripple-button-v3__wrapper',
                ],
            ],
            'placeholder' => 'cubic-bezier(.33,1,.68,1)',
        ];

        /*Ripple animation*/
        $this->controls['rippleAnimationSeparator'] = [
            'label'      => esc_html__( 'Border Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['rippleAnimationDuration'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Duration', 'bricks' ),
            'type'        => 'number',
            'unit'        => 's',
            'inline'      => true,
            'css'     => [
                [
                    'property' => '--ripple-animation-duration',
                    'selector' => '&{pseudo} .next-ripple-button-v3__mask',
                ],
            ],
            'placeholder' => '0.4s',
        ];
        $this->controls['rippleAnimationDelay'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Delay', 'bricks' ),
            'type'        => 'number',
            'unit'        => 's',
            'inline'      => true,
            'css'     => [
                [
                    'property' => '--ripple-animation-delay',
                    'selector' => '&{pseudo} .next-ripple-button-v3__mask',
                ],
            ],
            'placeholder' => '0s',
        ];
        $this->controls['rippleAnimationEasing'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'CSS Easing', 'bricks' ),
            'type'        => 'text',
            'css'     => [
                [
                    'property' => '--ripple-animation-easing',
                    'selector' => '&{pseudo} .next-ripple-button-v3__mask',
                ],
            ],
            'placeholder' => 'cubic-bezier(.33,1,.68,1)',
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next-ripple-button-v3', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_ripple_button_v3.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $topRippleInnerTitle    = ! empty( $settings['topRippleInnerTitle'] ) ? $settings['topRippleInnerTitle'] : 'Top Ripple';
        $bottomRippleInnerTitle    = ! empty( $settings['bottomRippleInnerTitle'] ) ? $settings['bottomRippleInnerTitle'] : 'Bottom Ripple';

        if ( ! empty( $settings['link'] ) ) {
            $this->set_link_attributes( '_root', $settings['link'] );
            $root_tag = 'a';
        }else{
            $root_tag = $this->tag;
        }

        $this->set_attribute( '_root', 'class', 'next-ripple-button-v3' );
        $this->set_attribute( '_root', 'data-next-hide', '' );

        $type    = ! empty( $settings['type'] ) ? $settings['type'] : 'fromBottom';
        if ( $type == 'fromTop' ) {
            $this->set_attribute( '_root', 'data-from-top', '' );
        }

        $output = "
        <$root_tag {$this->render_attributes( '_root' )}>
            <div class='next-ripple-button-v3__wrapper'>
                <div class='next-ripple-button-v3__title--top'>$topRippleInnerTitle</div>
                <div class='next-ripple-button-v3__bottom'>
                    <span class='next-ripple-button-v3__title--bottom'>$bottomRippleInnerTitle</span>
                    <div class='next-ripple-button-v3__mask'></div>
                </div>
            </div>
        </$root_tag>
        ";

        echo $output;
    }
}