<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Shading_Lines_Title extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'next-shading-lines-title';
  public $icon         = 'ti-text';
  public $tag      = 'h3';

  public function get_label() {
    return esc_html__( 'Shading Lines Title', 'bricks' );
  }

  public function set_controls() {
    $this->controls['prefix'] = [
        'label'       => esc_html__( 'Prefix', 'bricks' ),
        'tab'            => 'content',
        'type'           => 'text',
        'inline'         => true,
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Next', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['title'] = [
        'label'       => esc_html__( 'Shading Title', 'bricks' ),
        'tab'            => 'content',
        'type'           => 'text',
        'inline'         => true,
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Bricks', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['suffix'] = [
        'label'       => esc_html__( 'Suffix', 'bricks' ),
        'tab'            => 'content',
        'type'           => 'text',
        'inline'         => true,
        'hasDynamicData' => 'text',
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];

    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'h1' => 'h1',
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
            'p' => 'p',
            'span' => 'span',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'h3',
        'default'     => 'h3',
    ];
    $this->controls['customTag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Custom tag', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'placeholder' => 'h3',
        'required'    => [ 'tag', '=', 'custom' ],
    ];

    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['Typography'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'General Typography', 'bricks' ),
      'type'  => 'typography',
      'css'   => [
        [
          'property' => 'typography',
          'selector' => '',
        ],
      ],
      'default' => [
        'font-size' => '92px',
      ],
    ];
    $this->controls['prefixTypography'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Prefix Typography', 'bricks' ),
        'type'  => 'typography',
        'css'   => [
          [
            'property' => 'typography',
            'selector' => '.next-shading-lines-title__prefix',
          ],
        ],
    ];
    $this->controls['shadingTitleTypography'] = [
        'tab'   => 'content', 
        'label' => esc_html__( 'Shading Title Typography', 'bricks' ),
        'type'  => 'typography',
        'css'   => [
            [
            'property' => 'typography',
            'selector' => '.next-shading-lines-title__lines',
            ],
        ],
        'default' => [
            'font-style' => 'italic',
        ],
    ];
    $this->controls['suffixTypography'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Suffix Typography', 'bricks' ),
        'type'  => 'typography', 
        'css'   => [
            [
            'property' => 'typography',
            'selector' => '.next-dynamic-copyright__suffix',
            ],
        ],
    ];

    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['shadingColor'] = [
        'tab'      => 'content',
        'label'    => esc_html__( 'Shading Color', 'bricks' ),
        'type'     => 'color',
        'css'      => [
            [
                'property' => '--shadow-color',
                'selector' => '',
            ],
        ],
        'default'  => [
            'hex' => '#000000',
        ],
    ];
    $this->controls['shadingDistance'] = [
        'tab'      => 'content',
        'label'    => esc_html__( 'Distance', 'bricks' ),
        'type'     => 'number',
        'units'     => true,
        'css'      => [
            [
                'property' => '--distance',
                'selector' => '',
            ],
        ],
        'default'  => '0.04em'
    ];
    $this->controls['shadingDegree'] = [
        'tab'      => 'content',
        'label'    => esc_html__( 'Degree', 'bricks' ),
        'type'     => 'number',
        'unit'     => 'deg',
        'css'      => [
            [
                'property' => '--degree',
                'selector' => '',
            ],
        ],
        'default'  => 45
    ];
    $this->controls['duration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Duration', 'bricks' ),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
            [
                'property' => '--duration',
                'selector' => '',
            ],
        ],
        'default' => 30,
    ];

    $this->controls['easing'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'CSS Easing', 'bricks' ),
        'type'        => 'text',
        'css'      => [
            [
                'property' => '--easing',
                'selector' => '',
            ],
        ],
        'default'     => 'linear',
    ];
  }

  public function render() {
    $settings = $this->settings;
    $prefix    = ! empty( $settings['prefix'] ) ? $settings['prefix'] : '';
    $title    = ! empty( $settings['title'] ) ? $settings['title'] : '';
    $suffix    = ! empty( $settings['suffix'] ) ? $settings['suffix'] : '';

    $this->set_attribute( '_root', 'class', 'next-shading-lines-title' );

    if ( ! empty( $settings['link'] ) ) {
        $this->set_link_attributes( '_link', $settings['link'] );
        $output ="
        <{$this->tag} {$this->render_attributes( '_root' )}>
            <a class='next-shading-lines-title__anchor' {$this->render_attributes( '_link' )}>
                <span class='next-shading-lines-title__prefix'>$prefix</span>
                <span class='next-shading-lines-title__lines' data-text='$title'>$title</span>
                <span class='next-shading-lines-title__suffix'>$suffix</span>
            </a>
        </{$this->tag}>
        ";
    }else{
        $output ="
        <{$this->tag} {$this->render_attributes( '_root' )}>
            <span class='next-shading-lines-title__prefix'>$prefix</span>
            <span class='next-shading-lines-title__lines' data-text='$title'>$title</span>
            <span class='next-shading-lines-title__suffix'>$suffix</span>
        </{$this->tag}>
        ";
    }

    echo $output;
  }
}

