<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Stripes_Button extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'next-stripes-button';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';

  public function get_label() {
    return esc_html__( 'Stripes Button', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Stripes Button', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['iconsSeparator'] = [
        'label'      => esc_html__( 'Icons', 'bricks' ),
        'type'       => 'separator',
      ];
      $this->controls['includeLeftIcon'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Left Icon', 'bricks' ),
        'type' => 'checkbox',
        'default' => false,
      ];
      $this->controls['leftIcon'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Icon', 'bricks' ),
        'type' => 'icon',
        'css' => [
          [
            'selector' => '&{pseudo} .nb-stripes-button__left-icon',
          ],
        ],
        'required'   => [ 'includeLeftIcon', '=', true ],
      ];
      $this->controls['leftIconMargin'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Margin', 'bricks' ),
        'type'  => 'spacing',
        'css'   => [
          [
            'property' => 'margin',
            'selector' => '&{pseudo} .nb-stripes-button__left-icon',
          ],
        ],
        'required' => [ 'includeLeftIcon', '=', true ],
      ];
      $this->controls['leftIconSize'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Size', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'css'   => [
          [
            'property' => 'font-size',
            'selector' => '&{pseudo} .nb-stripes-button__left-icon',
          ],
        ],
        'required' => [ 'includeLeftIcon', '=', true ],
      ];
      $this->controls['leftIconColor'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Color', 'bricks' ),
        'type'  => 'color',
        'css'   => [
          [
            'property' => 'color',
            'selector' => '&{pseudo} .nb-stripes-button__left-icon',
          ],
        ],
        'required' => [ 'includeLeftIcon', '=', true ],
      ];
      $this->controls['includeRightIcon'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Right Icon', 'bricks' ),
        'type' => 'checkbox',
        'default' => false,
      ];
      $this->controls['rightIcon'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Icon', 'bricks' ),
        'type' => 'icon',
        'css' => [
          [
            'selector' => '&{pseudo} .nb-stripes-button__right-icon',
          ],
        ],
        'required'   => [ 'includeRightIcon', '=', true ],
      ];
      $this->controls['rightIconMargin'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Margin', 'bricks' ),
        'type'  => 'spacing',
        'css'   => [
          [
            'property' => 'margin',
            'selector' => '&{pseudo} .nb-stripes-button__right-icon',
          ],
        ],
        'required' => [ 'includeRightIcon', '=', true ],
      ];
      $this->controls['rightIconSize'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Size', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'css'   => [
          [
            'property' => 'font-size',
            'selector' => '&{pseudo} .nb-stripes-button__right-icon',
          ],
        ],
        'required' => [ 'includeRightIcon', '=', true ],
      ];
      $this->controls['rightIconColor'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Color', 'bricks' ),
        'type'  => 'color',
        'css'   => [
          [
            'property' => 'color',
            'selector' => '&{pseudo} .nb-stripes-button__right-icon',
          ],
        ],
        'required' => [ 'includeRightIcon', '=', true ],
      ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['padding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => '--padding',
                'selector' => '',
            ],
        ],
        'default' => [
            'top'    => 15,
            'right'  => 15, 
            'bottom' => 15,
            'left'   => 15,
        ],
    ];
    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'font-weight' => '400',
            'color' => [
                'hex' => '#ffffff',
              ]
        ],
    ];
    $this->controls['background'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--background-color',
                'selector' => '',
            ],
        ],
        'default' => [
            'hex' => '#189df0',
        ],
    ];
    $this->controls['border'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Border', 'bricks'),
        'type'    => 'border',
        'css'     => [
          [
            'property' => 'border',
            'selector' => '&{pseudo} .nb-stripes-button__background',
          ],
        ],
        'default' => [
            'radius' => [
                'top' => 8,
                'right' => 8,
                'bottom' => 8,
                'left' => 8,
            ],
        ]
    ];
    $this->controls['stripesBlendFirstColor'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Stripes Blend Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--stripes-blend-first-color',
                'selector' => '',
            ],
        ],
        'default' => [
            'hex' => '#0080f0',
        ],
    ];

    $this->controls['stripesAnimationSeparator'] = [
        'label'      => esc_html__( 'Stripes Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['stripesFrom'] = [
        'tab'     => 'content',
        'label'   => esc_html__('From', 'bricks'),
        'type'    => 'select',
        'options' => [
            'top'    => esc_html__('Top', 'bricks'),
            'bottom' => esc_html__('Bottom', 'bricks'),
        ],
        'default' => 'bottom',
        'inline'  => true,
    ];
    $this->controls['stripesDegree'] = [
      'tab'     => 'content',
      'label'   => esc_html__('Degree', 'bricks'),
      'type'    => 'number',
      'unit'    => 'deg',
      'css'     => [
        [
          'property' => '--stripes-degree',
          'selector' => '',
        ],
      ],
      'default' => '135',
    ];
    $this->controls['stripesTranslateSpeed'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Translate Speed', 'bricks'),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
          [
            'property' => '--stripes-translate-speed',
            'selector' => '',
          ],
        ],
        'default' => '0.45s',
    ];
    $this->controls['stripesTranslateEase'] = [
      'tab'     => 'content',
      'label'   => esc_html__('Translate CSS Easing', 'bricks'),
      'type'    => 'text',
      'inline'  => true,
      'css'     => [
        [
          'property' => '--stripes-translate-ease',
          'selector' => '',
        ],
      ],
      'default' => 'cubic-bezier(.21, 1, .34, 1)',
    ];
    $this->controls['stripesMovementDuration'] = [
      'tab'     => 'content',
      'label'   => esc_html__('Movement Duration', 'bricks'),
      'type'    => 'number',
      'unit'    => 's',
      'css'     => [
        [
          'property' => '--stripes-movement-duration',
          'selector' => '',
        ],
      ],
      'default' => '1s',
    ];
    $this->controls['stripesMovementEase'] = [
      'tab'     => 'content',
      'label'   => esc_html__('Movement CSS Easing', 'bricks'),
      'type'    => 'text',
      'inline'  => true,
      'css'     => [
        [
          'property' => '--stripes-movement-ease',
          'selector' => '',
        ],
      ],
      'default' => 'linear',
    ];
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Stripes Button';
    $stripesFrom = ! empty( $settings['stripesFrom'] ) ? $settings['stripesFrom'] : 'bottom';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $includeLeftIcon = ! empty( $settings['includeLeftIcon'] ) ? $settings['includeLeftIcon'] : 0;
    $includeRightIcon = ! empty( $settings['includeRightIcon'] ) ? $settings['includeRightIcon'] : 0;
    if ( $includeLeftIcon !== 0 ) {
      $leftIcon = self::render_icon( $settings['leftIcon'], [ 'nb-stripes-button__left-icon' ] );
    }else{
      $leftIcon = '';
    }
    if ( $includeRightIcon !== 0 ) {
      $rightIcon = self::render_icon( $settings['rightIcon'], [ 'nb-stripes-button__right-icon' ] );
    }else{
      $rightIcon = '';
    }

    $this->set_attribute( '_root', 'class', 'nb-stripes-button' );

    $output = "
    <$root_tag  {$this->render_attributes( '_root' )}>
        <span class='nb-stripes-button__container'>
            <span class='nb-stripes-button__text'>$leftIcon$inner_title$rightIcon</span>
        </span>
        <span class='nb-stripes-button__background' data-from='$stripesFrom'></span>
    </$root_tag>
    ";

	echo $output;
  }
}