<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Table_Of_Contents extends \Bricks\Element {
    public $category     = 'Next Bricks - Cores';
    public $name         = 'next_table_of_contents';
    public $icon         = 'fas fa-table-list';
    public $scripts      = ['next_table_of_contents'];

    public function get_label() {
        return esc_html__( 'Table of contents', 'bricks' );
    }

    public function set_controls() {
        /*Settings*/
        $this->controls['enableSmoothScroll'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Smooth Scroll', 'bricks' ),
            'type' => 'checkbox',
        ];
        $this->controls['contentselector'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Content selector', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => '#brx-content',
        ];
        $this->controls['selector'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Headings selector', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => 'h2, h3',
        ];
        $this->controls['ignoreselector'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Ignore selector', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => '',
        ];
        $this->controls['scrolltoggle'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Scroll Toggle', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'onEnter' => 'On Enter',
                'onCenter' => 'On Center',
            ],
            'inline'      => true,
            'placeholder' => 'On Center',
        ];
        $this->controls['offsetclick'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Offset', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                  'property' => 'scroll-margin-top',
                  'selector' => '.toc-content__target',
                ]
            ],
            'placeholder' => '0px',
        ];

        /*Outline*/
        $this->controls['outlineAnimationSeparator'] = [
            'label'      => esc_html__( 'Outline', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['outlineWidth'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                  'property' => '--outline-width',
                  'selector' => '',
                ]
            ],
            'placeholder' => '2px',
        ];
        $this->controls['outlineColor'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Color', 'bricks' ),
            'type' => 'color',
            'inline' => true,
            'css' => [
                [
                  'property' => '--outline-color-from',
                  'selector' => '',
                ]
            ],
        ];
        $this->controls['outlineStyle'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Style', 'bricks' ),
            'type'        => 'select',
            'options'     => $this->control_options['borderStyle'],
            'css' => [
                [
                  'property' => '--outline-style',
                  'selector' => '',
                ]
            ],
            'inline'      => true,
            'placeholder' => esc_html__( 'Solid', 'bricks' ),
        ];
        $this->controls['outlineAnimationDuration'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Animation duration', 'bricks' ),
            'type' => 'number',
            'unit' => 's',
            'inline' => true,
            'css' => [
                [
                  'property' => '--outline-animation-duration',
                  'selector' => '',
                ]
            ],
            'placeholder' => '2s',
        ];

        /*Style*/
        $this->controls['styleSeparator'] = [
            'label'      => esc_html__( 'Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['stylePadding'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type' => 'spacing',
            'css' => [
                [
                  'property' => 'padding',
                  'selector' => '',
                ]
            ],
        ];
        $this->controls['styleTypography'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Typography', 'bricks' ),
            'type' => 'typography',
            'inline' => true,
            'css' => [
                [
                  'property' => 'typography',
                  'selector' => '',
                ]
            ],
        ];
        $this->controls['styleBackground'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type' => 'background',
            'inline' => true,
            'css' => [
                [
                  'property' => 'background',
                  'selector' => '',
                ]
            ],
        ];
        $this->controls['styleBorder'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type' => 'border',
            'inline' => true,
            'css' => [
                [
                  'property' => 'border',
                  'selector' => '',
                ]
            ],
        ];
        $this->controls['enableSticky'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Sticky', 'bricks' ),
            'type' => 'checkbox',
        ];
        $this->controls['stickyTop'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Top', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css' => [
              [
                'property' => 'top',
                'selector' => '&.next-toc--sticky',
              ]
            ],
            'placeholder' => '0',
            'required' => [ 'enableSticky', '=', true],
        ];

        /*Targets Style*/
        $this->controls['targetsStyleSeparator'] = [
            'label'      => esc_html__( 'Targets Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['targetsPadding'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type' => 'spacing',
            'css' => [
                [
                  'property' => 'padding',
                  'selector' => '.next-toc__link',
                ]
            ],
        ];
        $this->controls['targetsBorder'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type' => 'border',
            'inline' => true,
            'css' => [
                [
                  'property' => 'border',
                  'selector' => '.next-toc__link',
                ]
            ],
        ];
        $this->controls['targetsTypography'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Typography', 'bricks' ),
            'type' => 'typography',
            'inline' => true,
            'css' => [
                [
                  'property' => 'typography',
                  'selector' => '.next-toc__link',
                ]
            ],
        ];
        $this->controls['targetsHoverColor'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Hover color', 'bricks' ),
            'type' => 'color',
            'inline' => true,
            'css' => [
                [
                  'property' => 'color',
                  'selector' => '.next-toc__link:hover',
                ]
            ],
        ];
        $this->controls['targetsSelectedColor'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Selected color', 'bricks' ),
            'type' => 'color',
            'inline' => true,
            'css' => [
                [
                  'property' => 'color',
                  'selector' => '.next-toc__link--selected',
                ]
            ],
        ];
        $this->controls['lineSelectedColor'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Selected line color', 'bricks' ),
            'type' => 'color',
            'inline' => true,
            'css' => [
                [
                  'property' => 'background-color',
                  'selector' => '&.next-toc--static .next-toc__link--selected::before',
                ]
            ],
        ];
        $this->controls['lineSelectedWidth'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Selected line width', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                  'property' => 'width',
                  'selector' => '.next-toc__link::before',
                ]
            ],
            'placeholder' => '1px',
        ];

        /*Responsive*/
        $this->controls['responsiveSeparator'] = [
            'label'      => esc_html__( 'Responsive', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['enableCollapse'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Enable collapse', 'bricks' ),
            'type' => 'checkbox',
        ];

        //Breakpoints control
        $breakpoints        = Breakpoints::$breakpoints;
        $breakpoint_options = [];

        foreach ( $breakpoints as $index => $breakpoint ) {
            $breakpoint_options[ $breakpoint['key'] ] = $breakpoint['label'];
        }

        $this->controls['breakpoint'] = [
            'type'        => 'select',
            'options'     => $breakpoint_options,
            'rerender'    => true,
            'placeholder' => esc_html__( 'Mobile landscape', 'bricks' ),
            'required' => [ 'enableCollapse', '=', true],
        ];

        /*Arrow Style*/
        $this->controls['arrowStyleSeparator'] = [
            'label'      => esc_html__( 'Arrow Style', 'bricks' ),
            'type'       => 'separator',
            'required' => [ 'enableCollapse', '=', true],
        ];
        $this->controls['arrowDimensions'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Dimensions', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                  'property' => '--arrow-dimensions',
                  'selector' => '',
                ]
            ],
            'placeholder' => '16px',
            'required' => [ 'enableCollapse', '=', true],
        ];
        $this->controls['arrowColor'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Color', 'bricks' ),
            'type' => 'color',
            'inline' => true,
            'css' => [
                [
                  'property' => 'fill',
                  'selector' => '.next-toc__icon-arrow',
                ]
            ],
            'required' => [ 'enableCollapse', '=', true],
        ];

        /*Arrow animation*/
        $this->controls['arrowAnimationSeparator'] = [
            'label'      => esc_html__( 'Arrow Animation', 'bricks' ),
            'type'       => 'separator',
            'required' => [ 'enableCollapse', '=', true],
        ];
        $this->controls['arrowRotate'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Rotate', 'bricks' ),
            'type' => 'number',
            'unit' => 'deg',
            'inline' => true,
            'css' => [
                [
                  'property' => '--arrow-transform-rotate',
                  'selector' => '',
                ]
            ],
            'placeholder' => '-90deg',
            'required' => [ 'enableCollapse', '=', true],
        ];
        $this->controls['arrowTransformFrom'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Transform from', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                  'property' => '--arrow-transform-from',
                  'selector' => '',
                ]
            ],
            'placeholder' => '3px',
            'required' => [ 'enableCollapse', '=', true],
        ];
        $this->controls['arrowTransformIntensity'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Transform intensity', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                  'property' => '--arrow-transform-intensity',
                  'selector' => '',
                ]
            ],
            'placeholder' => '8px',
            'required' => [ 'enableCollapse', '=', true],
        ];
        $this->controls['arrowTransformDuration'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type' => 'number',
            'unit' => 's',
            'inline' => true,
            'css' => [
                [
                  'property' => '--arrow-transform-duration',
                  'selector' => '',
                ]
            ],
            'placeholder' => '0.3s',
            'required' => [ 'enableCollapse', '=', true],
        ];
        $this->controls['arrowTransformEasing'] = [
            'tab' => 'content',
            'label' => esc_html__( 'CSS easing', 'bricks' ),
            'type' => 'text',
            'css' => [
                [
                  'property' => '--arrow-transform-easing',
                  'selector' => '',
                ]
            ],
            'placeholder' => 'cubic-bezier(0.215, 0.61, 0.355, 1)',
            'required' => [ 'enableCollapse', '=', true],
        ];

        /*Dropdown animation*/
        $this->controls['dropdownAnimationSeparator'] = [
            'label'      => esc_html__( 'Dropdown Animation', 'bricks' ),
            'type'       => 'separator',
            'required' => [ 'enableCollapse', '=', true],
        ];
        $this->controls['dropdownAnimationFrom'] = [
            'tab' => 'content',
            'label' => esc_html__( 'From', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                  'property' => '--dropdown-from',
                  'selector' => '',
                ]
            ],
            'placeholder' => '10px',
            'required' => [ 'enableCollapse', '=', true],
        ];
        $this->controls['dropdownAnimationDuration'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type' => 'number',
            'unit' => 's',
            'inline' => true,
            'css' => [
                [
                  'property' => '--dropdown-duration',
                  'selector' => '',
                ]
            ],
            'placeholder' => '0.4s',
            'required' => [ 'enableCollapse', '=', true],
        ];
        $this->controls['dropdownAnimationEasing'] = [
            'tab' => 'content',
            'label' => esc_html__( 'CSS easing', 'bricks' ),
            'type' => 'text',
            'css' => [
                [
                  'property' => '--dropdown-easing',
                  'selector' => '',
                ]
            ],
            'placeholder' => 'cubic-bezier(0.215, 0.61, 0.355, 1)',
            'required' => [ 'enableCollapse', '=', true],
        ];

        /*Text swap animation*/
        $this->controls['textSwapSeparator'] = [
            'label'      => esc_html__( 'Text swap animation', 'bricks' ),
            'type'       => 'separator',
            'required' => [ 'enableCollapse', '=', true],
        ];
        $this->controls['textSwapFrom'] = [
            'tab' => 'content',
            'label' => esc_html__( 'From', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                  'property' => '--text-swap-from',
                  'selector' => '',
                ]
            ],
            'placeholder' => '-10px',
            'required' => [ 'enableCollapse', '=', true],
        ];
        $this->controls['textSwapDuration'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type' => 'number',
            'unit' => 's',
            'inline' => true,
            'css' => [
                [
                  'property' => '--text-swap-duration',
                  'selector' => '',
                ]
            ],
            'placeholder' => '0.4s',
            'required' => [ 'enableCollapse', '=', true],
        ];
        $this->controls['textSwapEasing'] = [
            'tab' => 'content',
            'label' => esc_html__( 'CSS easing', 'bricks' ),
            'type' => 'text',
            'css' => [
                [
                  'property' => '--text-swap-easing',
                  'selector' => '',
                ]
            ],
            'placeholder' => 'cubic-bezier(0.215, 0.61, 0.355, 1)',
            'required' => [ 'enableCollapse', '=', true],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_table_of_contents', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_table_of_contents.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        /* Smooth Scroll*/
        $enableSmoothScroll = ! empty( $settings['enableSmoothScroll'] ) ? $settings['enableSmoothScroll'] : 0;
        if($enableSmoothScroll == 1){
            $this->set_attribute( '_root', 'data-smooth-scroll', $enableSmoothScroll);
        }

        /* Sticky */
        $enableSticky = ! empty( $settings['enableSticky'] ) ? $settings['enableSticky'] : 0;
        if($enableSticky == 1){
            $this->set_attribute( '_root', 'class', "next-toc--sticky");
        }

        /* Responsive */
        $enableCollapse = ! empty( $settings['enableCollapse'] ) ? $settings['enableCollapse'] : 0;
        $show_nav_button_at = ! empty( $settings['breakpoint'] ) ? $settings['breakpoint'] : 'mobile_landscape';
        $breakpoint = Breakpoints::get_breakpoint_by( 'key', $show_nav_button_at );
        $breakpoint_width    = ! empty( $breakpoint['width'] ) ? intval( $breakpoint['width'] ) : 0;

        /* JS */
        $contentselector = ! empty( $settings['contentselector'] ) ? $settings['contentselector'] : '#brx-content';
        $selector = ! empty( $settings['selector'] ) ? $settings['selector'] : 'h2, h3';
        $ignoreselector = ! empty( $settings['ignoreselector'] ) ? $settings['ignoreselector'] : '';
        $scrolltoggle = ! empty( $settings['scrolltoggle'] ) ? $settings['scrolltoggle'] : '';

        $this->set_attribute( '_root', 'class', "next-toc");
        $this->set_attribute( '_root', 'class', "next-toc--static@md");

        $this->set_attribute( '_root', 'data-responsive', $enableCollapse);
        $this->set_attribute( '_root', 'data-breakpoint', $breakpoint_width);

        $this->set_attribute( '_root', 'data-content-selector', $contentselector);
        $this->set_attribute( '_root', 'data-selector', $selector);
        $this->set_attribute( '_root', 'data-ignore-selector', $ignoreselector);
        $this->set_attribute( '_root', 'data-scroll-toggle', $scrolltoggle);

        $output = "<div {$this->render_attributes( '_root' )}>";

        /* Responsive */
        $output .= '
        <button class="next-toc__control" aria-controls="next-toc">
            <span class="next-toc__control-text">
                <i class="next-toc__control-label">In this article -</i>
                <i aria-hidden="true">Select</i>
            </span>
        
            <svg class="next-toc__icon-arrow" viewBox="0 0 16 16" aria-hidden="true">
                <g class="next-toc-icon__group" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                <path d="M3 3l10 10"></path>
                <path d="M13 3L3 13"></path>
                </g>
            </svg>
        </button>';

        $output .= '
        <nav class="next-toc__nav">
            <ul class="next-toc__list">
            </ul>
        </nav>
        ';

        $output .= '</div>';

        /* Responsive */
        $inline_css = '';
        if($enableCollapse == 1){
            $inline_css .= "@media (min-width: {$breakpoint_width}px) {";
            $inline_css .= "
                .next-toc--static\@md::before {
                    content: 'static';
                }
            ";
            $inline_css .= '}';
        
            $output .= "<style>$inline_css</style>";
        }else{
            $inline_css .= "
                .next-toc--static\@md::before {
                    content: 'static';
                }
            ";
            $inline_css .= '}';
        
            $output .= "<style>$inline_css</style>";
        }

        echo $output;
    }
}