<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Text_Shimmer extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'next-text-shimmer';
  public $icon         = 'ti-text';
  public $tag      = 'h3';
  public $scripts      = ['next_text_shimmer'];

  public function get_label() {
    return esc_html__( 'Text Shimmer', 'bricks' );
  }

  public function set_controls() {
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'textarea',
          'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Text Shimmer', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];

    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'h1' => 'h1',
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
            'p' => 'p',
            'span' => 'span',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'h3',
        'default'     => 'h3',
    ];
    $this->controls['customTag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Custom tag', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'placeholder' => 'h3',
        'required'    => [ 'tag', '=', 'custom' ],
    ];

    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['textColor'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Text color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--text-color',
                'selector' => '',
            ],
        ],
        'default' => [
            'hex' => 'rgba(255, 255, 255, 0.2)',
        ],
    ];
    $this->controls['shimmerColor'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Shimmer color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--shimmer-color',
                'selector' => '',
            ],
        ],
        'default' => [
            'hex' => 'rgba(255, 255, 255, 0.9)',
        ],
    ];
    $this->controls['shimmerSize'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Shimmer size', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => '--shimmer-size',
                'selector' => '',
            ],
        ],
        'default' => '50px',
    ];
    $this->controls['padding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '&:not(:has(> a)), > a',
            ],
        ],
        'default' => [
            'top'    => 12,
            'right'  => 24, 
            'bottom' => 12,
            'left'   => 24,
        ],
    ];
    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'font-weight' => '500',
        ],
    ];
    $this->controls['background'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '',
            ],
        ],
        'default' => [
            'hex' => '#171717',
        ],
    ];

    $this->controls['border'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Border', 'bricks' ),
        'type'    => 'border',
        'units'   => true,
        'css'     => [
            [
                'property' => 'border',
                'selector' => '',
            ],
        ],
        'default' => [
            'radius' => [
              'top' => 100,
              'right' => 100,
              'bottom' => 100,
              'left' => 100,
            ],
        ],
    ];

    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
      ];
      
      $this->controls['disablebuilder'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
        'type'     => 'checkbox',
        'default' => false,
      ];
  
    $this->controls['duration'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '1.7s',
    ];

    $this->controls['delayBetweenShimmers'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Delay between shimmers', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'default' => '1.5s',
    ];

    $this->controls['ease'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
            'none' => 'none',
            'power1' => 'power1',
            'power2' => 'power2',
            'power3' => 'power3',
            'power4' => 'power4',
            'back' => 'back',
            'bounce' => 'bounce',
            'circ' => 'circ',
            'elastic' => 'elastic',
            'expo' => 'expo',
            'sine' => 'sine',
        ],
        'inline' => true,
        'default' => 'sine',
    ];

    //Padding from style tab applied to the root without link and to the link if exists
    $this->controls['_padding'] = [
      'tab'   => 'style',
      'group' => '_layout',
      'label' => esc_html__( 'Padding', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'padding',
          'selector' => '&:not(:has(> a)), > a',
        ]
      ],
    ];
  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'next-text-shimmer', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_text_shimmer.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';
    $duration = ! empty( $settings['duration'] ) ? $settings['duration'] : 1.7;
    $delayBetweenShimmers = ! empty( $settings['delayBetweenShimmers'] ) ? $settings['delayBetweenShimmers'] : 1.5;
    $ease = ! empty( $settings['ease'] ) ? $settings['ease'] : 'sine';
    $disablebuilder = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;

    $this->set_attribute( '_root', 'class', 'nb-text-shimmer' );
    $this->set_attribute( '_root', 'data-flickering', '1' );
    $this->set_attribute( '_inner', 'class', 'nb-text-shimmer__inner' );
    $this->set_attribute( '_inner', 'data-duration', "$duration");
    $this->set_attribute( '_inner', 'data-ease', "$ease");
    $this->set_attribute( '_inner', 'data-stagger', "$delayBetweenShimmers");
    $this->set_attribute( '_inner', 'data-disable-builder', $disablebuilder);

    if ( ! empty( $settings['link'] ) ) {
        $this->set_link_attributes( '_link', $settings['link'] );
        $output ="
        <{$this->tag} {$this->render_attributes( '_root' )}>
            <a class='nb-text-shimmer__anchor' {$this->render_attributes( '_link' )}>
                <span {$this->render_attributes( '_inner' )}>$inner_title</span>
            </a>
        </{$this->tag}>
        ";
            }else{
        $output ="
        <{$this->tag} {$this->render_attributes( '_root' )}>
            <span {$this->render_attributes( '_inner' )}>$inner_title</span>
        </{$this->tag}>
        ";
    }

    echo $output;
  }
}

