<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Thumbnail_Slider extends \Bricks\Element {
    public $category     = 'Next Bricks - Sliders';
    public $name         = 'next_thumbnail_slider';
    public $icon         = 'ti-layout-list-large-image';
    public $tag      = 'div';
    public $scripts      = ['next_thumbnail_slider'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Thumbnail Slider', 'bricks' );
    }

    public function set_controls() {
        $this->controls['tag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'HTML tag', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'div' => 'div',
                'section' => 'section',
                'article' => 'article',
                'aside' => 'aside',
                'header' => 'header',
                'footer' => 'footer',
                'main' => 'main',
                'nav' => 'nav',
                'custom' => 'custom',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'div',
            'default'     => 'div',
        ];
        $this->controls['customTag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Custom tag', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'placeholder' => 'div',
            'required'    => [ 'tag', '=', 'custom' ],
        ];
    
        /*css*/
        $this->controls['styleSeparator'] = [
            'label'      => esc_html__( 'Block Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['width'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'width',
                'selector' => '',
              ]
            ],
            'default' => '100%',
        ];
        $this->controls['maxWidth'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Max Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'max-width',
                'selector' => '',
              ]
            ],
            'default' => '800px',
        ];
        $this->controls['height'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'height',
                'selector' => '',
              ]
            ],
            'default' => 'auto',
        ];

        $this->controls['slidesContainerSeparator'] = [
            'label'      => esc_html__( 'Slides Container', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['previewheight'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'height',
                'selector' => '.nb-thumbnail-slider__preview',
              ]
            ],
            'default' => 'auto',
        ];
        $this->controls['previewBorder'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type' => 'border',
            'inline' => true,
            'css' => [
                [
                    'property' => 'border',
                    'selector' => '.nb-thumbnail-slider__preview',
                ],
            ],
            'default' => [
                'width' => [
                    'top' => 1,
                    'right' => 1,
                    'bottom' => 1,
                    'left' => 1,
                ],
                'style' => 'solid',
                'color' => [
                    'hex' => '#191919',
                ],
                'radius' => [
                    'top' => '16',
                    'right' => '16',
                    'bottom' => '16',
                    'left' => '16',
                ]
            ],
        ];

        $this->controls['thumbnailsContainerSeparator'] = [
            'label'      => esc_html__( 'Thumbnails Container', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['thumbnailsContainerMargin'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Margin', 'bricks' ),
            'type'  => 'spacing',
            'css' => [
              [
                'property' => 'margin',
                'selector' => '.nb-thumbnail-slider__thumbnails',
              ]
            ],
            'default' => [
                'top' => '16',
            ],
        ];
        $this->controls['thumbnailsContainerPadding'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type'  => 'spacing',
            'css' => [
              [
                'property' => 'padding',
                'selector' => '.nb-thumbnail-slider__thumbnails',
              ]
            ],
            'default' => [
                'top' => '7',
                'right' => '7',
                'bottom' => '7',
                'left' => '7',
            ],
        ];
        $this->controls['thumbnailsContainerWidth'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'width',
                'selector' => '.nb-thumbnail-slider__thumbnails',
              ]
            ],
            'default' => 'fit-content',
        ];
        $this->controls['thumbnailsContainerMaxWidth'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Max Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'max-width',
                'selector' => '.nb-thumbnail-slider__thumbnails',
              ]
            ],
            'default' => '350px',
        ];
        $this->controls['thumbnailsContainerGap'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Gap', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'gap',
                'selector' => '.nb-thumbnail-slider__thumbnails',
              ]
            ],
            'default' => '4px',
        ];
        $this->controls['thumbnailsContainerBackground'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type'  => 'background',
            'inline' => true,
            'css' => [
              [
                'property' => 'background',
                'selector' => '.nb-thumbnail-slider__thumbnails',
              ]
            ],
            'default' => [
                'color' => [
                    'hex' => '#171717',
                ]
            ]
        ];
        $this->controls['thumbnailsContainerBorderRadius'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type'  => 'border',
            'inline' => true,
            'css' => [
              [
                'property' => 'border',
                'selector' => '.nb-thumbnail-slider__thumbnails',
              ]
            ],
            'default' => [
                'radius' => [
                    'top' => '12',
                    'right' => '12',
                    'bottom' => '12',
                    'left' => '12',
                ]
            ],
        ];

        $this->controls['morphingSelectorSeparator'] = [
            'label'      => esc_html__( 'Morphing Selector', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['morphingSelectorZIndex'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'zIndex', 'bricks' ),
            'type' => 'number',
            'css' => [
              [
                'property' => 'z-index',
                'selector' => '.nb-thumbnail-slider__selector',
              ]
            ],
            'default' => '9999',
        ];
        $this->controls['morphingSelectorBorder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type' => 'border',
            'css' => [
              [
                'property' => 'border',
                'selector' => '.nb-thumbnail-slider__selector',
              ]
            ],
            'default' => [
                'width' => [
                    'top' => 2,
                    'right' => 2,
                    'bottom' => 2,
                    'left' => 2,
                ],
                'style' => 'solid',
                'color' => [
                    'hex' => '#fff',
                ],
                'radius' => [
                    'top' => '8',
                    'right' => '8',
                    'bottom' => '8',
                    'left' => '8',
                ]
            ],
        ];

        $this->controls['thumbnailSeparator'] = [
            'label'      => esc_html__( 'Thumbnail', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['thumbnailsWidth'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => '--thumbnails-width',
                'selector' => '',
              ]
            ],
            'default' => '90px',
        ];
        $this->controls['thumbnailsHeight'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => '--thumbnails-height',
                'selector' => '',
              ]
            ],
            'default' => '50px',
        ];
        $this->controls['thumbnailsBorder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type' => 'border',
            'css' => [
              [
                'property' => 'border',
                'selector' => '.nb-thumbnail-slider__thumb',
              ]
            ],
            'default' => [
                'width' => [
                    'top' => 1,
                    'right' => 1,
                    'bottom' => 1,
                    'left' => 1,
                ],
                'style' => 'solid',
                'color' => [
                    'hex' => '#444',
                ],
                'radius' => [
                    'top' => '8',
                    'right' => '8',
                    'bottom' => '8',
                    'left' => '8',
                ]
            ]
        ];
        $this->controls['thumbnailsBrightness'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Brightness', 'bricks' ),
            'type' => 'number',
            'unit' => '%',
            'inline' => true,
            'css' => [
              [
                'property' => '--thumbnails-brightness',
                'selector' => '.nb-thumbnail-slider__thumb',
              ]
            ],
            'default' => '50%',
        ];
        $this->controls['thumbnailFilterDuration'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Filter Duration', 'bricks' ),
            'type' => 'number',
            'unit' => 's',
            'inline' => true,
            'css' => [
              [
                'property' => '--thumbnail-filter-duration',
                'selector' => '.nb-thumbnail-slider__thumb',
              ]
            ],
            'default' => '0.3s',
        ];
        $this->controls['thumbnailFilterEase'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Filter CSS Easing', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'css' => [
              [
                'property' => '--thumbnail-filter-ease',
                'selector' => '.nb-thumbnail-slider__thumb',
              ]
            ],
            'default' => 'ease',
        ];

        $this->controls['arrowsSeparator'] = [
            'label'      => esc_html__( 'Arrows', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['displaySelect'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Display', 'bricks' ),
            'small' => true,
            'type' => 'select',
            'options' => [
                'flex' => esc_html__( 'Flex', 'bricks' ),
                'none' => esc_html__( 'None', 'bricks' ),
            ],
            'inline' => true,
            'css' => [
              [
                'property' => 'display',
                'selector' => '.nb-thumbnail-slider__arrow',
              ]
            ],
            'default' => 'flex',
        ];
        $this->controls['arrowZIndex'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'zIndex', 'bricks' ),
            'type' => 'number',
            'inline' => true,
            'css' => [
              [
                'property' => 'z-index',
                'selector' => '.nb-thumbnail-slider__arrow',
              ]
            ],
            'default' => '10',
        ];
        $this->controls['arrowDimensions'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Dimensions', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => '--arrow-dimensions',
                'selector' => '.nb-thumbnail-slider__arrow',
              ]
            ],
            'default' => '30px',
        ];
        $this->controls['arrowFill'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Fill', 'bricks' ),
            'type' => 'color',
            'inline' => true,
            'css' => [
              [
                'property' => 'fill',
                'selector' => '.nb-thumbnail-slider__arrow',
              ]
            ],
            'default' => [
                'hex'=> '#ffffff'
            ]
        ];
        $this->controls['arrowBackground'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type' => 'color',
            'inline' => true,
            'css' => [
              [
                'property' => 'background',
                'selector' => '.nb-thumbnail-slider__arrow',
              ]
            ],
            'default' => [
                'rgb'=> 'rgba(0, 0, 0, 0.5)'
            ]
        ];
        $this->controls['arrowBorder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type' => 'border',
            'inline' => true,
            'css' => [
              [
                'property' => 'border',
                'selector' => '.nb-thumbnail-slider__arrow',
              ]
            ],
            'default' => [
                'radius' => [
                    'top' => '50%',
                    'right' => '50%',
                    'bottom' => '50%',
                    'left' => '50%',
                ]
            ],
        ];
        $this->controls['arrowLeftPosition'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Arrow Left Position', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'left',
                'selector' => '.nb-thumbnail-slider__arrow--left',
              ]
            ],
            'default' => '10px',
        ];
        $this->controls['arrowRightPosition'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Arrow Right Position', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'right',
                'selector' => '.nb-thumbnail-slider__arrow--right',
              ]
            ],
            'default' => '10px',
        ];

        $this->controls['scrollAnimationSeparator'] = [
            'label'      => esc_html__( 'Scroll Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['scrollDuration'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type' => 'number',
            'unit' => 's',
            'inline' => true,
            'default' => '0.6s',
        ];
        $this->controls['scrollEase'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'GSAP Easing', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'none' => 'none',
                'power1' => 'power1',
                'power2' => 'power2',
                'power3' => 'power3',
                'power4' => 'power4',
                'back' => 'back',
                'bounce' => 'bounce',
                'circ' => 'circ',
                'elastic' => 'elastic',
                'expo' => 'expo',
                'sine' => 'sine',
                'steps' => 'steps'
            ],
            'inline' => true,
            'default' => 'expo',
        ];

        $this->controls['selectorAnimationSeparator'] = [
            'label'      => esc_html__( 'Selector Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['selectorDuration'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type' => 'number',
            'unit' => 's',
            'inline' => true,
            'default' => '0.6s',
        ];
        $this->controls['selectorEase'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'GSAP Easing', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'none' => 'none',
                'power1' => 'power1',
                'power2' => 'power2',
                'power3' => 'power3',
                'power4' => 'power4',
                'back' => 'back',
                'bounce' => 'bounce',
                'circ' => 'circ',
                'elastic' => 'elastic',
                'expo' => 'expo',
                'sine' => 'sine',
                'steps' => 'steps'
            ],
            'inline' => true,
            'default' => 'expo',
        ];
    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'image',
                'label'    => esc_html__( 'Slide', 'bricks' ),
                'settings' => [
                    'image'  => [
                        'url' => 'https://oxyfolio.com/wp-content/uploads/2025/04/14-1-scaled.jpg',
                    ],
                    '_hidden'  => [
                        '_cssClasses' => 'nb-thumbnail-slider__thumb nb-thumbnail-slider__thumb--active',
                    ],
                    '_attributes' => [
                        [
                        'name' => 'tabindex',
                        'value' => '0',
                        ],
                    ]
                ],
            ],
            [
                'name'     => 'image',
                'label'    => esc_html__( 'Slide', 'bricks' ),
                'settings' => [
                    'image'  => [
                        'url' => 'https://oxyfolio.com/wp-content/uploads/2025/04/24-scaled.jpg',
                    ],
                    '_hidden'  => [
                        '_cssClasses' => 'nb-thumbnail-slider__thumb',
                    ],
                    '_attributes' => [
                        [
                        'name' => 'tabindex',
                        'value' => '0',
                        ],
                    ]
                ],
            ],
            [
                'name'     => 'image',
                'label'    => esc_html__( 'Slide', 'bricks' ),
                'settings' => [
                    'image'  => [
                        'url' => 'https://oxyfolio.com/wp-content/uploads/2025/04/74-scaled.jpg',
                    ],
                    '_hidden'  => [
                        '_cssClasses' => 'nb-thumbnail-slider__thumb',
                    ],
                    '_attributes' => [
                        [
                        'name' => 'tabindex',
                        'value' => '0',
                        ],
                    ]
                ],
            ],
            [
                'name'     => 'image',
                'label'    => esc_html__( 'Slide', 'bricks' ),
                'settings' => [
                    'image'  => [
                        'url' => 'https://oxyfolio.com/wp-content/uploads/2025/04/46-scaled.jpg',
                    ],
                    '_hidden'  => [
                        '_cssClasses' => 'nb-thumbnail-slider__thumb',
                    ],
                    '_attributes' => [
                        [
                        'name' => 'tabindex',
                        'value' => '0',
                        ],
                    ]
                ],
            ],
            [
                'name'     => 'image',
                'label'    => esc_html__( 'Slide', 'bricks' ),
                'settings' => [
                    'image'  => [
                        'url' => 'https://oxyfolio.com/wp-content/uploads/2025/04/83-scaled.jpg',
                    ],
                    '_hidden'  => [
                        '_cssClasses' => 'nb-thumbnail-slider__thumb',
                    ],
                    '_attributes' => [
                        [
                        'name' => 'tabindex',
                        'value' => '0',
                        ],
                    ]
                ],
            ],
            [
                'name'     => 'image',
                'label'    => esc_html__( 'Slide', 'bricks' ),
                'settings' => [
                    'image'  => [
                        'url' => 'https://oxyfolio.com/wp-content/uploads/2025/04/80-scaled.jpg',
                    ],
                    '_hidden'  => [
                        '_cssClasses' => 'nb-thumbnail-slider__thumb',
                    ],
                    '_attributes' => [
                        [
                        'name' => 'tabindex',
                        'value' => '0',
                        ],
                    ]
                ],
            ],
            [
                'name'     => 'image',
                'label'    => esc_html__( 'Slide', 'bricks' ),
                'settings' => [
                    'image'  => [
                        'url' => 'https://oxyfolio.com/wp-content/uploads/2025/04/16-gigapixel-standard20v2-7680w-scaled.jpeg',
                    ],
                    '_hidden'  => [
                        '_cssClasses' => 'nb-thumbnail-slider__thumb',
                    ],
                    '_attributes' => [
                        [
                        'name' => 'tabindex',
                        'value' => '0',
                        ],
                    ]
                ],
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next-gsap-scroll-to', NEXTBRICKS_PLUGIN_URL . 'local_assets/next_gsap_scroll_to.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
        wp_enqueue_script( 'next_thumbnail_slider', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_thumbnail_slider.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $scrollDuration    = ! empty( $settings['scrollDuration'] ) ? $settings['scrollDuration'] : 0.6;
        $scrollEase    = ! empty( $settings['scrollEase'] ) ? $settings['scrollEase'] : 'expo';
        $selectorDuration    = ! empty( $settings['selectorDuration'] ) ? $settings['selectorDuration'] : 0.6;
        $selectorEase    = ! empty( $settings['selectorEase'] ) ? $settings['selectorEase'] : 'expo';

        $this->set_attribute( '_root', 'class', "nb-thumbnail-slider");
        $this->set_attribute( '_root', 'data-flickering', "1");
        $this->set_attribute( '_root', 'data-scroll-duration', $scrollDuration);
        $this->set_attribute( '_root', 'data-scroll-ease', $scrollEase);
        $this->set_attribute( '_root', 'data-selector-duration', $selectorDuration);
        $this->set_attribute( '_root', 'data-selector-ease', $selectorEase);

        $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
            $output .= "
            <div class='nb-thumbnail-slider__preview'>
                <div class='nb-thumbnail-slider__arrow nb-thumbnail-slider__arrow--left' aria-label='Previous image' tabindex='0'>
                    <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24'>
                    <path d='M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z'/>
                    </svg>
                </div>
                <img class='nb-thumbnail-slider__main-image' alt='Preview'>
                <div class='nb-thumbnail-slider__arrow nb-thumbnail-slider__arrow--right' aria-label='Next image' tabindex='0'>
                    <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24'>
                    <path d='M8.59 16.59L13.17 12 8.59 7.41 10 6l6 6-6 6z'/>
                    </svg>
                </div>
            </div>

            <div class='nb-thumbnail-slider__thumbnails nb-thumbnail-slider__thumb-container'>
                <div class='nb-thumbnail-slider__selector'></div>";
        $output .= Frontend::render_children( $this );
        $output .= "
            </div>
        </{$this->tag}>";

        echo $output;
    }
}