<?php

namespace NextBricks;

class includeElementsConditionalCSS{
    public function init(){
        add_action('wp', [$this, 'enqueue_styles']);
    }

    public function enqueue_styles() {
        //Get content
        //Use the stylesheet name to enqueue the stylesheet and the element name to find it
        /*
        FORMAT:
        elementName => stylesheetName
        */
        $elements = [
            //Texts
            'blade-title' => 'bc_blade_title',
            'circular-title' => 'bc_circular_title',
            'bc-counter' => 'bc_counter',
            'decode-hover' => 'bc_decode_hover',
            'decode-reveal' => 'bc_decode_reveal',
            'exchange_title' => 'bc_exchange_title',
            'fluid-gradient' => 'bc_fluid_gradient_title',
            'highlight-hover' => 'bc_highlight_title',
            'title-images' => 'bc_title_images',
            'letter-launcher' => 'bc_letter_launcher',
            'mask-hover' => 'bc_mask_hover',
            'bc_mousefill_title' => 'bc_mousefill_title',
            'random-letters' => 'bc_random_letters',
            'scribble-title' => 'bc_scribble_title',
            'bc_scroll_cascading' => 'bc_scroll_cascading',
            'scroll-gradient' => 'bc_scroll_gradient',
            'scroll reading' => 'bc_scroll_reading',
            'svgtitle' => 'bc_svg_title',
            'swap-hover' => 'bc_swap_title',
            'bc-typed' => 'bc_typed',
            '3d-title' => 'bc_twist_title',
            'underlined-hover' => 'bc_underline_title',
            'bc_unfold_hover' => 'bc_unfold_hover',
            'unfold-reveal' => 'bc_unfold_reveal',
            '3d-swap-title' => 'bc_3d_swap_title',
            'blended-title' => 'bc_blended_title',
            'next_blur_reading' => 'bc_blur_reading',
            'next_blur_reveal' => 'bc_blur_reveal',
            'next-counter-v2' => 'next_counter_v2',
            'next-countdown' => 'next_countdown',
            'next-text-shimmer' => 'next_text_shimmer',
            'next-dynamic-copyright' => 'next_dynamic_copyright',
            'next-proximity-hover' => 'next_proximity_hover',
            'next-swap-reading' => 'next_swap_reading',
            'next-variable-font-hover' => 'next_variable_font_hover',
            'next-shading-lines-title' => 'next_shading_lines_title',
            'next_exchange_title_v2' => 'next_exchange_title_v2',
            'next_highlight' => 'next_highlight',
            'next_link_preview' => 'next_link_preview',
            'next_read_more' => 'next_read_more',

            // Buttons
            'next-arrow-button-v4' => 'next_arrow_button_v4',
            'next-arrow-button-v5' => 'next_arrow_button_v5',
            'next-arrow-button-v6' => 'next_arrow_button_v6',
            'next-arrow-button-v7' => 'next_arrow_button_v7',
            'next-arrow-button-v8' => 'next_arrow_button_v8',
            'next-blurry-button' => 'next_blurry_button',
            'next-bubbles-button' => 'next_bubbles_button',
            'next-dot-button' => 'next_dot_button',
            'next-dot-button-v2' => 'next_dot_button_v2',
            'next-dot-button-v3' => 'next_dot_button_v3',
            'next-flipflop-button' => 'next_flipflop_button',
            'next-flipflop-button-v2' => 'next_flipflop_button_v2',
            'next-flipflop-button-v3' => 'next_flipflop_button_v3',
            'next-nudge-button' => 'next_nudge_button',
            'next-pixels-button' => 'next_pixels_button',
            'next-prism-button-v2' => 'next_prism_button_v2',
            'next-reel-button' => 'next_reel_button',
            'next-ripple-button-v4' => 'next_ripple_button_v4',
            'next-ripple-button-v5' => 'next_ripple_button_v5',
            'next-ripple-button-v6' => 'next_ripple_button_v6',
            'next-ripple-button-v7' => 'next_ripple_button_v7',
            'next-squeezy-radius-button' => 'next_squeezy_radius_button',
            'next-stretchy-button' => 'next_stretchy_button',
            'next-strip-button' => 'next_strip_button',
            'next-stripes-button' => 'next_stripes_button',
            'next-rainbow-button' => 'next_rainbow_button',
            'anysidebutton' => 'bc_anyside_button',
            'arrowbutton' => 'bc_arrow_button',
            'crystalbutton' => 'bc_crystal_button',
            'layerbutton' => 'bc_layer_button',
            'ripplebutton' => 'bc_ripple_button',
            'marqueebutton' => 'bc_marquee_button',
            'microboxbutton' => 'bc_microbox_button',
            'glowingbutton' => 'bc_glowing_button',
            'maskbutton' => 'bc_mask_button',
            'prismbutton' => 'bc_prism_button',
            'neumorphicbutton' => 'bc_neumorphic_button',
            'split_button' => 'bc_split_button',
            'nextarrowicon' => 'next_arrow_icon',
            'ripple_button_v2' => 'next_ripple_button_v2',
            'marquee_button_v2' => 'next_marquee_button_v2',
            'ripple_button_v3' => 'next_ripple_button_v3',
            'next-shiny-button' => 'next_shiny_button',
            'next-arrow-button-v2' => 'next_arrow_button_v2',
            'next-arrow-button-v3' => 'next_arrow_button_v3',

            //Menus
            'stickynav' => 'bc_sticky_nav',
            'offcanvasmenu' => 'bc_offcanvas_menu',
            'overlaymenu' => 'bc_overlay_menu',
            'morphingmenu' => 'bc_morphing_menu',
            'coreburguer' => 'bc_core_burguer',
            'stripemegamenu' => 'bc_stripe_megamenu',
            'bc_drawer' => 'bc_drawer',
            'expandingmenu' => 'bc_expanding_menu',
            'simplemenu' => 'bc_simple_menu',
            'multioffcanvasmenu' => 'bc_multioffcanvas',
            'nextdropdown' => 'next_dropdown',
            'nextdropdownmegamenu' => 'next_dropdown_mega_menu',
            'next-circular-menu' => 'next_circular_menu',
            'nextctanav' => 'next_cta_nav',
            'next_dock_menu' => 'next_dock_menu',
            'next-dynamic-island' => 'next_dynamic_island',
            'next-focus-nav' => 'next_focus_nav',
            'next-gooey-nav' => 'next_gooey_nav',

            //Sliders
            'next_stories' => 'next_stories',
            'next_thumbnail_slider' => 'next_thumbnail_slider',
            'next_infinite_slider' => 'next_infinite_slider',
            'coreslider' => 'bc_core_slider',
            'next_parallax_slider' => 'next_parallax_slider',

            //Backgrounds
            'next_crosshair' => 'next_crosshair',
            'next_figures' => 'next_figures',
            'next_interactive_lines_v2' => 'next_interactive_lines_v2',
            'next_interactive_lines_v3' => 'next_interactive_lines_v3',
            'next_interactive_lines_v4' => 'next_interactive_lines_v4',
            'next_iridescence' => 'next_iridescence',
            'next_overlay_shadows' => 'next_overlay_shadows',
            'next_scrolling_background' => 'next_scrolling_background',
            'next_tiles_v2' => 'next_tiles_v2',
            'next_interactive_lines' => 'next_interactive_lines',
            'grained' => 'bc_grained',
            'generatorism' => 'bc_generatorism',
            'spotlight' => 'bc_spotlight',
            'gradiently' => 'bc_gradiently',
            'next_spotlight_v2' => 'next_spotlight_v2',
            'next_physics' => 'next_physics',
            'next_particles' => 'next_particles',
            'bubbles' => 'bc_bubbles',
            'next-border-beam' => 'next_border_beam',
            'next_tiles' => 'next_tiles',
            'next_meteors' => 'next_meteors',
            'next_fluids' => 'next_fluids',

            //Cursors
            'next_cursor_trail' => 'next_cursor_trail',
            'next_mouse_parallax' => 'next_mouse_parallax',
            'next_designer_cursor' => 'next_designer_cursor',
            'next_cursor_slide' => 'next_cursor_slide',

            //Medias
            'next_beforeafter_image_v2' => 'next_beforeafter_image_v2',
            'next-image-reveal-v2' => 'next_image_reveal_v2',
            'next-image-reveal-v3' => 'next_image_reveal_v3',
            'next-image-reveal-v4' => 'next_image_reveal_v4',
            'next_lightbox' => 'next_lightbox',
            'next_scrolling_gallery' => 'next_scrolling_gallery',
            'next_image_accordion' => 'next_image_accordion',
            'parallax' => 'bc_parallax',
            'beforeafte-image' => 'bc_beforeafter_image',
            'zoomlens' => 'bc_zoom_lens',
            'videosequence' => 'bc_video_sequence',
            'imagehotspots' => 'bc_image_hotspots',
            'bc_media' => 'bc_media',
            'imagereveal' => 'bc_image_reveal',

            //Cores
            'next_audio_player' => 'next_audio_player',
            'next_looping_tabs' => 'next_looping_tabs',
            'next_site_loader' => 'next_site_loader',
            'Scrollbar' => 'bc_scrollbar',
            'marquee' => 'bc_marquee',
            'back-to-top' => 'bc_back_to_top',
            'sharer' => 'bc_sharer',
            'nightmode' => 'bc_dark_mode',
            'bclottie' => 'bc_lottie',
            'expander' => 'bc_expander',
            'clickandcopy' => 'bc_clickandcopy',
            '3dhover' => 'bc_3dhover',
            'coretabs' => 'bc_core_tabs',
            
            'bc_divider' => 'bc_divider',
            'flipbox' => 'bc_flipbox',
            'observer' => 'bc_observer',
            'bc_codepen' => 'bc_codepen',
            'bc_glowing_card' => 'bc_glowingcard',
            
            'bc_spinner' => 'bc_spinner',
            'next_lamp' => 'next_lamp',
            'next_horizontal_scroll' => 'next_horizontal_scroll',
            'next_timeline' => 'next_timeline',
            'next_table_of_contents' => 'next_table_of_contents',
            'infinite_title' => 'bc_infinite_title',
            'next_inverted_corners' => 'next_inverted_corners',
            'next_stacking_cards' => 'next_stacking_cards',

            'next_qr_code' => 'next_qr_code',
            'next_cookies' => 'next_cookies',
            'next_interactive_divider' => 'next_interactive_divider',
            'next_progress_bar' => 'next_progress_bar',
            'next-pixels-shimmer-card' => 'next_pixels_shimmer_card',
            'next_progress_bar_v2' => 'next_progress_bar_v2',
            'next_decode_card' => 'next_decode_card',
            'next_distorsion_tabs' => 'next_distorsion_tabs',
            'next_toolteam' => 'next_toolteam',
            'next_toast' => 'next_toast',
            'smoothscroll' => 'bc_smooth_scroll',
        ];

        //Load stylesheets from elements in HEADER
        $bricks_header = \Bricks\Helpers::get_bricks_data( get_the_ID(), 'header' );
        $this->load_elements_from_this_part($elements, $bricks_header);

        //Load stylesheets from elements in CONTENT
        $bricks_content = \Bricks\Helpers::get_bricks_data( get_the_ID(), 'content' );
        $this->load_elements_from_this_part($elements, $bricks_content);

        //Load stylesheets from elements in CONTENT (BRICKS POST TYPE)
		$bricks_post_content = get_post_meta( get_the_ID(), BRICKS_DB_PAGE_CONTENT, true );
		$this->load_elements_from_this_part($elements, $bricks_post_content);

        //Load stylesheets from elements in FOOTER
        $bricks_footer = \Bricks\Helpers::get_bricks_data( get_the_ID(), 'footer' );
        $this->load_elements_from_this_part($elements, $bricks_footer);
		
		//Load stylesheets from elements in section TEMPLATES
		$templates_section = \Bricks\Templates::get_templates_by_type('section');
		foreach ($templates_section as $template) {
			$templateID = $template;
			$template_part = get_post_meta($templateID, BRICKS_DB_PAGE_CONTENT, true);
			$this->load_elements_from_this_part($elements, $template_part);
		}
		
		//Load stylesheets from elements in popup TEMPLATES
		$templates_section = \Bricks\Templates::get_templates_by_type('popup');
		foreach ($templates_section as $template) {
			$templateID = $template;
			$template_part = get_post_meta($templateID, BRICKS_DB_PAGE_CONTENT, true);
			$this->load_elements_from_this_part($elements, $template_part);
		}

        //Load stylesheets from elements in WooCommerce TEMPLATES
		$templates_section = \Bricks\Templates::get_templates_by_type('wc_archive');
		foreach ($templates_section as $template) {
			$templateID = $template;
			$template_part = get_post_meta($templateID, BRICKS_DB_PAGE_CONTENT, true);
			$this->load_elements_from_this_part($elements, $template_part);
		}

        //Load stylesheets from elements in WooCommerce TEMPLATES by type
        $wc_template_types = [
            'wc_archive', 'wc_product', 'wc_cart', 'wc_cart_empty', 'wc_form_checkout',
            'wc_form_pay', 'wc_thankyou', 'wc_order_receipt', 'wc_account_dashboard',
            'wc_account_orders', 'wc_account_view_order', 'wc_account_downloads',
            'wc_account_addresses', 'wc_account_form_edit_address', 'wc_account_form_edit_account',
            'wc_account_form_login', 'wc_account_form_lost_password', 'wc_account_form_lost_password_confirmation',
            'wc_account_reset_password'
        ];
        foreach ($wc_template_types as $template_type) {
            $templates_section = \Bricks\Templates::get_templates_by_type($template_type);
            foreach ($templates_section as $template) {
                $templateID = $template;
                $template_part = get_post_meta($templateID, BRICKS_DB_PAGE_CONTENT, true);
                $this->load_elements_from_this_part($elements, $template_part);
            }
        }

        //Load stylesheets from elements in TEMPLATES in Header
        if (is_array($bricks_header)) {
            foreach ($bricks_header as $element) {
                if (isset($element['name']) && $element['name'] === 'template' && isset($element['settings']['template'])) {
                    $templateID = $element['settings']['template'];
                    $template_part = get_post_meta($templateID, BRICKS_DB_PAGE_CONTENT, true);
                    $this->load_elements_from_this_part($elements, $template_part);
                }
            }
        }

        //Load stylesheets from elements in TEMPLATES in Content
        if (is_array($bricks_content)) {
            foreach ($bricks_content as $element) {
                if (isset($element['name']) && $element['name'] === 'template' && isset($element['settings']['template'])) {
                    $templateID = $element['settings']['template'];
                    $template_part = get_post_meta($templateID, BRICKS_DB_PAGE_CONTENT, true);
                    $this->load_elements_from_this_part($elements, $template_part);
                }
            }
        }

        //Load stylesheets from elements in TEMPLATES in Footer
        if (is_array($bricks_footer)) {
            foreach ($bricks_footer as $element) {
                if (isset($element['name']) && $element['name'] === 'template' && isset($element['settings']['template'])) {
                    $templateID = $element['settings']['template'];
                    $template_part = get_post_meta($templateID, BRICKS_DB_PAGE_CONTENT, true);
                    $this->load_elements_from_this_part($elements, $template_part);
                }
            }
        }

        // Load stylesheets from elements in TEMPLATES in SHORTCODES in Header
        if (is_array($bricks_header)) {
            foreach ($bricks_header as $element) {
                if (isset($element['name']) && $element['name'] === 'shortcode' && isset($element['settings']['shortcode'])) {
                    if (preg_match('/\[bricks_template id="(\d+)"\]/', $element['settings']['shortcode'], $matches)) {
                        $templateID = $matches[1];
                        $template_part = get_post_meta($templateID, BRICKS_DB_PAGE_CONTENT, true);
                        $this->load_elements_from_this_part($elements, $template_part);
                    }
                }
            }
        }

        // Load stylesheets from elements in TEMPLATES in SHORTCODES in Content
        if (is_array($bricks_content)) {
            foreach ($bricks_content as $element) {
                if (isset($element['name']) && $element['name'] === 'shortcode' && isset($element['settings']['shortcode'])) {
                    if (preg_match('/\[bricks_template id="(\d+)"\]/', $element['settings']['shortcode'], $matches)) {
                        $templateID = $matches[1];
                        $template_part = get_post_meta($templateID, BRICKS_DB_PAGE_CONTENT, true);
                        $this->load_elements_from_this_part($elements, $template_part);
                    }
                }
            }
        }

        // Load stylesheets from elements in TEMPLATES in SHORTCODES in Footer
        if (is_array($bricks_footer)) {
            foreach ($bricks_footer as $element) {
                if (isset($element['name']) && $element['name'] === 'shortcode' && isset($element['settings']['shortcode'])) {
                    if (preg_match('/\[bricks_template id="(\d+)"\]/', $element['settings']['shortcode'], $matches)) {
                        $templateID = $matches[1];
                        $template_part = get_post_meta($templateID, BRICKS_DB_PAGE_CONTENT, true);
                        $this->load_elements_from_this_part($elements, $template_part);
                    }
                }
            }
        }
    }

    public function load_elements_from_this_part($elements, $part) {
        foreach ($elements as $elementName => $stylesheetName) {
            if (is_array($part)) {
                foreach ($part as $element) {
                    //Render component
                    if(isset($element['cid'])){
                        $component_instance = \Bricks\Helpers::get_component_instance( $element );
                        $this->load_elements_from_component($elements, $component_instance);
                    }
                    //Render element
                    if (isset($element['name']) && $element['name'] === $elementName) {
                        wp_enqueue_style($stylesheetName . '_stylesheet', NEXTBRICKS_PLUGIN_URL . 'elements/css/' . $stylesheetName . '.css', array('bricks-frontend'), NEXTBRICKS_VERSION, false);
                        break;
                    }
                }
            }
        }
    }
    public function load_elements_from_component($elements,$component) {
        foreach ($elements as $elementName => $stylesheetName) {
            if (is_array($component) && isset($component['elements'])) {
                foreach ($component['elements'] as $element) {
                    //Render element
                    if (isset($element['name']) && $element['name'] === $elementName) {
                        wp_enqueue_style($stylesheetName . '_stylesheet', NEXTBRICKS_PLUGIN_URL . 'elements/css/' . $stylesheetName . '.css', array('bricks-frontend'), NEXTBRICKS_VERSION, false);
                        break;
                    }
                }
            }
        }
    }
}