<?php

namespace NextBricks;

use Bricks\Breakpoints;

if ( ! defined( 'ABSPATH' ) ) exit;

class Next_UI {
    public function init() {
        add_action( 'wp_enqueue_scripts', array( $this, 'launch_core_ui' ) );
        add_action('wp_ajax_get_theme_from_core_ui_switch', array($this, 'get_theme_from_core_ui_switch')); //Get stored theme from JS
        add_action('wp_ajax_nopriv_get_theme_from_core_ui_switch', array($this, 'get_theme_from_core_ui_switch')); //Get stored theme from JS
    }

    public function launch_core_ui() {
        if ( function_exists('bricks_is_builder') ){
            if ( bricks_is_builder() && !bricks_is_builder_iframe()) {
                wp_enqueue_script( 'jquery-core' ); //Load jQuery without jQuery migrate (only at the builder)

                //Print loader HTML at the builder
                add_action('wp_footer', array($this, 'generate_input'), PHP_INT_MAX);

                //Core UI is design for ltr
                if ( is_rtl() ) {
                    wp_dequeue_style( 'bricks-builder-rtl' );
                    wp_deregister_style( 'bricks-builder-rtl' );
                }
    
                //Load Core UI CSS and JS
                wp_enqueue_style( 'nextui', NEXTBRICKS_PLUGIN_URL . 'features/nextui.min.css', [], NEXTBRICKS_VERSION, false );
                wp_enqueue_script( 'nextui', NEXTBRICKS_PLUGIN_URL . 'features/nextui.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false );
    
                //Send if Advanced Themer is active (to not move structure to left even if the user wants to)
                wp_localize_script('nextui', 'IsAdvancedThemerActive', array( 'active' => is_plugin_active('bricks-advanced-themer/bricks-advanced-themer.php') ));
                //Send user choices
                wp_localize_script('nextui', 'WPURLS', array( 'siteurl' => get_option('siteurl') ));
                wp_localize_script('nextui', 'BCUILeftStructure', array( 'left_structure' => get_option('bc_core_ui_left_structure_enable') ));
                wp_localize_script('nextui', 'BCUIImage', array( 'image_path' => get_option('bc_core_ui_logo') ));
                wp_localize_script('nextui', 'BCUILink', array( 'link' => get_option('bc_core_ui_link') ));
                //Send custom accent color (declare #3858E9 as default) to JS
                wp_localize_script('nextui', 'BCUIAccentColor', array(
                    'accent_color' => get_option('bc_core_ui_color') ? get_option('bc_core_ui_color') : '#3858E9'
                ));

                //Send stored theme to JS
                wp_localize_script('nextui', 'data_core_ui_theme', array(
                    'selected_theme' => get_option('core_ui_theme') ? get_option('core_ui_theme') : 'dark',
                    'ajaxurl' => admin_url('admin-ajax.php'),
                ));
            }
        }
    }

    function get_theme_from_core_ui_switch() {
        if (isset($_POST['CoreUItheme'])) {
            $CoreUItheme = $_POST['CoreUItheme']; //Get animator data from JS
            update_option('core_ui_theme', $CoreUItheme); //Store variable
        }
        wp_die();
    }

    function generate_input() {
        // Print loader HTML at the builder
        echo '
        <div class="nextui-loader core-ui--'.get_option('core_ui_theme').'-theme">
            <img class="nextui-loader-logo" src="'.(get_option('bc_core_ui_logo') ? get_option('bc_core_ui_logo') : 'https://nextbricks.io/wp-content/uploads/2024/07/nextbricks_nextui.png').'">
            <div class="nextui-progress">
                <div class="nextui-progress-bar"></div>
            </div>
        </div>';
    }
}