<?php
namespace Bricks;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed Woocommerce_directly

class Woocommerce_Theme_Styles {
	public function __construct() {
		add_filter( 'bricks/theme_styles/control_groups', [ $this, 'set_groups' ] );
		add_filter( 'bricks/theme_styles/controls', [ $this, 'set_controls' ] );
	}

	/**
	 * Add Woo Theme style control groups
	 */
	public function set_groups( $control_groups ) {
		$control_groups['woocommerce-button'] = [
			'title'  => 'WooCommerce - ' . esc_html__( 'Button', 'bricks' ),
			'parent' => 'elements', // @since 2.0
		];

		$control_groups['woocommerce-notice'] = [
			'title'  => 'WooCommerce - ' . esc_html__( 'Notice', 'bricks' ),
			'parent' => 'elements', // @since 2.0
		];

		return $control_groups;
	}

	/**
	 * Add Woo Theme style controls
	 */
	public function set_controls( $controls ) {
		// @since 1.11.1: Selector for WooCommerce button (for non-WooCommerce pages)
		$button_selectors = [
			'.woocommerce .button',
			'body:not(.woocommerce) .product_type_variable',
			'body:not(.woocommerce) .product_type_grouped',
			'body:not(.woocommerce) .product_type_external',
			'body:not(.woocommerce) .product_type_simple',
			// For woo quick view popup, in builder (@since 1.11.1.1)
			'body:not(.woocommerce) .brx-popup-content:not(.woocommerce) form.cart .single_add_to_cart_button',
			// WooCommerce mini cart buttons (outside of Woo pages) (@since 2.0.2)
			'body:not(.woocommerce) .brxe-woocommerce-mini-cart .woocommerce-mini-cart__buttons .button',
		];

		$button_selectors = implode( ', ', $button_selectors );

		// WooCommerce - Button
		$controls['woocommerce-button'] = [
			'padding'    => [
				'group' => 'woocommerce-button',
				'label' => esc_html__( 'Padding', 'bricks' ),
				'type'  => 'spacing',
				'css'   => [
					[
						'selector' => $button_selectors,
						'property' => 'padding',
					],
				],
			],

			'background' => [
				'group' => 'woocommerce-button',
				'label' => esc_html__( 'Background color', 'bricks' ),
				'type'  => 'color',
				'css'   => [
					[
						'selector' => $button_selectors,
						'property' => 'background-color',
					]
				],
			],

			'border'     => [
				'group' => 'woocommerce-button',
				'label' => esc_html__( 'Border', 'bricks' ),
				'type'  => 'border',
				'css'   => [
					[
						'selector' => $button_selectors,
						'property' => 'border',
					]
				],
			],

			'typography' => [
				'group' => 'woocommerce-button',
				'label' => esc_html__( 'Typography', 'bricks' ),
				'type'  => 'typography',
				'css'   => [
					[
						'selector' => $button_selectors,
						'property' => 'font',
					]
				],
			],
		];

		// WooCommerce - Notice (@since 1.8.1)
		$controls['woocommerce-notice'] = $this->get_woo_notice_controls();

		return $controls;
	}

	/**
	 * Get WooCommerce notice controls for Theme Styles
	 *
	 * @since 1.6.2
	 * @return array
	 */
	private function get_woo_notice_controls() {
		$controls = [];

		// CSS selector with higher specificity than the default selector in _messages.scss necessary to override the default styles
		// .woocommerce-NoticeGroup is the wrapper generated by WooCommerce in Checkout page via JS
		// Change selector for WooCommerce 8.6 classic notices (@since 1.9.7)
		$sections = [
			'error'   => [
				'div'  => '.woocommerce-notices-wrapper .woocommerce-error, .woocommerce-NoticeGroup .woocommerce-error',
				'link' => '.woocommerce-notices-wrapper .woocommerce-error a, .woocommerce-NoticeGroup .woocommerce-error a.button',
			],

			'success' => [
				'div'  => '.woocommerce-notices-wrapper .woocommerce-message, .woocommerce-NoticeGroup .woocommerce-message',
				'link' => '.woocommerce-notices-wrapper .woocommerce-message a, .woocommerce-NoticeGroup .woocommerce-message a.button',
			],

			'notice'  => [
				'div'  => '.woocommerce-notices-wrapper .woocommerce-info, .woocommerce-NoticeGroup .woocommerce-info, .woocommerce-info',
				'link' => '.woocommerce-notices-wrapper .woocommerce-info a, .woocommerce-NoticeGroup .woocommerce-info a.button, .woocommerce-info a, .woocommerce-info a.button',
			],
		];

		$group = 'woocommerce-notice';

		foreach ( $sections as $section => $types ) {
			foreach ( $types as $type => $selector ) {
				// successMargin, successLinkMargin, noticeMargin, noticeLinkMargin, errorMargin, errorLinkMargin
				$control_prefix = $section;

				$label = esc_html__( 'Type', 'bricks' ) . ' - ' . ucfirst( $section );

				if ( $type === 'link' ) {
					$label          = "$label: " . esc_html__( 'Link', 'bricks' );
					$control_prefix = "{$control_prefix}Link";
				}

				$controls[ $control_prefix . 'Separator' ] = [
					'tab'   => 'content',
					'label' => $label,
					'group' => $group,
					'type'  => 'separator',
				];

				$controls[ $control_prefix . 'Margin' ] = [
					'label' => esc_html__( 'Margin', 'bricks' ),
					'group' => $group,
					'type'  => 'spacing',
					'css'   => [
						[
							'property' => 'margin',
							'selector' => $selector,
						],
					],
				];

				$controls[ $control_prefix . 'Padding' ] = [
					'label' => esc_html__( 'Padding', 'bricks' ),
					'group' => $group,
					'type'  => 'spacing',
					'css'   => [
						[
							'property' => 'padding',
							'selector' => $selector,
						],
					],
				];

				$controls[ $control_prefix . 'BackgroundColor' ] = [
					'label' => esc_html__( 'Background color', 'bricks' ),
					'group' => $group,
					'type'  => 'color',
					'css'   => [
						[
							'property' => 'background-color',
							'selector' => $selector,
						],
					],
				];

				$controls[ $control_prefix . 'Border' ] = [
					'label' => esc_html__( 'Border', 'bricks' ),
					'group' => $group,
					'type'  => 'border',
					'css'   => [
						[
							'property' => 'border',
							'selector' => $selector,
						],
					],
				];

				$controls[ $control_prefix . 'BoxShadow' ] = [
					'label' => esc_html__( 'Box shadow', 'bricks' ),
					'group' => $group,
					'type'  => 'box-shadow',
					'css'   => [
						[
							'property' => 'box-shadow',
							'selector' => $selector,
						],
					],
				];

				$controls[ $control_prefix . 'Typography' ] = [
					'group' => $group,
					'label' => esc_html__( 'Typography', 'bricks' ),
					'type'  => 'typography',
					'css'   => [
						[
							'property' => 'font',
							'selector' => $selector,
						],
					],
				];
			}
		}

		return $controls;
	}
}
